/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.rewrite;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Modifier;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ParameterizedType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TryStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.VariableDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.dom.rewrite.RewriteEventStore;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public final class NodeInfoStore {
    private AST ast;
    private Map placeholderNodes;
    private Set collapsedNodes;

    public NodeInfoStore(AST ast) {
        this.ast = ast;
        this.placeholderNodes = null;
        this.collapsedNodes = null;
    }

    public final void markAsStringPlaceholder(ASTNode placeholder, String code) {
        StringPlaceholderData data = new StringPlaceholderData();
        data.code = code;
        this.setPlaceholderData(placeholder, data);
    }

    public final ASTNode newPlaceholderNode(int nodeType) {
        try {
            ASTNode node = this.ast.createInstance(nodeType);
            switch (node.getNodeType()) {
                case 23: {
                    ((FieldDeclaration)node).fragments().add(this.ast.newVariableDeclarationFragment());
                    break;
                }
                case 83: {
                    ((Modifier)node).setKeyword(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                    break;
                }
                case 54: {
                    ((TryStatement)node).setFinally(this.ast.newBlock());
                    break;
                }
                case 58: {
                    ((VariableDeclarationExpression)node).fragments().add(this.ast.newVariableDeclarationFragment());
                    break;
                }
                case 60: {
                    ((VariableDeclarationStatement)node).fragments().add(this.ast.newVariableDeclarationFragment());
                    break;
                }
                case 74: {
                    ((ParameterizedType)node).typeArguments().add(this.ast.newWildcardType());
                }
            }
            return node;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean isCollapsed(ASTNode node) {
        if (this.collapsedNodes != null) {
            return this.collapsedNodes.contains(node);
        }
        return false;
    }

    public Object getPlaceholderData(ASTNode node) {
        if (this.placeholderNodes != null) {
            return this.placeholderNodes.get(node);
        }
        return null;
    }

    private void setPlaceholderData(ASTNode node, PlaceholderData data) {
        if (this.placeholderNodes == null) {
            this.placeholderNodes = new IdentityHashMap();
        }
        this.placeholderNodes.put(node, data);
    }

    protected static final class CopyPlaceholderData
    extends PlaceholderData {
        public RewriteEventStore.CopySourceInfo copySource;

        protected CopyPlaceholderData() {
        }

        public String toString() {
            return "[placeholder " + this.copySource + "]";
        }
    }

    static class PlaceholderData {
        PlaceholderData() {
        }
    }

    protected static final class StringPlaceholderData
    extends PlaceholderData {
        public String code;

        protected StringPlaceholderData() {
        }

        public String toString() {
            return "[placeholder string: " + this.code + "]";
        }
    }
}

