/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.hierarchy;

import io.spring.javaformat.eclipse.jdt.jdk11.core.Signature;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.TypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryField;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryMethod;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryNestedType;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryType;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryTypeAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IRecordComponent;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.ITypeAnnotationWalker;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.BinaryTypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.LookupEnvironment;

public class HierarchyBinaryType
implements IBinaryType {
    private int modifiers;
    private char[] sourceName;
    private char[] name;
    private char[] enclosingTypeName;
    private char[] superclass;
    private char[][] superInterfaces = NoInterface;
    private char[][] typeParameterSignatures;
    private char[] genericSignature;

    public HierarchyBinaryType(int modifiers, char[] qualification, char[] sourceName, char[] enclosingTypeName, char[][] typeParameterSignatures, char typeSuffix) {
        this.modifiers = modifiers;
        this.sourceName = sourceName;
        if (enclosingTypeName == null) {
            this.name = CharOperation.concat(qualification, sourceName, '/');
        } else {
            this.name = CharOperation.concat(qualification, '/', enclosingTypeName, '$', sourceName);
            this.enclosingTypeName = CharOperation.concat(qualification, enclosingTypeName, '/');
            CharOperation.replace(this.enclosingTypeName, '.', '/');
        }
        this.typeParameterSignatures = typeParameterSignatures;
        CharOperation.replace(this.name, '.', '/');
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return null;
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }

    @Override
    public char[] getEnclosingMethod() {
        return null;
    }

    @Override
    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    @Override
    public IBinaryField[] getFields() {
        return null;
    }

    @Override
    public char[] getFileName() {
        return null;
    }

    @Override
    public char[] getGenericSignature() {
        if (this.typeParameterSignatures != null && this.genericSignature == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            int i = 0;
            int length = this.typeParameterSignatures.length;
            while (i < length) {
                buffer.append(this.typeParameterSignatures[i]);
                ++i;
            }
            buffer.append('>');
            if (this.superclass == null) {
                buffer.append(Signature.createTypeSignature("java.lang.Object", true));
            } else {
                buffer.append(Signature.createTypeSignature(this.superclass, true));
            }
            if (this.superInterfaces != null) {
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    buffer.append(Signature.createTypeSignature(this.superInterfaces[i], true));
                    ++i;
                }
            }
            this.genericSignature = buffer.toString().toCharArray();
            CharOperation.replace(this.genericSignature, '.', '/');
        }
        return this.genericSignature;
    }

    @Override
    public char[][] getInterfaceNames() {
        return this.superInterfaces;
    }

    @Override
    public IBinaryNestedType[] getMemberTypes() {
        return null;
    }

    @Override
    public IBinaryMethod[] getMethods() {
        return null;
    }

    @Override
    public char[][][] getMissingTypeNames() {
        return null;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public char[] getName() {
        return this.name;
    }

    @Override
    public char[] getSourceName() {
        return this.sourceName;
    }

    @Override
    public char[] getSuperclassName() {
        return this.superclass;
    }

    @Override
    public long getTagBits() {
        return 0L;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    public void recordSuperType(char[] superTypeName, char[] superQualification, char superClassOrInterface) {
        int length;
        if (superQualification != null && superQualification[(length = superQualification.length) - 1] == '$') {
            char[] enclosingSuperName = CharOperation.lastSegment(superQualification, '.');
            superTypeName = CharOperation.concat(enclosingSuperName, superTypeName);
            superQualification = CharOperation.subarray(superQualification, 0, length - enclosingSuperName.length - 1);
        }
        if (superClassOrInterface == 'C') {
            if (TypeDeclaration.kind(this.modifiers) == 2) {
                return;
            }
            char[] encodedName = CharOperation.concat(superQualification, superTypeName, '/');
            CharOperation.replace(encodedName, '.', '/');
            this.recordSuperclass(encodedName);
        } else {
            char[] encodedName = CharOperation.concat(superQualification, superTypeName, '/');
            CharOperation.replace(encodedName, '.', '/');
            this.recordInterface(encodedName);
        }
    }

    public void recordSuperclass(char[] binaryName) {
        this.superclass = binaryName;
    }

    public void recordInterface(char[] binaryName) {
        if (this.superInterfaces == NoInterface) {
            this.superInterfaces = new char[][]{binaryName};
        } else {
            int length = this.superInterfaces.length;
            char[][] cArrayArray = new char[length + 1][];
            this.superInterfaces = cArrayArray;
            System.arraycopy(this.superInterfaces, 0, cArrayArray, 0, length);
            this.superInterfaces[length] = binaryName;
        }
    }

    @Override
    public char[] sourceFileName() {
        return null;
    }

    public String toString() {
        int length;
        StringBuilder buffer = new StringBuilder();
        if (this.modifiers == 1) {
            buffer.append("public ");
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 1: {
                buffer.append("class ");
                break;
            }
            case 2: {
                buffer.append("interface ");
                break;
            }
            case 3: {
                buffer.append("enum ");
                break;
            }
            case 5: {
                buffer.append("record ");
            }
        }
        if (this.name != null) {
            buffer.append(this.name);
        }
        if (this.superclass != null) {
            buffer.append("\n  extends ");
            buffer.append(this.superclass);
        }
        if (this.superInterfaces != null && (length = this.superInterfaces.length) != 0) {
            buffer.append("\n implements ");
            int i = 0;
            while (i < length) {
                buffer.append(this.superInterfaces[i]);
                if (i != length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    public ITypeAnnotationWalker enrichWithExternalAnnotationsFor(ITypeAnnotationWalker walker, Object member, LookupEnvironment environment) {
        return walker;
    }

    @Override
    public char[] getModule() {
        return null;
    }

    @Override
    public BinaryTypeBinding.ExternalAnnotationStatus getExternalAnnotationStatus() {
        return BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED;
    }

    @Override
    public IRecordComponent[] getRecordComponents() {
        return null;
    }
}

