/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.index;

import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.index.IndexLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class FileIndexLocation
extends IndexLocation {
    File indexFile;

    public FileIndexLocation(File file) {
        super(file);
        this.indexFile = file;
    }

    public FileIndexLocation(URL url, File file) {
        super(url);
        this.indexFile = file;
    }

    public FileIndexLocation(File file, boolean participantIndex) {
        this(file);
        this.participantIndex = true;
    }

    @Override
    public boolean createNewFile() throws IOException {
        File directory = this.indexFile.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        return this.indexFile.createNewFile();
    }

    @Override
    public boolean delete() {
        return this.indexFile.delete();
    }

    public boolean equals(Object other) {
        if (!(other instanceof FileIndexLocation)) {
            return false;
        }
        return this.indexFile.equals(((FileIndexLocation)other).indexFile);
    }

    @Override
    public boolean exists() {
        return this.indexFile.exists();
    }

    @Override
    public String fileName() {
        return this.indexFile.getName();
    }

    @Override
    public File getIndexFile() {
        return this.indexFile;
    }

    @Override
    InputStream getInputStream() throws IOException {
        return new FileInputStream(this.indexFile);
    }

    @Override
    public String getCanonicalFilePath() {
        try {
            return this.indexFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        return this.indexFile.hashCode();
    }

    @Override
    public long lastModified() {
        return this.indexFile.lastModified();
    }

    @Override
    public long length() {
        return this.indexFile.length();
    }
}

