/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.nd.java.model;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IOrdinaryClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.classfmt.ClassFileReader;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.classfmt.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryType;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.SuffixConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JarPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.nd.java.model.BinaryTypeDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.nd.util.CharArrayUtils;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class BinaryTypeFactory {
    private static BinaryTypeDescriptor createDescriptor(PackageFragment pkg, ClassFile classFile) {
        String indexPath;
        PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
        IPath location = BinaryTypeFactory.getLocationForElement(root);
        if (location == null) {
            return null;
        }
        String entryName = Util.concatWith(pkg.names, classFile.getElementName(), '/');
        String name = Util.concatWith(pkg.names, classFile.getName(), '/');
        String overridePath = root.getClassFilePath(entryName);
        if (overridePath != entryName) {
            entryName = overridePath;
            String versionPath = overridePath.substring(0, overridePath.indexOf(entryName));
            name = String.valueOf(versionPath) + name;
        }
        char[] fieldDescriptor = CharArrayUtils.concat(new char[]{'L'}, name.toCharArray(), new char[]{';'});
        IPath workspacePath = root.getPath();
        if (root instanceof JarPackageFragmentRoot) {
            indexPath = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
        } else {
            location = location.append(entryName);
            indexPath = workspacePath.append(entryName).toString();
            workspacePath = classFile.resource().getFullPath();
        }
        return new BinaryTypeDescriptor(location.toString().toCharArray(), fieldDescriptor, workspacePath.toString().toCharArray(), indexPath.toCharArray());
    }

    public static BinaryTypeDescriptor createDescriptor(IClassFile classFile) {
        ClassFile concreteClass = (ClassFile)classFile;
        PackageFragment parent = (PackageFragment)classFile.getParent();
        return BinaryTypeFactory.createDescriptor(parent, concreteClass);
    }

    public static IBinaryType create(IOrdinaryClassFile classFile, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        BinaryTypeDescriptor descriptor = BinaryTypeFactory.createDescriptor(classFile);
        return BinaryTypeFactory.readType(descriptor, monitor);
    }

    public static IBinaryType readType(BinaryTypeDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        return BinaryTypeFactory.rawReadType(descriptor, true);
    }

    public static ClassFileReader rawReadType(BinaryTypeDescriptor descriptor, boolean fullyInitialize) throws JavaModelException, ClassFormatException {
        try {
            return BinaryTypeFactory.rawReadTypeTestForExists(descriptor, fullyInitialize, true);
        }
        catch (FileNotFoundException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public static ClassFileReader rawReadTypeTestForExists(BinaryTypeDescriptor descriptor, boolean fullyInitialize, boolean useInvalidArchiveCache) throws JavaModelException, ClassFormatException, FileNotFoundException {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.isInJarFile()) {
            if (CharOperation.indexOf("jrt-fs.jar".toCharArray(), descriptor.location, false) == -1) {
                ZipFile zip;
                block23: {
                    zip = null;
                    try {
                        byte[] contents;
                        zip = JavaModelManager.getJavaModelManager().getZipFile((IPath)new Path(new String(descriptor.workspacePath)), useInvalidArchiveCache);
                        char[] entryNameCharArray = CharArrayUtils.concat(BinaryTypeFactory.fieldDescriptorToBinaryName(descriptor.fieldDescriptor), SuffixConstants.SUFFIX_class);
                        String entryName = new String(entryNameCharArray);
                        ZipEntry ze22 = zip.getEntry(entryName);
                        if (ze22 == null) break block23;
                        try {
                            contents = io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util.getZipEntryByteContent(ze22, zip);
                        }
                        catch (IOException ioe) {
                            throw new JavaModelException(ioe, 985);
                        }
                        ClassFileReader classFileReader = new ClassFileReader(contents, descriptor.indexPath, fullyInitialize);
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        return classFileReader;
                    }
                    catch (CoreException e) {
                        try {
                            throw new JavaModelException(e);
                        }
                        catch (Throwable throwable) {
                            JavaModelManager.getJavaModelManager().closeZipFile(zip);
                            throw throwable;
                        }
                    }
                }
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
            }
        } else {
            byte[] contents;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(new String(descriptor.workspacePath)));
            try {
                Throwable entryName = null;
                Object ze22 = null;
                try (InputStream stream = file.getContents(true);){
                    contents = io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util.getInputStreamAsByteArray(stream);
                }
                catch (Throwable ze22) {
                    if (entryName == null) {
                        entryName = ze22;
                    } else if (entryName != ze22) {
                        entryName.addSuppressed(ze22);
                    }
                    throw entryName;
                }
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status.getCode() == 368) {
                    throw new FileNotFoundException();
                }
                throw new JavaModelException(e);
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            return new ClassFileReader(contents, file.getFullPath().toString().toCharArray(), fullyInitialize);
        }
        return null;
    }

    public static IPath getLocationForElement(IJavaElement next) {
        IResource resource = next.getResource();
        if (resource != null) {
            return resource.getLocation() == null ? Path.EMPTY : resource.getLocation();
        }
        return next.getPath();
    }

    public static char[] fieldDescriptorToBinaryName(char[] fieldDescriptor) {
        if (CharArrayUtils.startsWith(fieldDescriptor, 'L')) {
            int end = fieldDescriptor.length - 1;
            return CharArrayUtils.subarray(fieldDescriptor, 1, end);
        }
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }
}

