/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching;

import io.spring.javaformat.eclipse.jdt.jdk11.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IModuleAwareNameEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.NameEnvironmentAnswer;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.SuffixConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElementRequestor;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModel;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JrtPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.NameLookup;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.PackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.builder.ClasspathLocation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.ClasspathSourceDirectory;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class JavaSearchNameEnvironment
implements IModuleAwareNameEnvironment,
SuffixConstants {
    protected LinkedHashSet<ClasspathLocation> locationSet;
    Map<String, IModuleDescription> modules;
    private boolean modulesComputed = false;
    Map<String, ClasspathLocation> moduleLocations;
    Map<String, LinkedHashSet<ClasspathLocation>> moduleToClassPathLocations;
    protected Map<String, LinkedHashSet<ClasspathLocation>> packageNameToClassPathLocations;
    Map<String, ICompilationUnit> workingCopies;

    public JavaSearchNameEnvironment(IJavaProject javaProject, ICompilationUnit[] copies) {
        if (JavaSearchNameEnvironment.isComplianceJava9OrHigher(javaProject)) {
            this.moduleLocations = new HashMap<String, ClasspathLocation>();
            this.moduleToClassPathLocations = new HashMap<String, LinkedHashSet<ClasspathLocation>>();
        }
        this.modules = new HashMap<String, IModuleDescription>();
        this.packageNameToClassPathLocations = new HashMap<String, LinkedHashSet<ClasspathLocation>>();
        long start = 0L;
        if (NameLookup.VERBOSE) {
            Util.verbose(" BUILDING JavaSearchNameEnvironment");
            Util.verbose(" -> project: " + javaProject);
            Util.verbose(" -> working copy size: " + (copies == null ? 0 : copies.length));
            start = System.currentTimeMillis();
        }
        this.locationSet = this.computeClasspathLocations((JavaProject)javaProject);
        this.workingCopies = JavaSearchNameEnvironment.getWorkingCopyMap(copies);
        if (this.workingCopies.size() > 0) {
            Optional<ClasspathLocation> firstSrcLocation = this.locationSet.stream().filter(cp -> cp instanceof ClasspathSourceDirectory).findFirst();
            if (!firstSrcLocation.isPresent()) {
                if (NameLookup.VERBOSE) {
                    Util.verbose(" -> ignoring working copies; no ClasspathSourceDirectory on project classpath ");
                }
            } else {
                for (String qualifiedMainTypeName : this.workingCopies.keySet()) {
                    int typeNameStart = qualifiedMainTypeName.lastIndexOf(47);
                    if (typeNameStart > 0) {
                        String pkgName = qualifiedMainTypeName.substring(0, typeNameStart);
                        this.addPackageNameToIndex(firstSrcLocation.get(), pkgName);
                        continue;
                    }
                    this.addPackageNameToIndex(firstSrcLocation.get(), "");
                }
            }
        }
        if (NameLookup.VERBOSE) {
            Util.verbose(" -> pkg roots size: " + (this.locationSet == null ? 0 : this.locationSet.size()));
            Util.verbose(" -> pkgs size: " + this.packageNameToClassPathLocations.size());
            Util.verbose(" -> spent: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public static Map<String, ICompilationUnit> getWorkingCopyMap(ICompilationUnit[] copies) {
        int length = copies == null ? 0 : copies.length;
        HashMap<String, ICompilationUnit> result = new HashMap<String, ICompilationUnit>(length);
        try {
            if (copies != null) {
                int i = 0;
                while (i < length) {
                    ICompilationUnit workingCopy = copies[i];
                    IPackageDeclaration[] pkgs = workingCopy.getPackageDeclarations();
                    String pkg = pkgs.length > 0 ? pkgs[0].getElementName() : "";
                    String cuName = workingCopy.getElementName();
                    String mainTypeName = Util.getNameWithoutJavaLikeExtension(cuName);
                    String qualifiedMainTypeName = pkg.length() == 0 ? mainTypeName : String.valueOf(pkg.replace('.', '/')) + '/' + mainTypeName;
                    result.put(qualifiedMainTypeName, workingCopy);
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    @Override
    public void cleanup() {
        this.locationSet.clear();
        this.packageNameToClassPathLocations.clear();
    }

    protected void addProjectClassPath(JavaProject javaProject) {
        LinkedHashSet<ClasspathLocation> locations;
        long start = 0L;
        if (NameLookup.VERBOSE) {
            Util.verbose(" EXTENDING JavaSearchNameEnvironment");
            Util.verbose(" -> project: " + javaProject);
            start = System.currentTimeMillis();
        }
        if ((locations = this.computeClasspathLocations(javaProject)) != null) {
            this.locationSet.addAll(locations);
        }
        if (NameLookup.VERBOSE) {
            Util.verbose(" -> pkg roots size: " + (this.locationSet == null ? 0 : this.locationSet.size()));
            Util.verbose(" -> pkgs size: " + this.packageNameToClassPathLocations.size());
            Util.verbose(" -> spent: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    private LinkedHashSet<ClasspathLocation> computeClasspathLocations(JavaProject javaProject) {
        IPackageFragmentRoot[] roots = null;
        try {
            roots = javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        IModuleDescription imd = null;
        try {
            imd = javaProject.getModuleDescription();
        }
        catch (JavaModelException javaModelException) {}
        LinkedHashSet<ClasspathLocation> locations = new LinkedHashSet<ClasspathLocation>();
        int length = roots.length;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            ClasspathLocation cp = this.mapToClassPathLocation(manager, (PackageFragmentRoot)roots[i], imd);
            if (cp != null) {
                try {
                    this.indexPackageNames(cp, roots[i]);
                    locations.add(cp);
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)((Object)e), "Error indexing package names!");
                }
            }
            ++i;
        }
        return locations;
    }

    private void indexPackageNames(ClasspathLocation cp, IPackageFragmentRoot root) throws JavaModelException {
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement c = iJavaElementArray[n2];
            String qualifiedPackageName = c.getElementName().replace('.', '/');
            this.addPackageNameToIndex(cp, qualifiedPackageName);
            ++n2;
        }
        char[][] packages = cp.listPackages();
        if (packages != null) {
            char[][] cArray = packages;
            int n3 = packages.length;
            n = 0;
            while (n < n3) {
                char[] packageName = cArray[n];
                String qualifiedPackageName = CharOperation.charToString(packageName).replace('.', '/');
                this.addPackageNameToIndex(cp, qualifiedPackageName);
                ++n;
            }
        }
    }

    private void addPackageNameToIndex(ClasspathLocation cp, String qualifiedPackageName) {
        LinkedHashSet<ClasspathLocation> cpl = this.packageNameToClassPathLocations.get(qualifiedPackageName);
        if (cpl == null) {
            cpl = new LinkedHashSet();
            this.packageNameToClassPathLocations.put(qualifiedPackageName, cpl);
        }
        cpl.add(cp);
    }

    private void computeModules() {
        if (!this.modulesComputed) {
            this.modulesComputed = true;
            JavaElementRequestor requestor = new JavaElementRequestor();
            try {
                IModuleDescription[] mods;
                JavaModelManager.getModulePathManager().seekModule(CharOperation.ALL_PREFIX, true, requestor);
                IModuleDescription[] iModuleDescriptionArray = mods = requestor.getModules();
                int n = mods.length;
                int n2 = 0;
                while (n2 < n) {
                    IModuleDescription mod = iModuleDescriptionArray[n2];
                    this.modules.putIfAbsent(mod.getElementName(), mod);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private ClasspathLocation mapToClassPathLocation(JavaModelManager manager, PackageFragmentRoot root, IModuleDescription defaultModule) {
        ClasspathLocation cp = null;
        IPath path = root.getPath();
        try {
            if (root.isArchive()) {
                ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                IJavaProject project = (IJavaProject)((Object)root.getParent());
                String compliance = project.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance", true);
                cp = root instanceof JrtPackageFragmentRoot ? ClasspathLocation.forJrtSystem(path.toOSString(), rawClasspathEntry.getAccessRuleSet(), null, compliance) : ClasspathLocation.forLibrary(manager.getZipFile(path), rawClasspathEntry.getAccessRuleSet(), rawClasspathEntry.isModular(), compliance);
            } else {
                Object target = JavaModel.getTarget(path, true);
                if (target != null) {
                    if (root.getKind() == 1) {
                        cp = new ClasspathSourceDirectory((IContainer)target, root.fullExclusionPatternChars(), root.fullInclusionPatternChars());
                    } else {
                        ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                        cp = ClasspathLocation.forBinaryFolder((IContainer)target, false, rawClasspathEntry.getAccessRuleSet(), null, rawClasspathEntry.isModular());
                    }
                }
            }
        }
        catch (CoreException coreException) {}
        JavaProject javaProject = root.getJavaProject();
        if (JavaSearchNameEnvironment.isComplianceJava9OrHigher(javaProject)) {
            this.addModuleClassPathInfo(root, defaultModule, cp);
        }
        return cp;
    }

    private void addModuleClassPathInfo(PackageFragmentRoot root, IModuleDescription defaultModule, ClasspathLocation cp) {
        IModuleDescription imd = root.getModuleDescription();
        if (imd != null) {
            String moduleName = this.addModuleClassPathInfo(cp, imd);
            if (moduleName != null) {
                this.modules.put(moduleName, imd);
            }
            if (this.moduleLocations != null) {
                this.moduleLocations.put(moduleName, cp);
            }
        } else if (defaultModule != null) {
            this.addModuleClassPathInfo(cp, defaultModule);
        }
    }

    private String addModuleClassPathInfo(ClasspathLocation cp, IModuleDescription imd) {
        char[] name;
        IModule mod = NameLookup.getModuleDescriptionInfo(imd);
        String moduleName = null;
        if (mod != null && cp != null && (name = mod.name()) != null) {
            moduleName = new String(name);
            cp.setModule(mod);
            this.addClassPathToModule(moduleName, cp);
        }
        return moduleName;
    }

    private void addClassPathToModule(String moduleName, ClasspathLocation cp) {
        if (this.moduleToClassPathLocations != null) {
            LinkedHashSet<ClasspathLocation> l = this.moduleToClassPathLocations.get(moduleName);
            if (l == null) {
                l = new LinkedHashSet();
                this.moduleToClassPathLocations.put(moduleName, l);
            }
            l.add(cp);
        }
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName, IModuleAwareNameEnvironment.LookupStrategy strategy, String moduleName) {
        String qPackageName;
        int typeNameStart;
        String binaryFileName = null;
        String qBinaryFileName = null;
        String sourceFileName = null;
        String qSourceFileName = null;
        if (qualifiedTypeName.length() > typeName.length) {
            typeNameStart = qualifiedTypeName.length() - typeName.length;
            qPackageName = qualifiedTypeName.substring(0, typeNameStart - 1);
        } else {
            typeNameStart = 0;
            qPackageName = "";
        }
        NameEnvironmentAnswer suggestedAnswer = null;
        for (ClasspathLocation location : this.getLocationsFor(moduleName, qPackageName)) {
            NameEnvironmentAnswer answer;
            if (!strategy.matches(location, ClasspathLocation::hasModule)) continue;
            if (location instanceof ClasspathSourceDirectory) {
                io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.ICompilationUnit workingCopy;
                if (sourceFileName == null) {
                    sourceFileName = qSourceFileName = qualifiedTypeName;
                    if (typeNameStart > 0) {
                        sourceFileName = qSourceFileName.substring(typeNameStart);
                    }
                }
                answer = (workingCopy = (io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.ICompilationUnit)((Object)this.workingCopies.get(qualifiedTypeName))) != null ? new NameEnvironmentAnswer(workingCopy, null) : location.findClass(sourceFileName, qPackageName, moduleName, qSourceFileName, false, null);
            } else {
                if (binaryFileName == null) {
                    binaryFileName = qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
                    if (typeNameStart > 0) {
                        binaryFileName = qBinaryFileName.substring(typeNameStart);
                    }
                }
                answer = location.findClass(binaryFileName, qPackageName, moduleName, qBinaryFileName, false, this.moduleLocations != null ? this.moduleLocations::containsKey : null);
            }
            if (answer == null) continue;
            if (!answer.ignoreIfBetter()) {
                if (!answer.isBetter(suggestedAnswer)) continue;
                if (NameLookup.VERBOSE) {
                    Util.verbose(" Result for JavaSearchNameEnvironment#findClass( " + qualifiedTypeName + ", " + CharOperation.charToString(typeName) + ", " + (Object)((Object)strategy) + ", " + moduleName + ")");
                    Util.verbose(" -> answer: " + answer);
                    Util.verbose(" -> location: " + location);
                }
                return answer;
            }
            if (!answer.isBetter(suggestedAnswer)) continue;
            suggestedAnswer = answer;
            if (!NameLookup.VERBOSE) continue;
            Util.verbose(" Potential answer for JavaSearchNameEnvironment#findClass( " + qualifiedTypeName + ", " + CharOperation.charToString(typeName) + ", " + (Object)((Object)strategy) + ", " + moduleName + ")");
            Util.verbose(" -> answer: " + answer);
            Util.verbose(" -> location: " + location);
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        if (NameLookup.VERBOSE) {
            Util.verbose(" NO result for JavaSearchNameEnvironment#findClass( " + qualifiedTypeName + ", " + CharOperation.charToString(typeName) + ", " + (Object)((Object)strategy) + ", " + moduleName + ")");
        }
        return null;
    }

    protected Iterable<ClasspathLocation> getLocationsFor(String moduleName, String qualifiedPackageName) {
        LinkedHashSet<ClasspathLocation> l;
        if (moduleName != null && (l = this.moduleToClassPathLocations.get(moduleName)) != null) {
            return l;
        }
        if (qualifiedPackageName != null) {
            LinkedHashSet<ClasspathLocation> cpls = this.packageNameToClassPathLocations.get(qualifiedPackageName);
            if (cpls == null) {
                if (NameLookup.VERBOSE) {
                    Util.verbose(" No result for JavaSearchNameEnvironment#getLocationsFor( " + moduleName + ", " + qualifiedPackageName + ")");
                }
                return Collections.emptySet();
            }
            if (NameLookup.VERBOSE) {
                Util.verbose(" Result for JavaSearchNameEnvironment#getLocationsFor( " + moduleName + ", " + qualifiedPackageName + ")");
                Util.verbose(" -> " + cpls.stream().map(Object::toString).collect(Collectors.joining(" | ")));
            }
            return cpls;
        }
        if (NameLookup.VERBOSE) {
            Util.verbose(" Potentially expensive search in JavaSearchNameEnvironment#getLocationsFor( " + moduleName + ", " + qualifiedPackageName + ")");
        }
        return this.locationSet;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName, IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1], IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
        }
        return null;
    }

    @Override
    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        String qualifiedPackageName = String.valueOf(CharOperation.concatWith(packageName, '/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        if (strategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            String moduleNameString;
            LinkedHashSet<ClasspathLocation> cpl;
            if (this.moduleToClassPathLocations != null && (cpl = this.moduleToClassPathLocations.get(moduleNameString = String.valueOf(moduleName))) != null) {
                for (ClasspathLocation cp : cpl) {
                    if (!cp.isPackage(qualifiedPackageName, moduleNameString)) continue;
                    return new char[][]{moduleName};
                }
            }
            return null;
        }
        char[][] moduleNames = CharOperation.NO_CHAR_CHAR;
        for (ClasspathLocation location : this.getLocationsFor(null, qualifiedPackageName)) {
            char[][] mNames;
            if (!strategy.matches(location, ClasspathLocation::hasModule) || !location.isPackage(qualifiedPackageName, null) || (mNames = location.getModulesDeclaringPackage(qualifiedPackageName, null)) == null || mNames.length == 0) continue;
            moduleNames = CharOperation.arrayConcat(moduleNames, mNames);
        }
        if (NameLookup.VERBOSE) {
            Util.verbose(" Result for JavaSearchNameEnvironment#getModulesDeclaringPackage( " + qualifiedPackageName + ", " + CharOperation.charToString(moduleName) + ")");
            Util.verbose(" -> " + CharOperation.toString(moduleNames));
        }
        return moduleNames == CharOperation.NO_CHAR_CHAR ? null : moduleNames;
    }

    @Override
    public char[][] listPackages(char[] moduleName) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Named: {
                if (this.moduleLocations != null) {
                    ClasspathLocation location = this.moduleLocations.get(String.valueOf(moduleName));
                    if (location == null) {
                        return CharOperation.NO_CHAR_CHAR;
                    }
                    return location.listPackages();
                }
                return CharOperation.NO_CHAR_CHAR;
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    @Override
    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        String qualifiedPackageNameString = String.valueOf(CharOperation.concatWith(qualifiedPackageName, '/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        String moduleNameString = IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName);
        if (strategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            ClasspathLocation location;
            if (this.moduleLocations != null && (location = this.moduleLocations.get(moduleNameString)) != null) {
                return location.hasCompilationUnit(qualifiedPackageNameString, moduleNameString);
            }
        } else {
            for (ClasspathLocation location : this.getLocationsFor(null, qualifiedPackageNameString)) {
                if (!strategy.matches(location, ClasspathLocation::hasModule) || !location.hasCompilationUnit(qualifiedPackageNameString, moduleNameString)) continue;
                if (NameLookup.VERBOSE) {
                    Util.verbose(" Result for JavaSearchNameEnvironment#hasCompilationUnit( " + qualifiedPackageNameString + ", " + moduleNameString + ")");
                    Util.verbose(" -> " + location);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public IModule getModule(char[] moduleName) {
        this.computeModules();
        IModuleDescription moduleDesc = this.modules.get(new String(moduleName));
        IModule module = null;
        try {
            if (moduleDesc != null) {
                module = (IModule)((JavaElement)((Object)moduleDesc)).getElementInfo();
            }
        }
        catch (JavaModelException javaModelException) {}
        return module;
    }

    @Override
    public char[][] getAllAutomaticModules() {
        if (this.moduleLocations == null || this.moduleLocations.size() == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        Set set = this.moduleLocations.values().stream().map(e -> e.getModule()).filter(m -> m != null && m.isAutomatic()).map(m -> m.name()).collect(Collectors.toSet());
        return (char[][])set.toArray((T[])new char[set.size()][]);
    }

    private static boolean isComplianceJava9OrHigher(IJavaProject javaProject) {
        if (javaProject == null) {
            return false;
        }
        return CompilerOptions.versionToJdkLevel(javaProject.getOption("io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.compliance", true)) >= 0x350000L;
    }
}

