/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.CompactConstructorDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.FieldReference;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.LocalDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.NameReference;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.QualifiedNameReference;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.ast.SingleNameReference;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.Binding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.FieldBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.LocalVariableBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.LocalVariable;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.SourceField;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.FieldPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.LocalVariablePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.MatchLocator;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.MatchingNodeSet;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.VariableLocator;
import org.eclipse.core.runtime.CoreException;

public class LocalVariableLocator
extends VariableLocator {
    public LocalVariableLocator(LocalVariablePattern pattern) {
        super(pattern);
    }

    @Override
    public int match(LocalDeclaration node, MatchingNodeSet nodeSet) {
        int referencesLevel = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && node.initialization != null && this.matchesName(this.pattern.name, node.name)) {
            referencesLevel = this.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, node.name) && node.declarationSourceStart == this.getLocalVariable().declarationSourceStart) {
            declarationsLevel = this.pattern.mustResolve ? 2 : 3;
        }
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    private LocalVariable getLocalVariable() {
        return ((LocalVariablePattern)this.pattern).localVariable;
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        int offset = -1;
        int length = -1;
        if (reference instanceof SingleNameReference) {
            offset = reference.sourceStart;
            length = reference.sourceEnd - offset + 1;
        } else if (reference instanceof QualifiedNameReference) {
            QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
            long sourcePosition = qNameRef.sourcePositions[0];
            offset = (int)(sourcePosition >>> 32);
            length = (int)sourcePosition - offset + 1;
        } else {
            if (reference instanceof LocalDeclaration) {
                LocalVariable localVariable = this.getLocalVariable();
                offset = localVariable.nameStart;
                length = localVariable.nameEnd - offset + 1;
                element = localVariable;
                this.match = locator.newDeclarationMatch(element, null, accuracy, offset, length);
                locator.report(this.match);
                return;
            }
            if (reference instanceof FieldReference) {
                FieldReference fieldReference = (FieldReference)reference;
                long position = fieldReference.nameSourcePosition;
                int start = (int)(position >>> 32);
                int end = (int)position;
                this.match = locator.newFieldReferenceMatch(element, null, elementBinding, accuracy, start, end - start + 1, fieldReference);
                locator.report(this.match);
                return;
            }
        }
        if (offset >= 0) {
            this.match = locator.newLocalVariableReferenceMatch(element, accuracy, offset, length, reference);
            locator.report(this.match);
        }
    }

    @Override
    protected int matchContainer() {
        return 4;
    }

    protected int matchLocalVariable(LocalVariableBinding variable, boolean matchName) {
        if (variable == null) {
            return 1;
        }
        if (matchName && !this.matchesName(this.pattern.name, variable.readableName())) {
            return 0;
        }
        return variable.declaration.declarationSourceStart == this.getLocalVariable().declarationSourceStart ? 3 : 0;
    }

    @Override
    protected int referenceType() {
        return 14;
    }

    @Override
    public int resolveLevel(ASTNode possiblelMatchingNode) {
        FieldBinding binding;
        if ((this.pattern.findReferences || this.pattern.fineGrain != 0) && possiblelMatchingNode instanceof NameReference) {
            return this.resolveLevel((NameReference)possiblelMatchingNode);
        }
        if (possiblelMatchingNode instanceof LocalDeclaration) {
            return this.matchLocalVariable(((LocalDeclaration)possiblelMatchingNode).binding, true);
        }
        if (possiblelMatchingNode instanceof FieldReference && (binding = ((FieldReference)possiblelMatchingNode).binding).isRecordComponent()) {
            return this.matchField(binding, true);
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof FieldBinding && ((FieldBinding)binding).isRecordComponent()) {
            return this.matchField(binding, true);
        }
        if (binding instanceof LocalVariableBinding && ((LocalVariableBinding)binding).declaringScope.referenceContext() instanceof CompactConstructorDeclaration && this.pattern instanceof FieldPattern) {
            return this.matchField(binding, true);
        }
        if (!(binding instanceof LocalVariableBinding)) {
            return 0;
        }
        return this.matchLocalVariable((LocalVariableBinding)binding, true);
    }

    private int matchField(Binding binding, boolean matchName) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof FieldBinding && !((FieldBinding)binding).declaringClass.isRecord()) {
            return 0;
        }
        if (this.pattern instanceof LocalVariablePattern) {
            LocalVariablePattern lvp = (LocalVariablePattern)this.pattern;
            LocalVariable localVariable = lvp.localVariable;
            JavaElement parent = localVariable.getParent();
            if (!(parent instanceof SourceField)) {
                return 0;
            }
        }
        if (matchName && this.matchesName(this.pattern.name, binding.readableName())) {
            return 3;
        }
        return 0;
    }

    protected int resolveLevel(NameReference nameRef) {
        return this.resolveLevel(nameRef.binding);
    }
}

