/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk11.core.search.ModuleReferenceMatch;
import io.spring.javaformat.eclipse.jdt.jdk11.core.search.PackageReferenceMatch;
import io.spring.javaformat.eclipse.jdt.jdk11.core.search.SearchMatch;
import io.spring.javaformat.eclipse.jdt.jdk11.core.search.SearchPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.core.search.TypeReferenceMatch;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IBinaryModule;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.ModuleBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.PackageBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.lookup.TypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.ModularClassFile;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.indexing.IIndexConstants;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.MatchLocator;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.ModulePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.OrPattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.PackageReferencePattern;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.core.runtime.CoreException;

public class ModularClassFileMatchLocator
implements IIndexConstants {
    private IBinaryModule binaryModule;
    private ModularClassFile modularClassFile;
    private IModuleDescription moduleDesc;
    private char[] moduleName;
    private ModuleBinding module;

    public void locateMatches(MatchLocator locator, ModularClassFile mClassFile) throws CoreException {
        SearchPattern pattern = locator.pattern;
        this.modularClassFile = mClassFile;
        this.binaryModule = this.modularClassFile.getBinaryModuleInfo();
        if (this.binaryModule == null) {
            return;
        }
        this.moduleDesc = mClassFile.getModule();
        this.moduleName = this.binaryModule.name();
        this.module = locator.lookupEnvironment.getModule(this.moduleName);
        this.matchModuleDeclaration(pattern, locator);
        this.matchModuleReferences(pattern, locator);
        this.matchPackageReferences(pattern, locator);
        this.matchTypeReferences(pattern, locator);
    }

    private void matchModuleDeclaration(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 8192: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    SearchPattern p = patterns[i];
                    if (p.kind == 8192) {
                        this.matchModuleReferences(patterns[i], locator);
                    }
                    ++i;
                }
            }
            default: {
                return;
            }
        }
        ModulePattern modulePattern = (ModulePattern)pattern;
        if (!locator.patternLocator.matchesName(modulePattern.name, this.moduleName)) {
            return;
        }
        ModuleBinding moduleBinding = null;
        int level = 3;
        if (locator.patternLocator.mustResolve) {
            moduleBinding = locator.lookupEnvironment.getModule(this.moduleName);
            level = locator.patternLocator.resolveLevel(moduleBinding);
        }
        if (level == 0) {
            return;
        }
        int accuracy = level == 3 ? 0 : 1;
        SearchMatch match = locator.newDeclarationMatch(this.moduleDesc, moduleBinding, accuracy, -1, 0);
        locator.report(match);
    }

    private void matchModuleReferences(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 8192: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    SearchPattern p = patterns[i];
                    if (p.kind == 8192) {
                        this.matchModuleReferences(patterns[i], locator);
                    }
                    ++i;
                }
            }
            default: {
                return;
            }
        }
        ModulePattern modulePattern = (ModulePattern)pattern;
        if (!modulePattern.findReferences) {
            return;
        }
        this.matchModuleReferences(locator, modulePattern, this.binaryModule.exports());
        this.matchModuleReferences(locator, modulePattern, this.binaryModule.opens());
        if (this.module != null) {
            this.matchModuleReferences(locator, modulePattern, this.module.getAllRequiredModules());
        }
    }

    private void matchModuleReference(MatchLocator locator, ModulePattern modulePattern, char[][] modules, boolean isTarget) throws CoreException {
        if (modules == null) {
            return;
        }
        char[][] cArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            char[] module1 = cArray[n2];
            if (module1 != null && module1.length != 0 && locator.patternLocator.matchesName(modulePattern.name, module1)) {
                ModuleReferenceMatch match = locator.newModuleReferenceMatch(this.moduleDesc, null, isTarget ? 0 : 1, -1, 0, null);
                locator.report(match);
            }
            ++n2;
        }
    }

    private void matchModuleReferences(MatchLocator locator, ModulePattern modulePattern, IModule.IPackageExport[] pvs) throws CoreException {
        if (pvs == null) {
            return;
        }
        IModule.IPackageExport[] iPackageExportArray = pvs;
        int n = pvs.length;
        int n2 = 0;
        while (n2 < n) {
            IModule.IPackageExport pv = iPackageExportArray[n2];
            this.matchModuleReference(locator, modulePattern, pv.targets(), true);
            ++n2;
        }
    }

    private void matchModuleReferences(MatchLocator locator, ModulePattern modulePattern, ModuleBinding[] refs) throws CoreException {
        if (refs == null) {
            return;
        }
        ModuleBinding[] moduleBindingArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            int level;
            ModuleBinding ref = moduleBindingArray[n2];
            char[] name = ref.name();
            if (name != null && (level = locator.patternLocator.resolveLevel(ref)) != 0) {
                int accuracy = level == 3 ? 0 : 1;
                ModuleReferenceMatch match = locator.newModuleReferenceMatch(this.moduleDesc, null, accuracy, -1, 0, null);
                locator.report(match);
            }
            ++n2;
        }
    }

    private void matchPackageReferences(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 1: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    SearchPattern p = patterns[i];
                    if (p.kind == 1) {
                        this.matchPackageReferences(patterns[i], locator);
                    }
                    ++i;
                }
            }
            default: {
                return;
            }
        }
        this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getExports());
        this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getOpens());
        this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getUses());
        TypeBinding[] services = this.module.getServices();
        if (services != null) {
            this.matchPackReferences(locator, (PackageReferencePattern)pattern, services);
            TypeBinding[] typeBindingArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding service = typeBindingArray[n2];
                this.matchPackReferences(locator, (PackageReferencePattern)pattern, this.module.getImplementations(service));
                ++n2;
            }
        }
    }

    private void matchPackReferences(MatchLocator locator, PackageReferencePattern packReferencePattern, PackageBinding[] packBindings) throws CoreException {
        if (packBindings == null) {
            return;
        }
        PackageBinding[] packageBindingArray = packBindings;
        int n = packBindings.length;
        int n2 = 0;
        while (n2 < n) {
            PackageBinding pb = packageBindingArray[n2];
            this.reportPackageMatch(locator, pb);
            ++n2;
        }
    }

    private void reportPackageMatch(MatchLocator locator, PackageBinding packageBinding) throws CoreException {
        if (packageBinding == null) {
            return;
        }
        int level = locator.patternLocator.resolveLevel(packageBinding);
        if (level == 0) {
            return;
        }
        int accuracy = level == 3 ? 0 : 1;
        PackageReferenceMatch match = locator.newPackageReferenceMatch(this.moduleDesc, accuracy, -1, 0, null);
        locator.report(match);
    }

    private void matchPackReferences(MatchLocator locator, PackageReferencePattern packReferencePattern, TypeBinding[] types) throws CoreException {
        if (types == null) {
            return;
        }
        TypeBinding[] typeBindingArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding type = typeBindingArray[n2];
            this.reportPackageMatch(locator, type.getPackage());
            ++n2;
        }
    }

    private void matchTypeReferences(SearchPattern pattern, MatchLocator locator) throws CoreException {
        switch (pattern.kind) {
            case 4: {
                break;
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    SearchPattern p = patterns[i];
                    if (p.kind == 4) {
                        this.matchTypeReferences(patterns[i], locator);
                    }
                    ++i;
                }
            }
            default: {
                return;
            }
        }
        this.matchTypeReferences(locator, (TypeReferencePattern)pattern, this.module.getUses());
        TypeBinding[] services = this.module.getServices();
        if (services != null) {
            this.matchTypeReferences(locator, (TypeReferencePattern)pattern, services);
            TypeBinding[] typeBindingArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding service = typeBindingArray[n2];
                this.matchTypeReferences(locator, (TypeReferencePattern)pattern, this.module.getImplementations(service));
                ++n2;
            }
        }
    }

    private void matchTypeReferences(MatchLocator locator, TypeReferencePattern typeReferencePattern, TypeBinding[] types) throws CoreException {
        if (types == null) {
            return;
        }
        TypeBinding[] typeBindingArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TypeBinding type = typeBindingArray[n2];
            int level = locator.patternLocator.resolveLevel(type);
            if (level != 0) {
                int accuracy = level == 3 ? 0 : 1;
                TypeReferenceMatch match = locator.newTypeReferenceMatch(this.moduleDesc, null, accuracy, -1, 0, null);
                locator.report(match);
            }
            ++n2;
        }
    }
}

