/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.ObjectVector;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.SimpleLookupTable;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.search.matching.PossibleMatch;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;

public class PossibleMatchSet {
    private SimpleLookupTable rootsToPossibleMatches = new SimpleLookupTable(5);
    private int elementCount = 0;

    public void add(PossibleMatch possibleMatch) {
        IPath path = possibleMatch.openable.getPackageFragmentRoot().getPath();
        ObjectVector possibleMatches = (ObjectVector)this.rootsToPossibleMatches.get(path);
        if (possibleMatches != null) {
            PossibleMatch storedMatch = (PossibleMatch)possibleMatches.find(possibleMatch);
            if (storedMatch != null) {
                while (storedMatch.getSimilarMatch() != null) {
                    storedMatch = storedMatch.getSimilarMatch();
                }
                storedMatch.setSimilarMatch(possibleMatch);
                return;
            }
        } else {
            possibleMatches = new ObjectVector();
            this.rootsToPossibleMatches.put(path, possibleMatches);
        }
        possibleMatches.add(possibleMatch);
        ++this.elementCount;
    }

    public PossibleMatch[] getPossibleMatches(IPackageFragmentRoot[] roots) {
        Object[] result = new PossibleMatch[this.elementCount];
        int index = 0;
        HashSet<IPath> processedHash = new HashSet<IPath>();
        int i = 0;
        int length = roots.length;
        while (i < length) {
            IPath path = roots[i].getPath();
            ObjectVector possibleMatches = (ObjectVector)this.rootsToPossibleMatches.get(path);
            if (possibleMatches != null && !processedHash.contains(path)) {
                possibleMatches.copyInto(result, index);
                index += possibleMatches.size();
                processedHash.add(path);
            }
            ++i;
        }
        if (index < this.elementCount) {
            Object[] objectArray = result;
            result = new PossibleMatch[index];
            System.arraycopy(objectArray, 0, result, 0, index);
        }
        return result;
    }

    public void reset() {
        this.rootsToPossibleMatches = new SimpleLookupTable(5);
        this.elementCount = 0;
    }
}

