/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IBootstrapMethodsAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IBootstrapMethodsEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.BootstrapMethodsEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileAttribute;

public class BootstrapMethodsAttribute
extends ClassFileAttribute
implements IBootstrapMethodsAttribute {
    private static final IBootstrapMethodsEntry[] NO_ENTRIES = new IBootstrapMethodsEntry[0];
    private IBootstrapMethodsEntry[] entries;
    private int numberOfBootstrapMethods;

    public BootstrapMethodsAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length = this.numberOfBootstrapMethods = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.entries = new IBootstrapMethodsEntry[length];
            int i = 0;
            while (i < length) {
                BootstrapMethodsEntry entry = new BootstrapMethodsEntry(classFileBytes, constantPool, offset + readOffset);
                this.entries[i] = entry;
                readOffset += 4 + 2 * entry.getBootstrapArguments().length;
                ++i;
            }
        } else {
            this.entries = NO_ENTRIES;
        }
    }

    @Override
    public IBootstrapMethodsEntry[] getBootstrapMethods() {
        return this.entries;
    }
}

