/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileStruct;

public class ClassFileAttribute
extends ClassFileStruct
implements IClassFileAttribute {
    public static final IClassFileAttribute[] NO_ATTRIBUTES = new IClassFileAttribute[0];
    private long attributeLength;
    private int attributeNameIndex;
    private char[] attributeName;

    public ClassFileAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        this.attributeNameIndex = this.u2At(classFileBytes, 0, offset);
        this.attributeLength = this.u4At(classFileBytes, 2, offset);
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.attributeNameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.attributeName = constantPoolEntry.getUtf8Value();
    }

    @Override
    public char[] getAttributeName() {
        return this.attributeName;
    }

    @Override
    public long getAttributeLength() {
        return this.attributeLength;
    }
}

