/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IStackMapFrame;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IVerificationTypeInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileStruct;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.VerificationInfo;

public class DefaultStackMapFrame
extends ClassFileStruct
implements IStackMapFrame {
    private static final IVerificationTypeInfo[] EMPTY_LOCALS_OR_STACK_ITEMS = new IVerificationTypeInfo[0];
    private int readOffset;
    private int numberOfLocals;
    private int numberOfStackItems;
    private IVerificationTypeInfo[] locals;
    private IVerificationTypeInfo[] stackItems;
    private int offsetDelta;

    public DefaultStackMapFrame(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int tempLocals;
        this.offsetDelta = this.u2At(classFileBytes, 0, offset);
        this.numberOfLocals = tempLocals = this.u2At(classFileBytes, 2, offset);
        this.readOffset = 4;
        if (tempLocals != 0) {
            this.locals = new IVerificationTypeInfo[tempLocals];
            int i = 0;
            while (i < tempLocals) {
                VerificationInfo verificationInfo = new VerificationInfo(classFileBytes, constantPool, offset + this.readOffset);
                this.locals[i] = verificationInfo;
                this.readOffset += verificationInfo.sizeInBytes();
                ++i;
            }
        } else {
            this.locals = EMPTY_LOCALS_OR_STACK_ITEMS;
        }
        int tempStackItems = this.u2At(classFileBytes, this.readOffset, offset);
        this.readOffset += 2;
        this.numberOfStackItems = tempStackItems;
        if (tempStackItems != 0) {
            this.stackItems = new IVerificationTypeInfo[tempStackItems];
            int i = 0;
            while (i < tempStackItems) {
                VerificationInfo verificationInfo = new VerificationInfo(classFileBytes, constantPool, offset + this.readOffset);
                this.stackItems[i] = verificationInfo;
                this.readOffset += verificationInfo.sizeInBytes();
                ++i;
            }
        } else {
            this.stackItems = EMPTY_LOCALS_OR_STACK_ITEMS;
        }
    }

    int sizeInBytes() {
        return this.readOffset;
    }

    @Override
    public int getFrameType() {
        return 255;
    }

    @Override
    public IVerificationTypeInfo[] getLocals() {
        return this.locals;
    }

    @Override
    public int getNumberOfLocals() {
        return this.numberOfLocals;
    }

    @Override
    public int getNumberOfStackItems() {
        return this.numberOfStackItems;
    }

    @Override
    public int getOffsetDelta() {
        return this.offsetDelta;
    }

    @Override
    public IVerificationTypeInfo[] getStackItems() {
        return this.stackItems;
    }
}

