/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IExceptionAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.util.Util;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileAttribute;

public class ExceptionAttribute
extends ClassFileAttribute
implements IExceptionAttribute {
    private int exceptionsNumber;
    private char[][] exceptionNames;
    private int[] exceptionIndexes;

    ExceptionAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int exceptionLength = this.exceptionsNumber = this.u2At(classFileBytes, 6, offset);
        this.exceptionNames = CharOperation.NO_CHAR_CHAR;
        this.exceptionIndexes = Util.EMPTY_INT_ARRAY;
        if (exceptionLength != 0) {
            this.exceptionNames = new char[exceptionLength][];
            this.exceptionIndexes = new int[exceptionLength];
        }
        int readOffset = 8;
        int i = 0;
        while (i < exceptionLength) {
            this.exceptionIndexes[i] = this.u2At(classFileBytes, readOffset, offset);
            IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.exceptionIndexes[i]);
            if (constantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.exceptionNames[i] = constantPoolEntry.getClassInfoName();
            readOffset += 2;
            ++i;
        }
    }

    @Override
    public char[][] getExceptionNames() {
        return this.exceptionNames;
    }
}

