/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.IAnnotatable;
import io.spring.javaformat.eclipse.jdt.jdk11.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IMethod;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IOpenable;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IPackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.ITypeRoot;
import io.spring.javaformat.eclipse.jdt.jdk11.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.Signature;
import io.spring.javaformat.eclipse.jdt.jdk11.core.WorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.BindingKeyParser;
import java.util.ArrayList;

public class JavaElementFinder
extends BindingKeyParser {
    private JavaProject project;
    private WorkingCopyOwner owner;
    public IJavaElement element;
    public JavaModelException exception;
    private ArrayList types = new ArrayList();

    public JavaElementFinder(String key, JavaProject project, WorkingCopyOwner owner) {
        super(key);
        this.project = project;
        this.owner = owner;
    }

    private JavaElementFinder(BindingKeyParser parser, JavaProject project, WorkingCopyOwner owner) {
        super(parser);
        this.project = project;
        this.owner = owner;
    }

    @Override
    public void consumeAnnotation() {
        if (!(this.element instanceof IAnnotatable)) {
            return;
        }
        int size = this.types.size();
        if (size == 0) {
            return;
        }
        IJavaElement annotationType = ((JavaElementFinder)this.types.get((int)(size - 1))).element;
        this.element = ((IAnnotatable)((Object)this.element)).getAnnotation(annotationType.getElementName());
    }

    @Override
    public void consumeField(char[] fieldName) {
        if (!(this.element instanceof IType)) {
            return;
        }
        this.element = ((IType)this.element).getField(new String(fieldName));
    }

    @Override
    public void consumeFullyQualifiedName(char[] fullyQualifiedName) {
        try {
            this.element = this.project.findType(new String(CharOperation.replaceOnCopy(fullyQualifiedName, '/', '.')), this.owner);
        }
        catch (JavaModelException e) {
            this.exception = e;
        }
    }

    @Override
    public void consumeLocalType(char[] uniqueKey) {
        if (this.element == null) {
            return;
        }
        if (this.element instanceof BinaryType) {
            int lastSlash = CharOperation.lastIndexOf('/', uniqueKey);
            int end = CharOperation.indexOf(';', uniqueKey, lastSlash + 1);
            char[] localName = CharOperation.subarray(uniqueKey, lastSlash + 1, end);
            IPackageFragment pkg = (IPackageFragment)this.element.getAncestor(4);
            this.element = pkg.getClassFile(String.valueOf(new String(localName)) + ".class");
        } else {
            int firstDollar = CharOperation.indexOf('$', uniqueKey);
            int end = CharOperation.indexOf('$', uniqueKey, firstDollar + 1);
            if (end == -1) {
                end = CharOperation.indexOf(';', uniqueKey, firstDollar + 1);
            }
            char[] sourceStart = CharOperation.subarray(uniqueKey, firstDollar + 1, end);
            int position = Integer.parseInt(new String(sourceStart));
            try {
                this.element = ((ITypeRoot)this.element.getOpenable()).getElementAt(position);
            }
            catch (JavaModelException e) {
                this.exception = e;
            }
        }
    }

    @Override
    public void consumeMemberType(char[] simpleTypeName) {
        if (!(this.element instanceof IType)) {
            return;
        }
        this.element = ((IType)this.element).getType(new String(simpleTypeName));
    }

    @Override
    public void consumeMethod(char[] selector, char[] signature) {
        if (!(this.element instanceof IType)) {
            return;
        }
        IType type = (IType)this.element;
        String[] parameterTypes = Signature.getParameterTypes(new String(signature));
        IMethod method = type.getMethod(new String(selector), parameterTypes);
        IMethod[] methods = type.findMethods(method);
        if (methods.length > 0) {
            this.element = methods[0];
        }
    }

    @Override
    public void consumePackage(char[] pkgName) {
        pkgName = CharOperation.replaceOnCopy(pkgName, '/', '.');
        try {
            this.element = this.project.findPackageFragment(new String(pkgName));
        }
        catch (JavaModelException e) {
            this.exception = e;
        }
    }

    @Override
    public void consumeParser(BindingKeyParser parser) {
        this.types.add(parser);
    }

    @Override
    public void consumeSecondaryType(char[] simpleTypeName) {
        if (this.element == null) {
            return;
        }
        IOpenable openable = this.element.getOpenable();
        if (!(openable instanceof ICompilationUnit)) {
            return;
        }
        this.element = ((ICompilationUnit)openable).getType(new String(simpleTypeName));
    }

    @Override
    public void consumeTypeVariable(char[] position, char[] typeVariableName) {
        if (this.element == null) {
            return;
        }
        switch (this.element.getElementType()) {
            case 7: {
                this.element = ((IType)this.element).getTypeParameter(new String(typeVariableName));
                break;
            }
            case 9: {
                this.element = ((IMethod)this.element).getTypeParameter(new String(typeVariableName));
            }
        }
    }

    @Override
    public void consumeModule(char[] moduleName) {
        try {
            this.element = this.project.findModule(new String(moduleName), (WorkingCopyOwner)null);
        }
        catch (JavaModelException e) {
            this.exception = e;
        }
    }

    @Override
    public BindingKeyParser newParser() {
        return new JavaElementFinder(this, this.project, this.owner);
    }
}

