/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry3;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IModuleAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IPackageVisibilityInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IProvidesInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IRequiresInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.PackageVisibilityInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ProvidesInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.RequiresInfo;

public class ModuleAttribute
extends ClassFileAttribute
implements IModuleAttribute {
    static final IRequiresInfo[] NO_REQUIRES = new IRequiresInfo[0];
    static final IPackageVisibilityInfo[] NO_PACKAGE_VISIBILITY_INFOS = new IPackageVisibilityInfo[0];
    static final int[] NO_USES = new int[0];
    static final IProvidesInfo[] NO_PROVIDES_INFOS = new IProvidesInfo[0];
    private int moduleNameIndex;
    private char[] moduleName;
    private int moduleFlags;
    private int moduleVersionIndex;
    private char[] moduleVersionValue;
    private int requiresCount;
    private IRequiresInfo[] requiresInfo;
    private int exportsCount;
    private IPackageVisibilityInfo[] exportsInfo;
    private int opensCount;
    private IPackageVisibilityInfo[] opensInfo;
    private int usesCount;
    private int[] usesIndices;
    private char[][] usesNames;
    private int providesCount;
    private IProvidesInfo[] providesInfo;

    ModuleAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int i;
        int readOffset = 6;
        this.moduleNameIndex = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.moduleNameIndex);
        if (constantPoolEntry.getKind() != 19) {
            throw new ClassFormatException(3);
        }
        this.moduleName = ((IConstantPoolEntry3)constantPoolEntry).getModuleName();
        this.moduleFlags = this.u2At(classFileBytes, readOffset, offset);
        this.moduleVersionIndex = this.u2At(classFileBytes, readOffset += 2, offset);
        readOffset += 2;
        if (this.moduleVersionIndex != 0) {
            constantPoolEntry = constantPool.decodeEntry(this.moduleVersionIndex);
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.moduleVersionValue = constantPoolEntry.getUtf8Value();
        } else {
            this.moduleVersionValue = CharOperation.NO_CHAR;
        }
        this.requiresCount = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        if (this.requiresCount != 0) {
            this.requiresInfo = new RequiresInfo[this.requiresCount];
            i = 0;
            while (i < this.requiresCount) {
                this.requiresInfo[i] = new RequiresInfo(classFileBytes, constantPool, offset + readOffset);
                readOffset += 6;
                ++i;
            }
        } else {
            this.requiresInfo = NO_REQUIRES;
        }
        this.exportsCount = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        if (this.exportsCount != 0) {
            this.exportsInfo = new PackageVisibilityInfo[this.exportsCount];
            i = 0;
            while (i < this.exportsCount) {
                this.exportsInfo[i] = new PackageVisibilityInfo(classFileBytes, constantPool, offset + readOffset);
                readOffset += 6 + 2 * this.exportsInfo[i].getTargetsCount();
                ++i;
            }
        } else {
            this.exportsInfo = NO_PACKAGE_VISIBILITY_INFOS;
        }
        this.opensCount = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        if (this.opensCount != 0) {
            this.opensInfo = new PackageVisibilityInfo[this.opensCount];
            i = 0;
            while (i < this.opensCount) {
                this.opensInfo[i] = new PackageVisibilityInfo(classFileBytes, constantPool, offset + readOffset);
                readOffset += 6 + 2 * this.opensInfo[i].getTargetsCount();
                ++i;
            }
        } else {
            this.opensInfo = NO_PACKAGE_VISIBILITY_INFOS;
        }
        this.usesCount = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        if (this.usesCount != 0) {
            this.usesIndices = new int[this.usesCount];
            this.usesNames = new char[this.usesCount][];
            i = 0;
            while (i < this.usesCount) {
                this.usesIndices[i] = this.u2At(classFileBytes, readOffset, offset);
                readOffset += 2;
                constantPoolEntry = constantPool.decodeEntry(this.usesIndices[i]);
                if (constantPoolEntry.getKind() != 7) {
                    throw new ClassFormatException(3);
                }
                this.usesNames[i] = constantPoolEntry.getClassInfoName();
                ++i;
            }
        } else {
            this.usesIndices = NO_USES;
            this.usesNames = CharOperation.NO_CHAR_CHAR;
        }
        this.providesCount = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        if (this.providesCount != 0) {
            this.providesInfo = new ProvidesInfo[this.providesCount];
            i = 0;
            while (i < this.providesCount) {
                this.providesInfo[i] = new ProvidesInfo(classFileBytes, constantPool, offset + readOffset);
                readOffset += 4 + 2 * this.providesInfo[i].getImplementationsCount();
                ++i;
            }
        } else {
            this.providesInfo = NO_PROVIDES_INFOS;
        }
    }

    @Override
    public char[] getModuleName() {
        return this.moduleName;
    }

    @Override
    public char[] getModuleVersionValue() {
        return this.moduleVersionValue;
    }

    @Override
    public IRequiresInfo[] getRequiresInfo() {
        return this.requiresInfo;
    }

    @Override
    public IPackageVisibilityInfo[] getExportsInfo() {
        return this.exportsInfo;
    }

    @Override
    public IPackageVisibilityInfo[] getOpensInfo() {
        return this.opensInfo;
    }

    @Override
    public char[][] getUsesClassNames() {
        return this.usesNames;
    }

    @Override
    public IProvidesInfo[] getProvidesInfo() {
        return this.providesInfo;
    }
}

