/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IModuleMainClassAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileAttribute;

public class ModuleMainClassAttribute
extends ClassFileAttribute
implements IModuleMainClassAttribute {
    private final int mainClassIndex;
    private final char[] mainClassName;

    public ModuleMainClassAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int readOffset = 6;
        this.mainClassIndex = this.u2At(classFileBytes, readOffset, offset);
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.mainClassIndex);
        if (constantPoolEntry.getKind() != 7) {
            throw new ClassFormatException(3);
        }
        this.mainClassName = constantPoolEntry.getClassInfoName();
    }

    @Override
    public char[] getMainClassName() {
        return this.mainClassName;
    }
}

