/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IPermittedSubclassesAttributeEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileStruct;

public class PermittedSubclassesAttributeEntry
extends ClassFileStruct
implements IPermittedSubclassesAttributeEntry {
    private int permittedClassNameIndex;
    private char[] permittedClassName;

    public PermittedSubclassesAttributeEntry(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        this.permittedClassNameIndex = this.u2At(classFileBytes, 0, offset);
        if (this.permittedClassNameIndex != 0) {
            IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.permittedClassNameIndex);
            if (constantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.permittedClassName = constantPoolEntry.getClassInfoName();
        }
    }

    public String toString() {
        return new String(this.permittedClassName);
    }

    @Override
    public char[] getPermittedSubclassName() {
        return this.permittedClassName;
    }

    @Override
    public int gePermittedSubclassIndex() {
        return this.permittedClassNameIndex;
    }
}

