/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPoolEntry3;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IRequiresInfo;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileStruct;

public class RequiresInfo
extends ClassFileStruct
implements IRequiresInfo {
    private int index;
    private char[] moduleName;
    private int flags;
    private int versionIndex;
    private char[] versionName;

    public RequiresInfo(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int readOffset = 0;
        this.index = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.index);
        if (constantPoolEntry.getKind() != 19) {
            throw new ClassFormatException(3);
        }
        this.moduleName = ((IConstantPoolEntry3)constantPoolEntry).getModuleName();
        this.flags = this.u2At(classFileBytes, readOffset, offset);
        this.versionIndex = this.u2At(classFileBytes, readOffset += 2, offset);
        readOffset += 2;
        if (this.versionIndex != 0) {
            constantPoolEntry = constantPool.decodeEntry(this.versionIndex);
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.versionName = constantPoolEntry.getUtf8Value();
        } else {
            this.versionName = CharOperation.NO_CHAR;
        }
    }

    @Override
    public char[] getRequiresModuleName() {
        return this.moduleName;
    }

    @Override
    public int getRequiresFlags() {
        return this.flags;
    }
}

