/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.env.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class ResourceCompilationUnit
implements ICompilationUnit {
    private IFile file;
    private char[] contents;
    private char[] fileName;
    private char[] mainTypeName;
    private char[] module;

    public ResourceCompilationUnit(IFile file, char[] mod) {
        int end;
        this.file = file;
        this.module = mod;
        String f = file.getFullPath().toString();
        this.fileName = f.toCharArray();
        int start = f.lastIndexOf("/") + 1;
        if (start == 0 || start < f.lastIndexOf("\\")) {
            start = f.lastIndexOf("\\") + 1;
        }
        if ((end = f.lastIndexOf(".")) == -1) {
            end = f.length();
        }
        this.mainTypeName = f.substring(start, end).toCharArray();
    }

    @Override
    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            this.contents = Util.getResourceContentsAsCharArray(this.file);
            return this.contents;
        }
        catch (CoreException coreException) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public char[] getFileName() {
        return this.fileName;
    }

    @Override
    public char[] getMainTypeName() {
        return this.mainTypeName;
    }

    @Override
    public char[][] getPackageName() {
        return null;
    }

    @Override
    public boolean ignoreOptionalProblems() {
        return false;
    }

    @Override
    public char[] getModuleName() {
        return this.module;
    }
}

