/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IParameterAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IRuntimeInvisibleParameterAnnotationsAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ParameterAnnotation;

public class RuntimeInvisibleParameterAnnotationsAttribute
extends ClassFileAttribute
implements IRuntimeInvisibleParameterAnnotationsAttribute {
    private static final IParameterAnnotation[] NO_ENTRIES = new IParameterAnnotation[0];
    private IParameterAnnotation[] parameterAnnotations;
    private int parametersNumber;

    public RuntimeInvisibleParameterAnnotationsAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.parametersNumber = length = this.u1At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 7;
            this.parameterAnnotations = new IParameterAnnotation[length];
            int i = 0;
            while (i < length) {
                ParameterAnnotation parameterAnnotation = new ParameterAnnotation(classFileBytes, constantPool, offset + readOffset);
                this.parameterAnnotations[i] = parameterAnnotation;
                readOffset += parameterAnnotation.sizeInBytes();
                ++i;
            }
        } else {
            this.parameterAnnotations = NO_ENTRIES;
        }
    }

    @Override
    public IParameterAnnotation[] getParameterAnnotations() {
        return this.parameterAnnotations;
    }
}

