/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk11.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IExtendedAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk11.core.util.IRuntimeInvisibleTypeAnnotationsAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.core.util.ExtendedAnnotation;

public class RuntimeInvisibleTypeAnnotationsAttribute
extends ClassFileAttribute
implements IRuntimeInvisibleTypeAnnotationsAttribute {
    private static final IExtendedAnnotation[] NO_ENTRIES = new IExtendedAnnotation[0];
    private int extendedAnnotationsNumber;
    private IExtendedAnnotation[] extendedAnnotations;

    public RuntimeInvisibleTypeAnnotationsAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.extendedAnnotationsNumber = length = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.extendedAnnotations = new IExtendedAnnotation[length];
            int i = 0;
            while (i < length) {
                ExtendedAnnotation extendedAnnotation = new ExtendedAnnotation(classFileBytes, constantPool, offset + readOffset);
                this.extendedAnnotations[i] = extendedAnnotation;
                readOffset += extendedAnnotation.sizeInBytes();
                ++i;
            }
        } else {
            this.extendedAnnotations = NO_ENTRIES;
        }
    }

    @Override
    public IExtendedAnnotation[] getExtendedAnnotations() {
        return this.extendedAnnotations;
    }
}

