/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter;

import io.spring.javaformat.eclipse.jdt.jdk11.core.compiler.InvalidInputException;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.Scanner;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.DefaultCodeFormatter;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.DefaultCodeFormatterOptions;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.Preparator;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.Token;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.TokenManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExtendedCodeFormatter
extends DefaultCodeFormatter {
    private static boolean useLegacyTokenize = false;
    private final List<Preparator> preparators = new ArrayList<Preparator>();

    public ExtendedCodeFormatter() {
    }

    public ExtendedCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, String> options) {
        super(defaultCodeFormatterOptions, options);
    }

    public ExtendedCodeFormatter(DefaultCodeFormatterOptions options) {
        super(options);
    }

    public ExtendedCodeFormatter(Map<String, String> options) {
        super(options);
    }

    protected void addPreparator(Preparator preparator) {
        this.preparators.add(preparator);
    }

    @Override
    protected void tokenizeSource(int kind) {
        if (useLegacyTokenize) {
            this.legacyTokenizeSource(kind);
            return;
        }
        try {
            super.tokenizeSource(kind);
        }
        catch (NoSuchMethodError ex) {
            useLegacyTokenize = true;
            this.legacyTokenizeSource(kind);
        }
    }

    private void legacyTokenizeSource(int kind) {
        this.tokens.clear();
        long sourceLevel = CompilerOptions.versionToJdkLevel(this.sourceLevel);
        Scanner scanner = new Scanner(true, false, false, sourceLevel, null, null, false);
        scanner.setSource(this.sourceArray);
        scanner.fakeInModule = (kind & 0x80) != 0;
        while (true) {
            Token token;
            try {
                int tokenType;
                while ((tokenType = scanner.getNextToken()) != 64) {
                    token = Token.fromCurrent(scanner, tokenType);
                    this.tokens.add(token);
                }
            }
            catch (InvalidInputException ex) {
                token = Token.fromCurrent(scanner, 0);
                this.tokens.add(token);
                continue;
            }
            break;
        }
    }

    @Override
    protected void prepareWraps(int kind) {
        ASTNode astRoot = this.getField("astRoot", ASTNode.class);
        TokenManager tokenManager = this.getField("tokenManager", TokenManager.class);
        this.applyPreparators(Preparator.Phase.PRE_WRAPPING, kind, astRoot, tokenManager);
        super.prepareWraps(kind);
        this.applyPreparators(Preparator.Phase.POST_WRAPPING, kind, astRoot, tokenManager);
    }

    private void applyPreparators(Preparator.Phase preWrapping, int kind, ASTNode astRoot, TokenManager tokenManager) {
        this.preparators.stream().filter(preparator -> preparator.getPhase() == preWrapping).forEach(preparator -> preparator.apply(kind, tokenManager, astRoot));
    }

    private <T> T getField(String name, Class<T> type) {
        try {
            Field field = DefaultCodeFormatter.class.getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(this);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

