/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter;

import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnnotationTypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.AnonymousClassDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Assignment;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Block;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.DoStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnhancedForStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnumConstantDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.EnumDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ExpressionStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ForStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.IfStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.LambdaExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ModuleDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.PrimitiveType;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.RecordDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ReturnStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Statement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchCase;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchExpression;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.SwitchStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.ThrowStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.Type;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.TypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk11.core.dom.WhileStatement;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.DefaultCodeFormatterOptions;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.Token;
import io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter.TokenManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OneLineEnforcer
extends ASTVisitor {
    private final TokenManager tm;
    private final DefaultCodeFormatterOptions options;

    public OneLineEnforcer(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        boolean isMalformed = (node.getFlags() & 1) != 0;
        return !isMalformed;
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        if (node.getParent().getLength() == 0) {
            return;
        }
        this.tryKeepOnOneLine(node, node.getName(), node.bodyDeclarations(), this.options.keep_type_declaration_on_one_line);
    }

    @Override
    public void endVisit(EnumDeclaration node) {
        ArrayList items = new ArrayList();
        items.addAll(node.bodyDeclarations());
        items.addAll(node.enumConstants());
        this.tryKeepOnOneLine(node, node.getName(), items, this.options.keep_enum_declaration_on_one_line);
    }

    @Override
    public void endVisit(AnnotationTypeDeclaration node) {
        this.tryKeepOnOneLine(node, node.getName(), node.bodyDeclarations(), this.options.keep_annotation_declaration_on_one_line);
    }

    @Override
    public void endVisit(RecordDeclaration node) {
        this.tryKeepOnOneLine(node, node.getName(), node.bodyDeclarations(), this.options.keep_record_declaration_on_one_line);
    }

    @Override
    public void endVisit(AnonymousClassDeclaration node) {
        if (node.getParent() instanceof EnumConstantDeclaration) {
            this.tryKeepOnOneLine(node, null, node.bodyDeclarations(), this.options.keep_enum_constant_declaration_on_one_line);
        } else {
            this.tryKeepOnOneLine(node, null, node.bodyDeclarations(), this.options.keep_anonymous_type_declaration_on_one_line);
        }
    }

    @Override
    public void endVisit(SwitchExpression node) {
        this.handleSwitchBody(node, node.getExpression(), node.statements());
    }

    @Override
    public void endVisit(SwitchStatement node) {
        this.handleSwitchBody(node, node.getExpression(), node.statements());
    }

    private void handleSwitchBody(ASTNode node, Expression expression, List<Statement> statements) {
        block3: {
            block2: {
                if (statements.isEmpty()) break block2;
                if (!((SwitchCase)statements.get(0)).isSwitchLabeledRule()) break block3;
            }
            List items = statements.stream().filter(SwitchCase.class::isInstance).collect(Collectors.toList());
            this.tryKeepOnOneLine(node, expression, items, this.options.keep_switch_body_block_on_one_line);
        }
    }

    @Override
    public void endVisit(Block node) {
        String oneLineOption;
        ASTNode parent = node.getParent();
        List statements = node.statements();
        if (parent.getLength() == 0) {
            return;
        }
        if (parent instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)parent;
            String string = oneLineOption = method.isCompactConstructor() ? this.options.keep_record_constructor_on_one_line : this.options.keep_method_body_on_one_line;
            if (this.options.keep_simple_getter_setter_on_one_line) {
                boolean isSetter;
                String name = method.getName().getIdentifier();
                Type returnType = method.getReturnType2();
                boolean returnsVoid = returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode() == PrimitiveType.VOID;
                boolean isGetter = name.matches("(is|get)\\p{Lu}.*") && !method.isConstructor() && !returnsVoid && method.parameters().isEmpty() && statements.size() == 1 && statements.get(0) instanceof ReturnStatement;
                boolean bl = isSetter = name.matches("set\\p{Lu}.*") && !method.isConstructor() && returnsVoid && method.parameters().size() == 1 && statements.size() == 1 && statements.get(0) instanceof ExpressionStatement && ((ExpressionStatement)statements.get(0)).getExpression() instanceof Assignment;
                if (isGetter || isSetter) {
                    oneLineOption = "one_line_always";
                }
            }
        } else if (parent instanceof IfStatement && ((IfStatement)parent).getElseStatement() == null) {
            oneLineOption = this.options.keep_if_then_body_block_on_one_line;
            if (this.options.keep_guardian_clause_on_one_line) {
                boolean isGuardian = statements.size() == 1 && (statements.get(0) instanceof ReturnStatement || statements.get(0) instanceof ThrowStatement);
                int openBraceIndex = this.tm.firstIndexIn(node, 39);
                boolean bl = isGuardian = isGuardian && !this.tm.get(openBraceIndex + 1).isComment();
                if (isGuardian) {
                    oneLineOption = "one_line_always";
                }
            }
        } else if (parent instanceof LambdaExpression) {
            oneLineOption = this.options.keep_lambda_body_block_on_one_line;
        } else if (parent instanceof ForStatement || parent instanceof EnhancedForStatement || parent instanceof WhileStatement) {
            oneLineOption = this.options.keep_loop_body_block_on_one_line;
        } else {
            if (parent instanceof DoStatement) {
                String oneLineOption2 = this.options.keep_loop_body_block_on_one_line;
                int openBraceIndex = this.tm.firstIndexIn(node, 39);
                int closeBraceIndex = this.tm.lastIndexIn(node, 33);
                Token whileToken = this.tm.firstTokenAfter(node, 79);
                int lastIndex = whileToken.getLineBreaksBefore() == 0 ? this.tm.lastIndexIn(parent, -1) : closeBraceIndex;
                this.tryKeepOnOneLine(openBraceIndex, closeBraceIndex, lastIndex, statements, oneLineOption2);
                return;
            }
            oneLineOption = this.isSwitchCaseWithArrow(node) ? this.options.keep_switch_case_with_arrow_on_one_line : this.options.keep_code_block_on_one_line;
        }
        this.tryKeepOnOneLine(node, null, statements, oneLineOption);
    }

    private boolean isSwitchCaseWithArrow(Block node) {
        List siblings;
        if (node.getParent() instanceof SwitchStatement) {
            siblings = ((SwitchStatement)node.getParent()).statements();
        } else if (node.getParent() instanceof SwitchExpression) {
            siblings = ((SwitchExpression)node.getParent()).statements();
        } else {
            return false;
        }
        return ((SwitchCase)siblings.get(0)).isSwitchLabeledRule();
    }

    @Override
    public void endVisit(ModuleDeclaration node) {
        this.tryKeepOnOneLine(node, node.getName(), node.moduleStatements(), this.options.keep_type_declaration_on_one_line);
    }

    private void tryKeepOnOneLine(ASTNode node, ASTNode nodeBeforeOpenBrace, List<? extends ASTNode> items, String oneLineOption) {
        int openBraceIndex = nodeBeforeOpenBrace == null ? this.tm.firstIndexIn(node, 39) : this.tm.firstIndexAfter(nodeBeforeOpenBrace, 39);
        int closeBraceIndex = this.tm.lastIndexIn(node, 33);
        this.tryKeepOnOneLine(openBraceIndex, closeBraceIndex, closeBraceIndex, items, oneLineOption);
    }

    private void tryKeepOnOneLine(int openBraceIndex, int closeBraceIndex, int lastIndex, List<? extends ASTNode> items, String oneLineOption) {
        if ("one_line_never".equals(oneLineOption)) {
            return;
        }
        if ("one_line_if_empty".equals(oneLineOption) && !items.isEmpty()) {
            return;
        }
        if ("one_line_if_single_item".equals(oneLineOption) && items.size() > 1) {
            return;
        }
        if ("one_line_preserve".equals(oneLineOption) && this.tm.countLineBreaksBetween(this.tm.get(openBraceIndex), this.tm.get(lastIndex)) > 0) {
            return;
        }
        Set breakIndexes = items.stream().map(n -> this.tm.firstIndexIn((ASTNode)n, -1)).collect(Collectors.toSet());
        breakIndexes.add(openBraceIndex + 1);
        breakIndexes.add(closeBraceIndex);
        Token prev = this.tm.get(openBraceIndex);
        int startPos = this.tm.getPositionInLine(openBraceIndex);
        int pos = startPos + this.tm.getLength(prev, startPos);
        int i = openBraceIndex + 1;
        while (i <= lastIndex) {
            boolean isSpace;
            Token token = this.tm.get(i);
            int preexistingBreaks = this.tm.countLineBreaksBetween(prev, token);
            if (this.options.number_of_empty_lines_to_preserve > 0 && preexistingBreaks > 1) {
                return;
            }
            boolean bl = isSpace = prev.isSpaceAfter() || token.isSpaceBefore();
            if (prev.isComment() || token.isComment()) {
                if (preexistingBreaks > 0) {
                    return;
                }
                char charBefore = this.tm.charAt(token.originalStart - 1);
                boolean bl2 = isSpace = isSpace || charBefore == ' ' || charBefore == '\t';
            }
            if (prev.getLineBreaksAfter() > 0 || token.getLineBreaksBefore() > 0) {
                if (!breakIndexes.contains(i)) {
                    return;
                }
                boolean bl3 = isSpace = isSpace || i != closeBraceIndex || i != openBraceIndex + 1;
            }
            if (isSpace) {
                ++pos;
            }
            pos += this.tm.getLength(token, pos);
            prev = token;
            ++i;
        }
        if (!items.isEmpty()) {
            ASTNode itemsParent = items.get(0).getParent();
            if (itemsParent.getParent() instanceof LambdaExpression || itemsParent instanceof SwitchExpression || itemsParent.getParent() instanceof SwitchExpression || itemsParent.getParent() instanceof SwitchStatement) {
                pos -= this.tm.get(openBraceIndex).getIndent();
            }
            if (pos > this.options.page_width) {
                return;
            }
        }
        for (Integer i2 : breakIndexes) {
            prev = this.tm.get(i2 - 1);
            prev.clearLineBreaksAfter();
            Token token = this.tm.get(i2);
            token.clearLineBreaksBefore();
            if (items.isEmpty()) continue;
            token.spaceBefore();
        }
    }
}

