/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk11.internal.formatter;

import io.spring.javaformat.eclipse.jdt.jdk11.internal.compiler.parser.Scanner;
import java.util.List;

public class Token {
    public final int originalStart;
    public final int originalEnd;
    public final int tokenType;
    private boolean spaceBefore;
    private boolean spaceAfter;
    private int lineBreaksBefore;
    private int lineBreaksAfter;
    private boolean preserveLineBreaksBefore = true;
    private boolean preserveLineBreaksAfter = true;
    private boolean wrapped;
    private int indent;
    private int emptyLineIndentAdjustment;
    private int align;
    private boolean toEscape;
    private boolean nextLineOnWrap;
    private WrapPolicy wrapPolicy;
    private Token nlsTagToken;
    private List<Token> internalStructure;

    public Token(int sourceStart, int sourceEnd, int tokenType) {
        assert (sourceStart <= sourceEnd);
        this.originalStart = sourceStart;
        this.originalEnd = sourceEnd;
        this.tokenType = tokenType;
    }

    public Token(Token tokenToCopy) {
        this(tokenToCopy, tokenToCopy.originalStart, tokenToCopy.originalEnd, tokenToCopy.tokenType);
    }

    public Token(Token tokenToCopy, int newOriginalStart, int newOriginalEnd, int newTokenType) {
        this.originalStart = newOriginalStart;
        this.originalEnd = newOriginalEnd;
        this.tokenType = newTokenType;
        this.spaceBefore = tokenToCopy.spaceBefore;
        this.spaceAfter = tokenToCopy.spaceAfter;
        this.lineBreaksBefore = tokenToCopy.lineBreaksBefore;
        this.lineBreaksAfter = tokenToCopy.lineBreaksAfter;
        this.preserveLineBreaksBefore = tokenToCopy.preserveLineBreaksBefore;
        this.preserveLineBreaksAfter = tokenToCopy.preserveLineBreaksAfter;
        this.indent = tokenToCopy.indent;
        this.nextLineOnWrap = tokenToCopy.nextLineOnWrap;
        this.wrapPolicy = tokenToCopy.wrapPolicy;
        this.nlsTagToken = tokenToCopy.nlsTagToken;
        this.internalStructure = tokenToCopy.internalStructure;
    }

    public static Token fromCurrent(Scanner scanner, int currentToken) {
        int start = scanner.getCurrentTokenStartPosition();
        int end = scanner.getCurrentTokenEndPosition();
        if (currentToken == 1001) {
            while (end > start) {
                char c = scanner.source[end];
                if (c != '\r' && c != '\n') break;
                --end;
            }
            Token token = new Token(start, end, currentToken);
            token.breakAfter();
            return token;
        }
        return new Token(start, end, currentToken);
    }

    public void spaceBefore() {
        this.spaceBefore = true;
    }

    public void clearSpaceBefore() {
        this.spaceBefore = false;
    }

    public boolean isSpaceBefore() {
        return this.spaceBefore;
    }

    public void spaceAfter() {
        this.spaceAfter = true;
    }

    public void clearSpaceAfter() {
        this.spaceAfter = false;
    }

    public boolean isSpaceAfter() {
        return this.spaceAfter;
    }

    public void breakBefore() {
        this.putLineBreaksBefore(1);
    }

    public void putLineBreaksBefore(int lineBreaks) {
        this.lineBreaksBefore = Math.max(this.lineBreaksBefore, lineBreaks);
    }

    public int getLineBreaksBefore() {
        return this.wrapped ? 1 : this.lineBreaksBefore;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public void clearLineBreaksBefore() {
        this.lineBreaksBefore = 0;
    }

    public void breakAfter() {
        this.putLineBreaksAfter(1);
    }

    public void putLineBreaksAfter(int lineBreaks) {
        this.lineBreaksAfter = Math.max(this.lineBreaksAfter, lineBreaks);
    }

    public int getLineBreaksAfter() {
        return this.lineBreaksAfter;
    }

    public void clearLineBreaksAfter() {
        this.lineBreaksAfter = 0;
    }

    public void setPreserveLineBreaksBefore(boolean preserveLineBreaksBefore) {
        this.preserveLineBreaksBefore = preserveLineBreaksBefore;
    }

    public boolean isPreserveLineBreaksBefore() {
        return this.preserveLineBreaksBefore;
    }

    public void setPreserveLineBreaksAfter(boolean preserveLineBreaksAfter) {
        this.preserveLineBreaksAfter = preserveLineBreaksAfter;
    }

    public boolean isPreserveLineBreaksAfter() {
        return this.preserveLineBreaksAfter;
    }

    public void indent() {
        ++this.indent;
    }

    public void unindent() {
        --this.indent;
    }

    public void setIndent(int indent) {
        assert (indent >= 0);
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setEmptyLineIndentAdjustment(int adjustment) {
        this.emptyLineIndentAdjustment = adjustment;
    }

    public int getEmptyLineIndentAdjustment() {
        return this.emptyLineIndentAdjustment;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public int getAlign() {
        return this.align;
    }

    public void setToEscape(boolean shouldEscape) {
        this.toEscape = shouldEscape;
    }

    public boolean isToEscape() {
        return this.toEscape;
    }

    public void setNextLineOnWrap() {
        this.nextLineOnWrap = true;
    }

    public boolean isNextLineOnWrap() {
        return this.nextLineOnWrap;
    }

    public void setWrapPolicy(WrapPolicy wrapPolicy) {
        this.wrapPolicy = wrapPolicy;
    }

    public WrapPolicy getWrapPolicy() {
        return this.wrapPolicy;
    }

    public boolean isWrappable() {
        WrapPolicy wp = this.wrapPolicy;
        return wp != null && wp.wrapMode != WrapMode.DISABLED && wp.wrapMode != WrapMode.BLOCK_INDENT;
    }

    public void setNLSTag(Token nlsTagToken) {
        this.nlsTagToken = nlsTagToken;
    }

    public boolean hasNLSTag() {
        return this.nlsTagToken != null;
    }

    public Token getNLSTag() {
        return this.nlsTagToken;
    }

    public void setInternalStructure(List<Token> internalStructure) {
        this.internalStructure = internalStructure;
    }

    public List<Token> getInternalStructure() {
        return this.internalStructure;
    }

    public boolean isComment() {
        switch (this.tokenType) {
            case 1001: 
            case 1002: 
            case 1003: {
                return true;
            }
        }
        return false;
    }

    public String toString(String source) {
        return source.substring(this.originalStart, this.originalEnd + 1);
    }

    public int countChars() {
        return this.originalEnd - this.originalStart + 1;
    }

    public String toString() {
        return "[" + this.originalStart + "-" + this.originalEnd + "]";
    }

    public static enum WrapMode {
        DISABLED,
        WHERE_NECESSARY,
        TOP_PRIORITY,
        FORCE,
        BLOCK_INDENT;

    }

    public static class WrapPolicy {
        public static final WrapPolicy DISABLE_WRAP = new WrapPolicy(WrapMode.DISABLED, 0, 0);
        public static final WrapPolicy SUBSTITUTE_ONLY = new WrapPolicy(WrapMode.DISABLED, 0, 0);
        public static final WrapPolicy FORCE_FIRST_COLUMN = new WrapPolicy(WrapMode.DISABLED, 0, 0);
        public final WrapMode wrapMode;
        public final int wrapParentIndex;
        public final int groupEndIndex;
        public final int extraIndent;
        public final int structureDepth;
        public final float penaltyMultiplier;
        public final boolean isFirstInGroup;
        public final boolean indentOnColumn;

        public WrapPolicy(WrapMode wrapMode, int wrapParentIndex, int groupEndIndex, int extraIndent, int structureDepth, float penaltyMultiplier, boolean isFirstInGroup, boolean indentOnColumn) {
            assert (wrapMode != null && (wrapParentIndex < groupEndIndex || groupEndIndex == -1));
            this.wrapMode = wrapMode;
            this.wrapParentIndex = wrapParentIndex;
            this.groupEndIndex = groupEndIndex;
            this.extraIndent = extraIndent;
            this.structureDepth = structureDepth;
            this.penaltyMultiplier = penaltyMultiplier;
            this.isFirstInGroup = isFirstInGroup;
            this.indentOnColumn = indentOnColumn;
        }

        public WrapPolicy(WrapMode wrapMode, int wrapParentIndex, int extraIndent) {
            this(wrapMode, wrapParentIndex, -1, extraIndent, 0, 1.0f, false, false);
        }
    }
}

