/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.IScanner;
import io.spring.javaformat.eclipse.jdt.jdk8.core.formatter.CodeFormatter;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IClassFileReader;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.Util;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JarPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileReader;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.PublicScanner;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.formatter.DefaultCodeFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ToolFactory {
    public static final int M_FORMAT_NEW = 0;
    public static final int M_FORMAT_EXISTING = 1;

    public static CodeFormatter createCodeFormatter(Map options) {
        return ToolFactory.createCodeFormatter(options, M_FORMAT_NEW);
    }

    public static CodeFormatter createCodeFormatter(Map options, int mode) {
        String formatterId;
        if (options == null) {
            options = JavaCore.getOptions();
        }
        HashMap<String, String> currentOptions = new HashMap<String, String>(options);
        if (mode == M_FORMAT_NEW) {
            currentOptions.put("io.spring.javaformat.eclipse.jdt.jdk8.core.formatter.format_line_comment_starting_on_first_column", "true");
            currentOptions.put("io.spring.javaformat.eclipse.jdt.jdk8.core.formatter.never_indent_block_comments_on_first_column", "false");
            currentOptions.put("io.spring.javaformat.eclipse.jdt.jdk8.core.formatter.never_indent_line_comments_on_first_column", "false");
        }
        if ((formatterId = (String)options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.javaFormatter")) != null) {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("io.spring.javaformat.eclipse.jdt.jdk8.core", "javaFormatter");
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String initializerID = configElements[j].getAttribute("id");
                        if (initializerID != null && initializerID.equals(formatterId)) {
                            try {
                                Object execExt = configElements[j].createExecutableExtension("class");
                                if (execExt instanceof CodeFormatter) {
                                    CodeFormatter formatter = (CodeFormatter)execExt;
                                    formatter.setOptions(currentOptions);
                                    return formatter;
                                }
                            }
                            catch (CoreException e) {
                                io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util.log(e.getStatus());
                                break;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util.log(2, "Unable to instantiate formatter extension '" + formatterId + "', returning built-in formatter.");
        }
        return new DefaultCodeFormatter(currentOptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(IClassFile classfile, int decodingFlag) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classfile.getAncestor(3);
        if (root == null) return null;
        try {
            IClassFileReader iClassFileReader;
            if (root instanceof JarPackageFragmentRoot) {
                String archiveName = null;
                ZipFile jar = null;
                try {
                    jar = ((JarPackageFragmentRoot)root).getJar();
                    archiveName = jar.getName();
                }
                finally {
                    JavaModelManager.getJavaModelManager().closeZipFile(jar);
                }
                PackageFragment packageFragment = (PackageFragment)classfile.getParent();
                String classFileName = classfile.getElementName();
                String entryName = io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util.concatWith(packageFragment.names, classFileName, '/');
                return ToolFactory.createDefaultClassFileReader(archiveName, entryName, decodingFlag);
            }
            InputStream in = null;
            try {
                in = ((IFile)((JavaElement)((Object)classfile)).resource()).getContents();
                iClassFileReader = ToolFactory.createDefaultClassFileReader(in, decodingFlag);
                if (in == null) return iClassFileReader;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return iClassFileReader;
            }
            catch (IOException iOException) {}
            return iClassFileReader;
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static IClassFileReader createDefaultClassFileReader(InputStream stream, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getInputStreamAsByteArray(stream, -1), decodingFlag);
        }
        catch (ClassFormatException | IOException exception) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static IClassFileReader createDefaultClassFileReader(String zipFileName, String zipEntryName, int decodingFlag) {
        ClassFileReader classFileReader;
        ZipFile zipFile;
        block22: {
            ZipEntry zipEntry;
            block20: {
                block21: {
                    block18: {
                        block19: {
                            zipFile = null;
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [ToolFactory.createDefaultClassFileReader()] Creating ZipFile on " + zipFileName);
                            }
                            if ((zipEntry = (zipFile = new ZipFile(zipFileName)).getEntry(zipEntryName)) != null) break block18;
                            if (zipFile == null) break block19;
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return null;
                    }
                    if (zipEntryName.toLowerCase().endsWith(".class")) break block20;
                    if (zipFile == null) break block21;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            byte[] classFileBytes = Util.getZipEntryByteContent(zipEntry, zipFile);
            classFileReader = new ClassFileReader(classFileBytes, decodingFlag);
            if (zipFile == null) break block22;
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
        catch (ClassFormatException | IOException exception) {
            block23: {
                try {
                    if (zipFile == null) break block23;
                }
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        long complianceLevelValue = CompilerOptions.versionToJdkLevel(JavaCore.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.compliance"));
        if (complianceLevelValue == 0L) {
            complianceLevelValue = 0x300000L;
        }
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, complianceLevelValue, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }
}

