/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.codeassist.select;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.codeassist.select.SelectionNodeFound;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.Javadoc;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.JavadocAllocationExpression;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.JavadocFieldReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.JavadocMessageSend;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.JavadocQualifiedTypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.JavadocSingleNameReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.JavadocSingleTypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.TypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.ReferenceContext;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.Binding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ClassScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.MethodScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.Scope;

public class SelectionJavadoc
extends Javadoc {
    Expression selectedNode;
    boolean inheritDocSelected = false;

    public SelectionJavadoc(int sourceStart, int sourceEnd) {
        super(sourceStart, sourceEnd);
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        super.print(indent, output);
        if (this.selectedNode != null) {
            TypeReference typeRef;
            String selectedString = null;
            if (this.selectedNode instanceof JavadocFieldReference) {
                JavadocFieldReference fieldRef = (JavadocFieldReference)this.selectedNode;
                selectedString = fieldRef.methodBinding != null ? "<SelectOnMethod:" : "<SelectOnField:";
            } else if (this.selectedNode instanceof JavadocMessageSend) {
                selectedString = "<SelectOnMethod:";
            } else if (this.selectedNode instanceof JavadocAllocationExpression) {
                selectedString = "<SelectOnConstructor:";
            } else if (this.selectedNode instanceof JavadocSingleNameReference) {
                selectedString = "<SelectOnLocalVariable:";
            } else if (this.selectedNode instanceof JavadocSingleTypeReference) {
                typeRef = (JavadocSingleTypeReference)this.selectedNode;
                if (typeRef.packageBinding == null) {
                    selectedString = "<SelectOnType:";
                }
            } else if (this.selectedNode instanceof JavadocQualifiedTypeReference) {
                typeRef = (JavadocQualifiedTypeReference)this.selectedNode;
                if (((JavadocQualifiedTypeReference)typeRef).packageBinding == null) {
                    selectedString = "<SelectOnType:";
                }
            } else {
                selectedString = "<SelectOnType:";
            }
            int pos = output.length() - 3;
            output.replace(pos - 2, pos, String.valueOf(selectedString) + this.selectedNode + '>');
        }
        return output;
    }

    private void internalResolve(Scope scope) {
        ReferenceContext referenceContext;
        if (this.selectedNode != null) {
            switch (scope.kind) {
                case 3: {
                    this.selectedNode.resolveType((ClassScope)scope);
                    break;
                }
                case 2: {
                    this.selectedNode.resolveType((MethodScope)scope);
                }
            }
            Binding binding = null;
            if (this.selectedNode instanceof JavadocFieldReference) {
                JavadocFieldReference fieldRef = (JavadocFieldReference)this.selectedNode;
                binding = fieldRef.binding;
                if (binding == null && fieldRef.methodBinding != null) {
                    binding = fieldRef.methodBinding;
                }
            } else if (this.selectedNode instanceof JavadocMessageSend) {
                binding = ((JavadocMessageSend)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocAllocationExpression) {
                binding = ((JavadocAllocationExpression)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocSingleNameReference) {
                binding = ((JavadocSingleNameReference)this.selectedNode).binding;
            } else if (this.selectedNode instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference typeRef = (JavadocSingleTypeReference)this.selectedNode;
                if (typeRef.packageBinding == null) {
                    binding = typeRef.resolvedType;
                }
            } else if (this.selectedNode instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference typeRef = (JavadocQualifiedTypeReference)this.selectedNode;
                if (typeRef.packageBinding == null) {
                    binding = typeRef.resolvedType;
                }
            } else {
                binding = this.selectedNode.resolvedType;
            }
            throw new SelectionNodeFound(binding);
        }
        if (this.inheritDocSelected && (referenceContext = scope.referenceContext()) instanceof MethodDeclaration) {
            throw new SelectionNodeFound(((MethodDeclaration)referenceContext).binding);
        }
    }

    @Override
    public void resolve(ClassScope scope) {
        this.internalResolve(scope);
    }

    @Override
    public void resolve(MethodScope scope) {
        this.internalResolve(scope);
    }
}

