/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.impl.DnsClientImpl;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.EventBusInternal;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.impl.FileResolver;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.file.impl.WindowsFileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VerticleManager;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.impl.WorkerExecutorImpl;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.impl.resolver.DnsResolverProvider;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.NetClientImpl;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.TCPServerBase;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.SharedDataImpl;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class VertxImpl
implements VertxInternal,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(VertxImpl.class);
    private static final String CLUSTER_MAP_NAME = "__vertx.haInfo";
    private static final String NETTY_IO_RATIO_PROPERTY_NAME = "vertx.nettyIORatio";
    private static final int NETTY_IO_RATIO = Integer.getInteger("vertx.nettyIORatio", 50);
    private final FileSystem fileSystem = this.getFileSystem();
    private final SharedData sharedData;
    private final VertxMetrics metrics;
    private final ConcurrentMap<Long, InternalTimerHandler> timeouts = new ConcurrentHashMap<Long, InternalTimerHandler>();
    private final AtomicLong timeoutCounter = new AtomicLong(0L);
    private final ClusterManager clusterManager;
    private final NodeSelector nodeSelector;
    private final DeploymentManager deploymentManager;
    private final VerticleManager verticleManager;
    private final FileResolver fileResolver;
    private final Map<ServerID, HttpServerImpl> sharedHttpServers = new HashMap<ServerID, HttpServerImpl>();
    private final Map<ServerID, NetServerImpl> sharedNetServers = new HashMap<ServerID, NetServerImpl>();
    final WorkerPool workerPool;
    final WorkerPool internalBlockingPool;
    private final ThreadFactory eventLoopThreadFactory;
    private final EventLoopGroup eventLoopGroup;
    private final EventLoopGroup acceptorEventLoopGroup;
    private final BlockedThreadChecker checker;
    private final AddressResolver addressResolver;
    private final AddressResolverOptions addressResolverOptions;
    private final EventBusInternal eventBus;
    private volatile HAManager haManager;
    private boolean closed;
    private volatile Handler<Throwable> exceptionHandler;
    private final Map<String, SharedWorkerPool> namedWorkerPools;
    private final int defaultWorkerPoolSize;
    private final long maxWorkerExecTime;
    private final TimeUnit maxWorkerExecTimeUnit;
    private final long maxEventLoopExecTime;
    private final TimeUnit maxEventLoopExecTimeUnit;
    private final CloseHooks closeHooks;
    private final Transport transport;
    private final VertxTracer tracer;
    private final ThreadLocal<WeakReference<AbstractContext>> stickyContext = new ThreadLocal();

    VertxImpl(VertxOptions options, ClusterManager clusterManager, NodeSelector nodeSelector, VertxMetrics metrics, VertxTracer<?, ?> tracer, Transport transport, FileResolver fileResolver) {
        if (Vertx.currentContext() != null) {
            log.warn("You're already on a Vert.x context, are you sure you want to create a new Vertx instance?");
        }
        this.closeHooks = new CloseHooks(log);
        this.maxEventLoopExecTime = options.getMaxEventLoopExecuteTime();
        this.maxEventLoopExecTimeUnit = options.getMaxEventLoopExecuteTimeUnit();
        this.checker = new BlockedThreadChecker(options.getBlockedThreadCheckInterval(), options.getBlockedThreadCheckIntervalUnit(), options.getWarningExceptionTime(), options.getWarningExceptionTimeUnit());
        this.eventLoopThreadFactory = new VertxThreadFactory("vert.x-eventloop-thread-", this.checker, false, this.maxEventLoopExecTime, this.maxEventLoopExecTimeUnit);
        this.eventLoopGroup = transport.eventLoopGroup(1, options.getEventLoopPoolSize(), this.eventLoopThreadFactory, NETTY_IO_RATIO);
        VertxThreadFactory acceptorEventLoopThreadFactory = new VertxThreadFactory("vert.x-acceptor-thread-", this.checker, false, options.getMaxEventLoopExecuteTime(), options.getMaxEventLoopExecuteTimeUnit());
        this.acceptorEventLoopGroup = transport.eventLoopGroup(0, 1, acceptorEventLoopThreadFactory, 100);
        int workerPoolSize = options.getWorkerPoolSize();
        ThreadPoolExecutor workerExec = new ThreadPoolExecutor(workerPoolSize, workerPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), new VertxThreadFactory("vert.x-worker-thread-", this.checker, true, options.getMaxWorkerExecuteTime(), options.getMaxWorkerExecuteTimeUnit()));
        PoolMetrics<?> workerPoolMetrics = metrics != null ? metrics.createPoolMetrics("worker", "vert.x-worker-thread", options.getWorkerPoolSize()) : null;
        ExecutorService internalBlockingExec = Executors.newFixedThreadPool(options.getInternalBlockingPoolSize(), new VertxThreadFactory("vert.x-internal-blocking-", this.checker, true, options.getMaxWorkerExecuteTime(), options.getMaxWorkerExecuteTimeUnit()));
        PoolMetrics<?> internalBlockingPoolMetrics = metrics != null ? metrics.createPoolMetrics("worker", "vert.x-internal-blocking", options.getInternalBlockingPoolSize()) : null;
        this.internalBlockingPool = new WorkerPool(internalBlockingExec, internalBlockingPoolMetrics);
        this.namedWorkerPools = new HashMap<String, SharedWorkerPool>();
        this.workerPool = new WorkerPool(workerExec, workerPoolMetrics);
        this.defaultWorkerPoolSize = options.getWorkerPoolSize();
        this.maxWorkerExecTime = options.getMaxWorkerExecuteTime();
        this.maxWorkerExecTimeUnit = options.getMaxWorkerExecuteTimeUnit();
        this.metrics = metrics;
        this.transport = transport;
        this.fileResolver = fileResolver;
        this.addressResolverOptions = options.getAddressResolverOptions();
        this.addressResolver = new AddressResolver(this, options.getAddressResolverOptions());
        this.tracer = tracer;
        this.clusterManager = clusterManager;
        this.nodeSelector = nodeSelector;
        this.eventBus = clusterManager != null ? new ClusteredEventBus(this, options, clusterManager, nodeSelector) : new EventBusImpl(this);
        this.sharedData = new SharedDataImpl(this, clusterManager);
        this.deploymentManager = new DeploymentManager(this);
        this.verticleManager = new VerticleManager(this, this.deploymentManager);
    }

    void init() {
        this.eventBus.start(Promise.promise());
        if (this.metrics != null) {
            this.metrics.vertxCreated(this);
        }
    }

    void initClustered(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        this.nodeSelector.init(this, this.clusterManager);
        this.clusterManager.init(this, this.nodeSelector);
        PromiseInternal initPromise = this.getOrCreateContext().promise();
        initPromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                if (this.metrics != null) {
                    this.metrics.vertxCreated(this);
                }
                resultHandler.handle(Future.succeededFuture(this));
            } else {
                log.error("Failed to initialize clustered Vert.x", ar.cause());
                this.close().onComplete(ignore -> resultHandler.handle(Future.failedFuture(ar.cause())));
            }
        });
        Promise<Void> joinPromise = Promise.promise();
        joinPromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                this.createHaManager(options, initPromise);
            } else {
                initPromise.fail(ar.cause());
            }
        });
        this.clusterManager.join(joinPromise);
    }

    private void createHaManager(VertxOptions options, Promise<Void> initPromise) {
        this.executeBlocking(fut -> {
            Map<String, String> syncMap = this.clusterManager.getSyncMap(CLUSTER_MAP_NAME);
            HAManager haManager = new HAManager(this, this.deploymentManager, this.verticleManager, this.clusterManager, syncMap, options.getQuorumSize(), options.getHAGroup(), options.isHAEnabled());
            fut.complete(haManager);
        }, false, ar -> {
            if (ar.succeeded()) {
                this.haManager = (HAManager)ar.result();
                this.startEventBus(initPromise);
            } else {
                initPromise.fail(ar.cause());
            }
        });
    }

    private void startEventBus(Promise<Void> initPromise) {
        Promise<Void> promise = Promise.promise();
        this.eventBus.start(promise);
        promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                this.initializeHaManager(initPromise);
            } else {
                initPromise.fail(ar.cause());
            }
        });
    }

    private void initializeHaManager(Promise<Void> initPromise) {
        this.executeBlocking(fut -> {
            this.haManager.init();
            fut.complete();
        }, false, initPromise);
    }

    protected FileSystem getFileSystem() {
        return Utils.isWindows() ? new WindowsFileSystem(this) : new FileSystemImpl(this);
    }

    @Override
    public long maxEventLoopExecTime() {
        return this.maxEventLoopExecTime;
    }

    @Override
    public TimeUnit maxEventLoopExecTimeUnit() {
        return this.maxEventLoopExecTimeUnit;
    }

    @Override
    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        return DatagramSocketImpl.create(this, options);
    }

    @Override
    public DatagramSocket createDatagramSocket() {
        return this.createDatagramSocket(new DatagramSocketOptions());
    }

    @Override
    public NetServer createNetServer(NetServerOptions options) {
        return new NetServerImpl(this, options);
    }

    @Override
    public NetServer createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    @Override
    public NetClient createNetClient(NetClientOptions options, CloseFuture closeFuture) {
        NetClientImpl client = new NetClientImpl(this, options, closeFuture);
        closeFuture.init(client);
        return client;
    }

    @Override
    public NetClient createNetClient(NetClientOptions options) {
        CloseFuture closeFuture = new CloseFuture();
        NetClient client = this.createNetClient(options, closeFuture);
        CloseHooks hooks = this.resolveHooks();
        hooks.add(closeFuture);
        return client;
    }

    @Override
    public NetClient createNetClient() {
        return this.createNetClient(new NetClientOptions());
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public boolean isNativeTransportEnabled() {
        return this.transport != Transport.JDK;
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public HttpServer createHttpServer(HttpServerOptions serverOptions) {
        return new HttpServerImpl((VertxInternal)this, serverOptions);
    }

    @Override
    public HttpServer createHttpServer() {
        return this.createHttpServer(new HttpServerOptions());
    }

    @Override
    public HttpClient createHttpClient(HttpClientOptions options, CloseFuture closeFuture) {
        HttpClientImpl client = new HttpClientImpl(this, options, closeFuture);
        closeFuture.init(client);
        return client;
    }

    @Override
    public HttpClient createHttpClient(HttpClientOptions options) {
        CloseFuture closeFuture = new CloseFuture();
        HttpClient client = this.createHttpClient(options, closeFuture);
        CloseHooks hooks = this.resolveHooks();
        hooks.add(closeFuture);
        return client;
    }

    @Override
    public HttpClient createHttpClient() {
        return this.createHttpClient(new HttpClientOptions());
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, true);
    }

    @Override
    public TimeoutStream periodicStream(long delay) {
        return new TimeoutStreamImpl(delay, true);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, false);
    }

    @Override
    public TimeoutStream timerStream(long delay) {
        return new TimeoutStreamImpl(delay, false);
    }

    @Override
    public <T> PromiseInternal<T> promise() {
        ContextInternal context = this.getOrCreateContext();
        return context.promise();
    }

    @Override
    public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        if (handler instanceof PromiseInternal) {
            return (PromiseInternal)handler;
        }
        PromiseInternal<T> promise = this.promise();
        promise.future().onComplete(handler);
        return promise;
    }

    @Override
    public void runOnContext(Handler<Void> task) {
        ContextInternal context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    @Override
    public ExecutorService getWorkerPool() {
        return this.workerPool.executor();
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public EventLoopGroup getAcceptorEventLoopGroup() {
        return this.acceptorEventLoopGroup;
    }

    @Override
    public ContextInternal getOrCreateContext() {
        AbstractContext ctx = this.getContext();
        if (ctx == null) {
            ctx = this.createEventLoopContext();
            this.stickyContext.set(new WeakReference<AbstractContext>(ctx));
        }
        return ctx;
    }

    @Override
    public Map<ServerID, HttpServerImpl> sharedHttpServers() {
        return this.sharedHttpServers;
    }

    @Override
    public Map<ServerID, NetServerImpl> sharedNetServers() {
        return this.sharedNetServers;
    }

    @Override
    public <S extends TCPServerBase> Map<ServerID, S> sharedTCPServers(Class<S> type) {
        if (type == NetServerImpl.class) {
            return this.sharedNetServers;
        }
        if (type == HttpServerImpl.class) {
            return this.sharedHttpServers;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean cancelTimer(long id) {
        InternalTimerHandler handler = (InternalTimerHandler)this.timeouts.remove(id);
        if (handler != null) {
            handler.cancel();
            return true;
        }
        return false;
    }

    @Override
    public EventLoopContext createEventLoopContext(Deployment deployment, CloseHooks closeHooks, WorkerPool workerPool, ClassLoader tccl) {
        return new EventLoopContext(this, this.tracer, this.eventLoopGroup.next(), this.internalBlockingPool, workerPool != null ? workerPool : this.workerPool, deployment, closeHooks, tccl);
    }

    @Override
    public EventLoopContext createEventLoopContext(EventLoop eventLoop, WorkerPool workerPool, ClassLoader tccl) {
        return new EventLoopContext(this, this.tracer, eventLoop, this.internalBlockingPool, workerPool != null ? workerPool : this.workerPool, null, null, tccl);
    }

    @Override
    public EventLoopContext createEventLoopContext() {
        return this.createEventLoopContext(null, null, null, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public WorkerContext createWorkerContext(Deployment deployment, CloseHooks closeHooks, WorkerPool workerPool, ClassLoader tccl) {
        return new WorkerContext(this, this.tracer, this.internalBlockingPool, workerPool != null ? workerPool : this.workerPool, deployment, closeHooks, tccl);
    }

    @Override
    public WorkerContext createWorkerContext() {
        return this.createWorkerContext(null, null, null, null);
    }

    @Override
    public DnsClient createDnsClient(int port, String host) {
        return this.createDnsClient(new DnsClientOptions().setHost(host).setPort(port));
    }

    @Override
    public DnsClient createDnsClient() {
        return this.createDnsClient(new DnsClientOptions());
    }

    @Override
    public DnsClient createDnsClient(DnsClientOptions options) {
        String host = options.getHost();
        int port = options.getPort();
        if (host == null || port < 0) {
            DnsResolverProvider provider = new DnsResolverProvider(this, this.addressResolverOptions);
            InetSocketAddress address = provider.nameServerAddresses().get(0);
            options = new DnsClientOptions(options).setHost(address.getAddress().getHostAddress()).setPort(address.getPort());
        }
        return new DnsClientImpl(this, options);
    }

    public long scheduleTimeout(ContextInternal context, Handler<Long> handler, long delay, boolean periodic) {
        if (delay < 1L) {
            throw new IllegalArgumentException("Cannot schedule a timer with delay < 1 ms");
        }
        long timerId = this.timeoutCounter.getAndIncrement();
        InternalTimerHandler task = new InternalTimerHandler(timerId, handler, periodic, delay, context);
        this.timeouts.put(timerId, task);
        if (context.isDeployment()) {
            context.addCloseHook(task);
        }
        return timerId;
    }

    @Override
    public AbstractContext getContext() {
        AbstractContext context = (AbstractContext)ContextInternal.current();
        if (context != null && context.owner() == this) {
            return context;
        }
        WeakReference<AbstractContext> ref = this.stickyContext.get();
        return ref != null ? (AbstractContext)ref.get() : null;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public Future<Void> close() {
        Promise<Void> promise = Promise.promise();
        this.close(promise);
        return promise.future();
    }

    private void closeClusterManager(Handler<AsyncResult<Void>> completionHandler) {
        PromiseInternal<Void> leavePromise = this.getOrCreateContext().promise();
        if (this.clusterManager != null) {
            this.clusterManager.leave(leavePromise);
        } else {
            leavePromise.complete();
        }
        leavePromise.future().onComplete(ar -> {
            if (ar.failed()) {
                log.error("Failed to leave cluster", ar.cause());
            }
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
        });
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed || this.eventBus == null) {
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
            return;
        }
        this.closed = true;
        this.closeHooks.run(ar -> this.deploymentManager.undeployAll().onComplete(ar1 -> {
            HAManager haManager = this.haManager();
            Promise haPromise = Promise.promise();
            if (haManager != null) {
                this.executeBlocking(fut -> {
                    haManager.stop();
                    fut.complete();
                }, false, haPromise);
            } else {
                haPromise.complete();
            }
            haPromise.future().onComplete(ar2 -> this.addressResolver.close((Void ar3) -> {
                PromiseInternal<Void> ebClose = this.getOrCreateContext().promise();
                this.eventBus.close(ebClose);
                ebClose.future().onComplete(ar4 -> this.closeClusterManager(ar5 -> this.deleteCacheDirAndShutdown(completionHandler)));
            }));
        }));
    }

    @Override
    public Future<String> deployVerticle(String name) {
        return this.deployVerticle(name, new DeploymentOptions());
    }

    @Override
    public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(name, new DeploymentOptions(), completionHandler);
    }

    @Override
    public Future<String> deployVerticle(String name, DeploymentOptions options) {
        if (options.isHa() && this.haManager() != null && this.haManager().isEnabled()) {
            PromiseInternal<String> promise = this.getOrCreateContext().promise();
            this.haManager().deployVerticle(name, options, promise);
            return promise.future();
        }
        return this.verticleManager.deployVerticle(name, options).map(Deployment::deploymentID);
    }

    @Override
    public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(name, options);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Future<String> deployVerticle(Verticle verticle) {
        return this.deployVerticle(verticle, new DeploymentOptions());
    }

    @Override
    public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticle);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Future<String> deployVerticle(Verticle verticle, DeploymentOptions options) {
        if (options.getInstances() != 1) {
            throw new IllegalArgumentException("Can't specify > 1 instances for already created verticle");
        }
        return this.deployVerticle(() -> verticle, options);
    }

    @Override
    public void deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticle, options);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Future<String> deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options) {
        return this.deployVerticle(verticleClass::newInstance, options);
    }

    @Override
    public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticleClass, options);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Future<String> deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        return this.deployVerticle(verticleSupplier::get, options);
    }

    @Override
    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticleSupplier, options);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<String> deployVerticle(Callable<Verticle> verticleSupplier, DeploymentOptions options) {
        boolean closed;
        VertxImpl vertxImpl = this;
        synchronized (vertxImpl) {
            closed = this.closed;
        }
        if (closed) {
            return Future.failedFuture("Vert.x closed");
        }
        return this.deploymentManager.deployVerticle(verticleSupplier, options);
    }

    @Override
    public Future<Void> undeploy(String deploymentID) {
        HAManager haManager = this.haManager();
        Future<Void> future = haManager != null && haManager.isEnabled() ? this.executeBlocking((Promise<T> fut) -> {
            haManager.removeFromHA(deploymentID);
            fut.complete();
        }, false) : this.getOrCreateContext().succeededFuture();
        return future.compose(v -> this.deploymentManager.undeployVerticle(deploymentID));
    }

    @Override
    public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        Future<Void> fut = this.undeploy(deploymentID);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Set<String> deploymentIDs() {
        return this.deploymentManager.deployments();
    }

    @Override
    public void registerVerticleFactory(VerticleFactory factory) {
        this.verticleManager.registerVerticleFactory(factory);
    }

    @Override
    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.verticleManager.unregisterVerticleFactory(factory);
    }

    @Override
    public Set<VerticleFactory> verticleFactories() {
        return this.verticleManager.verticleFactories();
    }

    @Override
    public <T> void executeBlockingInternal(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        ContextInternal context = this.getOrCreateContext();
        context.executeBlockingInternal(blockingCodeHandler, resultHandler);
    }

    @Override
    public <T> void executeBlockingInternal(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        ContextInternal context = this.getOrCreateContext();
        context.executeBlockingInternal(blockingCodeHandler, ordered, resultHandler);
    }

    @Override
    public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        ContextInternal context = this.getOrCreateContext();
        return context.executeBlocking(blockingCodeHandler, ordered);
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        ContextInternal context = this.getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, ordered, asyncResultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
        this.executeBlocking(blockingCodeHandler, true, asyncResultHandler);
    }

    @Override
    public boolean isClustered() {
        return this.clusterManager != null;
    }

    @Override
    public EventLoopGroup nettyEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public void simulateKill() {
        if (this.haManager() != null) {
            this.haManager().simulateKill();
        }
    }

    @Override
    public Deployment getDeployment(String deploymentID) {
        return this.deploymentManager.getDeployment(deploymentID);
    }

    @Override
    public synchronized void failoverCompleteHandler(FailoverCompleteHandler failoverCompleteHandler) {
        if (this.haManager() != null) {
            this.haManager().setFailoverCompleteHandler(failoverCompleteHandler);
        }
    }

    @Override
    public boolean isKilled() {
        return this.haManager().isKilled();
    }

    @Override
    public void failDuringFailover(boolean fail) {
        if (this.haManager() != null) {
            this.haManager().failDuringFailover(fail);
        }
    }

    @Override
    public VertxMetrics metricsSPI() {
        return this.metrics;
    }

    @Override
    public File resolveFile(String fileName) {
        return this.fileResolver.resolveFile(fileName);
    }

    @Override
    public void resolveAddress(String hostname, Handler<AsyncResult<InetAddress>> resultHandler) {
        this.addressResolver.resolveHostname(hostname, resultHandler);
    }

    @Override
    public AddressResolver addressResolver() {
        return this.addressResolver;
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.addressResolver.nettyAddressResolverGroup();
    }

    @Override
    public BlockedThreadChecker blockedThreadChecker() {
        return this.checker;
    }

    private void deleteCacheDirAndShutdown(final Handler<AsyncResult<Void>> completionHandler) {
        this.executeBlockingInternal(fut -> {
            try {
                this.fileResolver.close();
                fut.complete();
            }
            catch (IOException e) {
                fut.tryFail(e);
            }
        }, ar -> {
            this.workerPool.close();
            this.internalBlockingPool.close();
            new ArrayList<SharedWorkerPool>(this.namedWorkerPools.values()).forEach(WorkerPool::close);
            this.acceptorEventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                    if (!future.isSuccess()) {
                        log.warn("Failure in shutting down acceptor event loop group", future.cause());
                    }
                    VertxImpl.this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                        public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                            if (!future.isSuccess()) {
                                log.warn("Failure in shutting down event loop group", future.cause());
                            }
                            if (VertxImpl.this.metrics != null) {
                                VertxImpl.this.metrics.close();
                            }
                            if (VertxImpl.this.tracer != null) {
                                VertxImpl.this.tracer.close();
                            }
                            VertxImpl.this.checker.close();
                            if (completionHandler != null) {
                                VertxImpl.this.eventLoopThreadFactory.newThread(() -> completionHandler.handle(Future.succeededFuture())).start();
                            }
                        }
                    });
                }
            });
        });
    }

    @Override
    public HAManager haManager() {
        return this.haManager;
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name) {
        return this.createSharedWorkerExecutor(name, this.defaultWorkerPoolSize);
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize) {
        return this.createSharedWorkerExecutor(name, poolSize, this.maxWorkerExecTime);
    }

    @Override
    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
        return this.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, this.maxWorkerExecTimeUnit);
    }

    @Override
    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        CloseHooks hooks;
        SharedWorkerPool sharedWorkerPool = this.createSharedWorkerPool(name, poolSize, maxExecuteTime, maxExecuteTimeUnit);
        AbstractContext ctx = this.getContext();
        CloseHooks closeHooks = hooks = ctx != null ? ctx.closeHooks() : null;
        if (hooks == null) {
            hooks = this.closeHooks;
        }
        WorkerExecutorImpl namedExec = new WorkerExecutorImpl(this, this.closeHooks, sharedWorkerPool);
        hooks.add(namedExec);
        return namedExec;
    }

    @Override
    public synchronized SharedWorkerPool createSharedWorkerPool(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be > 0");
        }
        if (maxExecuteTime < 1L) {
            throw new IllegalArgumentException("maxExecuteTime must be > 0");
        }
        SharedWorkerPool sharedWorkerPool = this.namedWorkerPools.get(name);
        if (sharedWorkerPool == null) {
            ExecutorService workerExec = Executors.newFixedThreadPool(poolSize, new VertxThreadFactory(name + "-", this.checker, true, maxExecuteTime, maxExecuteTimeUnit));
            PoolMetrics<?> workerMetrics = this.metrics != null ? this.metrics.createPoolMetrics("worker", name, poolSize) : null;
            sharedWorkerPool = new SharedWorkerPool(name, workerExec, workerMetrics);
            this.namedWorkerPools.put(name, sharedWorkerPool);
        } else {
            sharedWorkerPool.refCount++;
        }
        return sharedWorkerPool;
    }

    @Override
    public Vertx exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void addCloseHook(Closeable hook) {
        this.closeHooks.add(hook);
    }

    @Override
    public void removeCloseHook(Closeable hook) {
        this.closeHooks.remove(hook);
    }

    private CloseHooks resolveHooks() {
        CloseHooks hooks;
        AbstractContext context = this.getContext();
        CloseHooks closeHooks = hooks = context != null ? context.closeHooks() : null;
        if (hooks == null) {
            hooks = this.closeHooks;
        }
        return hooks;
    }

    static {
        if (System.getProperty("io.netty.leakDetection.level") != null || System.getProperty("io.netty.leakDetectionLevel") != null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        System.setProperty("io.netty.noJdkZlibDecoder", "false");
    }

    class SharedWorkerPool
    extends WorkerPool {
        private final String name;
        private int refCount;

        SharedWorkerPool(String name, ExecutorService workerExec, PoolMetrics workerMetrics) {
            super(workerExec, workerMetrics);
            this.refCount = 1;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void close() {
            VertxImpl vertxImpl = VertxImpl.this;
            synchronized (vertxImpl) {
                if (this.refCount > 0) {
                    this.refCount = 0;
                    super.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            VertxImpl vertxImpl = VertxImpl.this;
            synchronized (vertxImpl) {
                if (--this.refCount == 0) {
                    VertxImpl.this.namedWorkerPools.remove(this.name);
                    super.close();
                }
            }
        }
    }

    private class TimeoutStreamImpl
    implements TimeoutStream,
    Handler<Long> {
        private final long delay;
        private final boolean periodic;
        private Long id;
        private Handler<Long> handler;
        private Handler<Void> endHandler;
        private long demand;

        public TimeoutStreamImpl(long delay, boolean periodic) {
            this.delay = delay;
            this.periodic = periodic;
            this.demand = Long.MAX_VALUE;
        }

        @Override
        public synchronized void handle(Long event) {
            try {
                if (this.demand > 0L) {
                    --this.demand;
                    this.handler.handle(event);
                }
            }
            finally {
                if (!this.periodic && this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }

        @Override
        public synchronized TimeoutStream fetch(long amount) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            return this;
        }

        @Override
        public TimeoutStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        @Override
        public void cancel() {
            if (this.id != null) {
                VertxImpl.this.cancelTimer(this.id);
            }
        }

        @Override
        public synchronized TimeoutStream handler(Handler<Long> handler) {
            if (handler != null) {
                if (this.id != null) {
                    throw new IllegalStateException();
                }
                this.handler = handler;
                this.id = VertxImpl.this.scheduleTimeout(VertxImpl.this.getOrCreateContext(), this, this.delay, this.periodic);
            } else {
                this.cancel();
            }
            return this;
        }

        @Override
        public synchronized TimeoutStream pause() {
            this.demand = 0L;
            return this;
        }

        @Override
        public synchronized TimeoutStream resume() {
            this.demand = Long.MAX_VALUE;
            return this;
        }

        @Override
        public synchronized TimeoutStream endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }
    }

    private class InternalTimerHandler
    implements Handler<Void>,
    Closeable,
    Runnable {
        private final Handler<Long> handler;
        private final boolean periodic;
        private final long timerID;
        private final ContextInternal context;
        private final java.util.concurrent.Future<?> future;

        InternalTimerHandler(long timerID, Handler<Long> runnable, boolean periodic, long delay, ContextInternal context) {
            this.context = context;
            this.timerID = timerID;
            this.handler = runnable;
            this.periodic = periodic;
            EventLoop el = context.nettyEventLoop();
            this.future = periodic ? el.scheduleAtFixedRate((Runnable)this, delay, delay, TimeUnit.MILLISECONDS) : el.schedule((Runnable)this, delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            this.context.emit(this);
        }

        @Override
        public void handle(Void v) {
            if (this.periodic) {
                if (VertxImpl.this.timeouts.containsKey(this.timerID)) {
                    this.handler.handle(this.timerID);
                }
            } else if (VertxImpl.this.timeouts.remove(this.timerID) != null) {
                try {
                    this.handler.handle(this.timerID);
                }
                finally {
                    this.context.removeCloseHook(this);
                }
            }
        }

        private void cancel() {
            this.future.cancel(false);
            if (this.context.isDeployment()) {
                this.context.removeCloseHook(this);
            }
        }

        @Override
        public void close(Promise<Void> completion) {
            if (VertxImpl.this.timeouts.remove(this.timerID) != null) {
                this.future.cancel(false);
            }
            completion.complete();
        }
    }
}

