/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.MappingStrategy;
import ma.glasnost.orika.Properties;
import ma.glasnost.orika.cern.colt.map.OpenIntObjectHashMap;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;

public class MappingContext {
    protected final Map<Type<?>, Type<?>> mapping = new HashMap();
    protected final OpenIntObjectHashMap typeCache = new OpenIntObjectHashMap();
    protected List<Map<MapperKey, ClassMap<?, ?>>> mappersSeen;
    protected Map<Object, Object> properties;
    protected Map<Object, Object> globalProperties;
    protected boolean isNew = true;
    protected boolean containsCycle = true;
    protected int depth;
    protected Type<?> resolvedSourceType;
    protected Type<?> resolvedDestinationType;
    protected MappingStrategy resolvedStrategy;
    protected List<Object[]> fieldMappingStack;
    protected boolean capturesFieldContext;

    public MappingContext(Map<Object, Object> globalProperties) {
        this.globalProperties = globalProperties;
        Boolean capture = globalProperties != null ? (Boolean)globalProperties.get((Object)Properties.CAPTURE_FIELD_CONTEXT) : null;
        this.capturesFieldContext = capture == null || capture != false;
    }

    public void containsCycle(boolean containsCycle) {
        this.containsCycle = containsCycle;
    }

    public boolean containsCycle() {
        return this.containsCycle;
    }

    public int getDepth() {
        return this.depth;
    }

    public <S, D> Type<? extends D> getConcreteClass(Type<S> sourceType, Type<D> destinationType) {
        if (this.isNew) {
            return null;
        }
        Type<?> type = this.mapping.get(sourceType);
        if (type != null && destinationType.isAssignableFrom(type)) {
            return type;
        }
        return null;
    }

    public void registerConcreteClass(Type<?> subjectClass, Type<?> concreteClass) {
        this.mapping.put(subjectClass, concreteClass);
        this.isNew = false;
    }

    public <S, D> void cacheMappedObject(S source, Type<Object> destinationType, D destination) {
        if (this.containsCycle) {
            IdentityHashMap<S, D> localCache = (IdentityHashMap<S, D>)this.typeCache.get(destinationType.getUniqueIndex());
            if (localCache == null) {
                localCache = new IdentityHashMap<S, D>(2);
                this.typeCache.put(destinationType.getUniqueIndex(), localCache);
            }
            localCache.put(source, destination);
            this.isNew = false;
        }
    }

    public <D> D getMappedObject(Object source, Type<?> destinationType) {
        if (this.isNew || !this.containsCycle) {
            return null;
        }
        Map localCache = (Map)this.typeCache.get(destinationType.getUniqueIndex());
        return localCache == null ? null : (D)localCache.get(source);
    }

    public void registerMapperGeneration(ClassMap<?, ?> classMap) {
        Map<MapperKey, ClassMap<?, ?>> list;
        if (this.mappersSeen == null) {
            this.mappersSeen = new ArrayList();
        }
        Map<MapperKey, ClassMap<?, ?>> map = list = this.mappersSeen.isEmpty() ? null : this.mappersSeen.get(this.depth - 1);
        if (list == null) {
            list = new HashMap();
        }
        list.put(classMap.getMapperKey(), classMap);
    }

    public ClassMap<?, ?> getMapperGeneration(MapperKey mapperKey) {
        Map<MapperKey, ClassMap<?, ?>> map;
        ClassMap result = null;
        Map<MapperKey, ClassMap<?, ?>> map2 = map = this.mappersSeen == null || this.mappersSeen.isEmpty() ? null : this.mappersSeen.get(this.depth - 1);
        if (map != null) {
            result = (ClassMap)map.get(mapperKey);
        }
        return result;
    }

    @Deprecated
    public void beginMapping() {
        ++this.depth;
    }

    @Deprecated
    public void beginMapping(Type<?> sourceType, Object source, Type<?> destType, Object dest) {
        this.beginMapping();
    }

    public void beginMappingField(String sourceName, Type<?> sourceType, Object source, String destName, Type<?> destType, Object dest) {
        if (this.fieldMappingStack == null) {
            this.fieldMappingStack = new ArrayList<Object[]>();
        }
        Object[] stackElement = new Object[StackElement.values().length];
        stackElement[StackElement.SOURCE_NAME.ordinal()] = sourceName;
        stackElement[StackElement.SOURCE_TYPE.ordinal()] = sourceType;
        stackElement[StackElement.SOURCE.ordinal()] = source;
        stackElement[StackElement.DEST_NAME.ordinal()] = destName;
        stackElement[StackElement.DEST_TYPE.ordinal()] = destType;
        stackElement[StackElement.DEST.ordinal()] = dest;
        this.fieldMappingStack.add(stackElement);
    }

    public void endMappingField() {
        this.fieldMappingStack.remove(this.fieldMappingStack.size() - 1);
    }

    public String getFullyQualifiedSourcePath() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        StringBuilder path = new StringBuilder("source");
        for (Object[] element : this.fieldMappingStack) {
            path.append(".");
            path.append(element[StackElement.SOURCE_NAME.ordinal()]);
        }
        return path.toString();
    }

    public String[] getSourceExpressionPaths() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        String[] path = new String[this.fieldMappingStack.size()];
        int idx = 0;
        for (Object[] element : this.fieldMappingStack) {
            path[idx++] = (String)element[StackElement.SOURCE_NAME.ordinal()];
        }
        return path;
    }

    public Object[] getSourceObjects() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        Object[] path = new Object[this.fieldMappingStack.size()];
        int idx = 0;
        for (Object[] element : this.fieldMappingStack) {
            path[idx++] = element[StackElement.SOURCE.ordinal()];
        }
        return path;
    }

    public java.lang.reflect.Type[] getSourceTypePaths() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        java.lang.reflect.Type[] path = new java.lang.reflect.Type[this.fieldMappingStack.size()];
        int idx = 0;
        for (Object[] element : this.fieldMappingStack) {
            path[idx++] = (java.lang.reflect.Type)element[StackElement.SOURCE_TYPE.ordinal()];
        }
        return path;
    }

    public String getFullyQualifiedDestinationPath() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        StringBuilder path = new StringBuilder("destination");
        for (Object[] element : this.fieldMappingStack) {
            path.append(".");
            path.append(element[StackElement.DEST_NAME.ordinal()]);
        }
        return path.toString();
    }

    public String[] getDestinationExpressionPaths() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        String[] path = new String[this.fieldMappingStack.size()];
        int idx = 0;
        for (Object[] element : this.fieldMappingStack) {
            path[idx++] = (String)element[StackElement.DEST_NAME.ordinal()];
        }
        return path;
    }

    public Object[] getDestinationObjects() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        Object[] path = new Object[this.fieldMappingStack.size()];
        int idx = 0;
        for (Object[] element : this.fieldMappingStack) {
            path[idx++] = element[StackElement.DEST.ordinal()];
        }
        return path;
    }

    public java.lang.reflect.Type[] getDestinationTypePaths() {
        if (!this.capturesFieldContext || this.fieldMappingStack == null) {
            return null;
        }
        java.lang.reflect.Type[] path = new java.lang.reflect.Type[this.fieldMappingStack.size()];
        int idx = 0;
        for (Object[] element : this.fieldMappingStack) {
            path[idx++] = (java.lang.reflect.Type)element[StackElement.DEST_TYPE.ordinal()];
        }
        return path;
    }

    public void endMapping() {
        --this.depth;
    }

    public void reset() {
        this.mapping.clear();
        this.typeCache.clear();
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.mappersSeen != null) {
            this.mappersSeen.clear();
        }
        if (this.fieldMappingStack != null) {
            this.fieldMappingStack.clear();
        }
        this.resolvedSourceType = null;
        this.resolvedDestinationType = null;
        this.resolvedStrategy = null;
        this.isNew = true;
        this.depth = 0;
    }

    public void setProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        Object result;
        Object object = result = this.properties != null ? this.properties.get(key) : null;
        if (result == null && this.globalProperties != null) {
            result = this.globalProperties.get(key);
        }
        return result;
    }

    public Type<?> getResolvedSourceType() {
        return this.resolvedSourceType;
    }

    public void setResolvedSourceType(Type<?> resolvedSourceType) {
        this.resolvedSourceType = resolvedSourceType;
    }

    public Type<?> getResolvedDestinationType() {
        return this.resolvedDestinationType;
    }

    public void setResolvedDestinationType(Type<?> resolvedDestinationType) {
        this.resolvedDestinationType = resolvedDestinationType;
    }

    public MappingStrategy getResolvedStrategy() {
        return this.resolvedStrategy;
    }

    public void setResolvedStrategy(MappingStrategy resolvedStrategy) {
        this.resolvedStrategy = resolvedStrategy;
    }

    public static class Factory
    implements MappingContextFactory {
        LinkedBlockingQueue<MappingContext> contextQueue = new LinkedBlockingQueue();
        ConcurrentHashMap<Object, Object> globalProperties = new ConcurrentHashMap();

        @Override
        public MappingContext getContext() {
            MappingContext context = this.contextQueue.poll();
            if (context == null) {
                context = new MappingContext(this.globalProperties);
            }
            context.containsCycle = true;
            return context;
        }

        @Override
        public void release(MappingContext context) {
            context.reset();
            this.contextQueue.offer(context);
        }

        @Override
        public Map<Object, Object> getGlobalProperties() {
            return this.globalProperties;
        }
    }

    public static enum StackElement {
        SOURCE_NAME,
        SOURCE_TYPE,
        SOURCE,
        DEST_NAME,
        DEST_TYPE,
        DEST;

    }
}

