/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import ma.glasnost.orika.util.Edge;
import ma.glasnost.orika.util.Node;

public class TopologicalSorter<V> {
    public static <T> List<T> sort(Collection<Node<T>> nodes) {
        LinkedHashSet openSet = new LinkedHashSet();
        HashSet<Edge> edgesDone = new HashSet<Edge>();
        for (Node<T> to : nodes) {
            if (!to.inEdges.isEmpty()) continue;
            openSet.add(to);
        }
        ArrayList result = new ArrayList();
        while (!openSet.isEmpty()) {
            Node n = (Node)openSet.iterator().next();
            openSet.remove(n);
            result.add(n.getValue());
            for (Edge edge : n.outEdges) {
                if (edgesDone.contains(edge)) continue;
                Node m = edge.to;
                edgesDone.add(edge);
                if (!edgesDone.containsAll(m.inEdges)) continue;
                openSet.add(m);
            }
        }
        if (nodes.size() > result.size()) {
            throw new IllegalStateException("Ordering contains cycles");
        }
        return result;
    }
}

