/*
 * Decompiled with CFR 0.152.
 */
package me.qmx.jitescript;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import me.qmx.jitescript.VisibleAnnotation;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CodeBlock
implements Opcodes {
    private final InsnList instructionList = new InsnList();
    private final List<TryCatchBlockNode> tryCatchBlockList = new ArrayList<TryCatchBlockNode>();
    private final List<LocalVariableNode> localVariableList = new ArrayList<LocalVariableNode>();
    private final List<VisibleAnnotation> annotations = new ArrayList<VisibleAnnotation>();
    private int arity = 0;
    private boolean returns = false;

    public CodeBlock() {
    }

    public CodeBlock(CodeBlock block) {
        this.arity = block.arity();
        this.prepend(block);
    }

    public CodeBlock(int arity) {
        this.arity = arity;
    }

    public static CodeBlock newCodeBlock() {
        return new CodeBlock();
    }

    public static CodeBlock newCodeBlock(int arity) {
        return new CodeBlock(arity);
    }

    public static CodeBlock newCodeBlock(CodeBlock block) {
        return new CodeBlock(block);
    }

    public CodeBlock aloadMany(int ... indices) {
        for (int index : indices) {
            this.aload(index);
        }
        return this;
    }

    public CodeBlock aload(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(25, index));
        return this;
    }

    public CodeBlock iload(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(21, index));
        return this;
    }

    public CodeBlock lload(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(22, index));
        return this;
    }

    public CodeBlock fload(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(23, index));
        return this;
    }

    public CodeBlock dload(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(24, index));
        return this;
    }

    public CodeBlock astore(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(58, index));
        return this;
    }

    public CodeBlock istore(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(54, index));
        return this;
    }

    public CodeBlock lstore(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(55, index));
        return this;
    }

    public CodeBlock fstore(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(56, index));
        return this;
    }

    public CodeBlock dstore(int index) {
        this.instructionList.add((AbstractInsnNode)new VarInsnNode(57, index));
        return this;
    }

    public CodeBlock ldc(Object value) {
        this.instructionList.add((AbstractInsnNode)new LdcInsnNode(value));
        return this;
    }

    public CodeBlock bipush(int byteValue) {
        this.instructionList.add((AbstractInsnNode)new IntInsnNode(16, byteValue));
        return this;
    }

    public CodeBlock sipush(int shortValue) {
        this.instructionList.add((AbstractInsnNode)new IntInsnNode(17, shortValue));
        return this;
    }

    public CodeBlock pushInt(int value) {
        if (value <= 127 && value >= -128) {
            switch (value) {
                case -1: {
                    this.iconst_m1();
                    break;
                }
                case 0: {
                    this.iconst_0();
                    break;
                }
                case 1: {
                    this.iconst_1();
                    break;
                }
                case 2: {
                    this.iconst_2();
                    break;
                }
                case 3: {
                    this.iconst_3();
                    break;
                }
                case 4: {
                    this.iconst_4();
                    break;
                }
                case 5: {
                    this.iconst_5();
                    break;
                }
                default: {
                    this.bipush(value);
                    break;
                }
            }
        } else if (value <= Short.MAX_VALUE && value >= Short.MIN_VALUE) {
            this.sipush(value);
        } else {
            this.ldc(value);
        }
        return this;
    }

    public CodeBlock pushBoolean(boolean bool) {
        if (bool) {
            this.iconst_1();
        } else {
            this.iconst_0();
        }
        return this;
    }

    public CodeBlock invokestatic(String className, String methodName, String methodDesc) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(184, className, methodName, methodDesc, false));
        return this;
    }

    public CodeBlock invokespecial(String className, String methodName, String methodDesc) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(183, className, methodName, methodDesc, false));
        return this;
    }

    public CodeBlock invokevirtual(String className, String methodName, String methodDesc) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(182, className, methodName, methodDesc, false));
        return this;
    }

    public CodeBlock invokeinterface(String className, String methodName, String methodDesc) {
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(185, className, methodName, methodDesc, true));
        return this;
    }

    public CodeBlock invokedynamic(String name, String descriptor, Handle bootstrapMethod, Object ... bootstrapArguments) {
        this.instructionList.add((AbstractInsnNode)new InvokeDynamicInsnNode(name, descriptor, bootstrapMethod, bootstrapArguments));
        return this;
    }

    public CodeBlock aprintln() {
        this.dup();
        this.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        this.swap();
        this.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        return this;
    }

    public CodeBlock iprintln() {
        this.dup();
        this.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        this.swap();
        this.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE)));
        return this;
    }

    public CodeBlock areturn() {
        this.returns = true;
        this.instructionList.add((AbstractInsnNode)new InsnNode(176));
        return this;
    }

    public CodeBlock ireturn() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(172));
        return this;
    }

    public CodeBlock freturn() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(174));
        return this;
    }

    public CodeBlock lreturn() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(173));
        return this;
    }

    public CodeBlock dreturn() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(175));
        return this;
    }

    public CodeBlock newobj(String desc) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(187, desc));
        return this;
    }

    public CodeBlock dup() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(89));
        return this;
    }

    public CodeBlock swap() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(95));
        return this;
    }

    public CodeBlock swap2() {
        this.dup2_x2();
        this.pop2();
        return this;
    }

    public CodeBlock getstatic(String className, String fieldName, String fieldDesc) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(178, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock putstatic(String className, String fieldName, String fieldDesc) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(179, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock getfield(String className, String fieldName, String fieldDesc) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(180, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock putfield(String className, String fieldName, String fieldDesc) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(181, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock voidreturn() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(177));
        return this;
    }

    public CodeBlock anewarray(String arrayDesc) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(189, arrayDesc));
        return this;
    }

    public CodeBlock multianewarray(String arrayDesc, int dims) {
        this.instructionList.add((AbstractInsnNode)new MultiANewArrayInsnNode(arrayDesc, dims));
        return this;
    }

    public CodeBlock newarray(int size) {
        this.instructionList.add((AbstractInsnNode)new IntInsnNode(188, size));
        return this;
    }

    public CodeBlock iconst_m1() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(2));
        return this;
    }

    public CodeBlock iconst_0() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(3));
        return this;
    }

    public CodeBlock iconst_1() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(4));
        return this;
    }

    public CodeBlock iconst_2() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(5));
        return this;
    }

    public CodeBlock iconst_3() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(6));
        return this;
    }

    public CodeBlock iconst_4() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(7));
        return this;
    }

    public CodeBlock iconst_5() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(8));
        return this;
    }

    public CodeBlock lconst_0() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(9));
        return this;
    }

    public CodeBlock aconst_null() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(1));
        return this;
    }

    public CodeBlock label(LabelNode labelNode) {
        this.instructionList.add((AbstractInsnNode)labelNode);
        return this;
    }

    public CodeBlock nop() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(0));
        return this;
    }

    public CodeBlock pop() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(87));
        return this;
    }

    public CodeBlock pop2() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(88));
        return this;
    }

    public CodeBlock arrayload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(50));
        return this;
    }

    public CodeBlock arraystore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(83));
        return this;
    }

    public CodeBlock iarrayload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(46));
        return this;
    }

    public CodeBlock barrayload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(51));
        return this;
    }

    public CodeBlock barraystore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(84));
        return this;
    }

    public CodeBlock aaload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(50));
        return this;
    }

    public CodeBlock aastore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(83));
        return this;
    }

    public CodeBlock iaload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(46));
        return this;
    }

    public CodeBlock iastore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(79));
        return this;
    }

    public CodeBlock laload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(47));
        return this;
    }

    public CodeBlock lastore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(80));
        return this;
    }

    public CodeBlock baload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(51));
        return this;
    }

    public CodeBlock bastore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(84));
        return this;
    }

    public CodeBlock saload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(53));
        return this;
    }

    public CodeBlock sastore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(86));
        return this;
    }

    public CodeBlock caload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(52));
        return this;
    }

    public CodeBlock castore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(85));
        return this;
    }

    public CodeBlock faload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(48));
        return this;
    }

    public CodeBlock fastore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(81));
        return this;
    }

    public CodeBlock daload() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(49));
        return this;
    }

    public CodeBlock dastore() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(82));
        return this;
    }

    public CodeBlock fcmpl() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(149));
        return this;
    }

    public CodeBlock fcmpg() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(150));
        return this;
    }

    public CodeBlock dcmpl() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(151));
        return this;
    }

    public CodeBlock dcmpg() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(152));
        return this;
    }

    public CodeBlock dup_x2() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(91));
        return this;
    }

    public CodeBlock dup_x1() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(90));
        return this;
    }

    public CodeBlock dup2_x2() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(94));
        return this;
    }

    public CodeBlock dup2_x1() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(93));
        return this;
    }

    public CodeBlock dup2() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(92));
        return this;
    }

    public CodeBlock trycatch(LabelNode scopeStart, LabelNode scopeEnd, LabelNode handler, String exceptionType) {
        this.tryCatchBlockList.add(new TryCatchBlockNode(scopeStart, scopeEnd, handler, exceptionType));
        return this;
    }

    public CodeBlock trycatch(String exceptionType, Runnable body, Runnable catchBody) {
        LabelNode before = new LabelNode();
        LabelNode after = new LabelNode();
        LabelNode catchStart = new LabelNode();
        LabelNode done = new LabelNode();
        this.trycatch(before, after, catchStart, exceptionType);
        this.label(before);
        body.run();
        this.label(after);
        this.go_to(done);
        if (catchBody != null) {
            this.label(catchStart);
            catchBody.run();
        }
        this.label(done);
        return this;
    }

    public CodeBlock go_to(LabelNode label) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(167, label));
        return this;
    }

    public CodeBlock lookupswitch(LabelNode defaultHandler, int[] keys, LabelNode[] handlers) {
        this.instructionList.add((AbstractInsnNode)new LookupSwitchInsnNode(defaultHandler, keys, handlers));
        return this;
    }

    public CodeBlock athrow() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(191));
        return this;
    }

    public CodeBlock instance_of(String typeDesc) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(193, typeDesc));
        return this;
    }

    public CodeBlock ifeq(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(153, jumpLabel));
        return this;
    }

    public CodeBlock iffalse(LabelNode jumpLabel) {
        this.ifeq(jumpLabel);
        return this;
    }

    public CodeBlock ifne(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(154, jumpLabel));
        return this;
    }

    public CodeBlock iftrue(LabelNode jumpLabel) {
        this.ifne(jumpLabel);
        return this;
    }

    public CodeBlock if_acmpne(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(166, jumpLabel));
        return this;
    }

    public CodeBlock if_acmpeq(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(165, jumpLabel));
        return this;
    }

    public CodeBlock if_icmple(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(164, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpgt(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(163, jumpLabel));
        return this;
    }

    public CodeBlock if_icmplt(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(161, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpne(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(160, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpeq(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(159, jumpLabel));
        return this;
    }

    public CodeBlock if_icmpge(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(162, jumpLabel));
        return this;
    }

    public CodeBlock checkcast(String typeDesc) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(192, typeDesc));
        return this;
    }

    public CodeBlock line(int line) {
        this.visitLineNumber(line, new LabelNode());
        return this;
    }

    public CodeBlock line(int line, LabelNode label) {
        this.visitLineNumber(line, label);
        return this;
    }

    public CodeBlock ifnonnull(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(199, jumpLabel));
        return this;
    }

    public CodeBlock ifnull(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(198, jumpLabel));
        return this;
    }

    public CodeBlock iflt(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(155, jumpLabel));
        return this;
    }

    public CodeBlock ifle(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(158, jumpLabel));
        return this;
    }

    public CodeBlock ifgt(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(157, jumpLabel));
        return this;
    }

    public CodeBlock ifge(LabelNode jumpLabel) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(156, jumpLabel));
        return this;
    }

    public CodeBlock arraylength() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(190));
        return this;
    }

    public CodeBlock ishr() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(122));
        return this;
    }

    public CodeBlock ishl() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(120));
        return this;
    }

    public CodeBlock iushr() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(124));
        return this;
    }

    public CodeBlock lshr() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(123));
        return this;
    }

    public CodeBlock lshl() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(121));
        return this;
    }

    public CodeBlock lushr() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(125));
        return this;
    }

    public CodeBlock lcmp() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(148));
        return this;
    }

    public CodeBlock iand() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(126));
        return this;
    }

    public CodeBlock ior() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(128));
        return this;
    }

    public CodeBlock ixor() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(130));
        return this;
    }

    public CodeBlock land() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(127));
        return this;
    }

    public CodeBlock lor() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(129));
        return this;
    }

    public CodeBlock lxor() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(131));
        return this;
    }

    public CodeBlock iadd() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(96));
        return this;
    }

    public CodeBlock ladd() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(97));
        return this;
    }

    public CodeBlock fadd() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(98));
        return this;
    }

    public CodeBlock dadd() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(99));
        return this;
    }

    public CodeBlock isub() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(100));
        return this;
    }

    public CodeBlock lsub() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(101));
        return this;
    }

    public CodeBlock fsub() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(102));
        return this;
    }

    public CodeBlock dsub() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(103));
        return this;
    }

    public CodeBlock idiv() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(108));
        return this;
    }

    public CodeBlock irem() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(112));
        return this;
    }

    public CodeBlock ineg() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(116));
        return this;
    }

    public CodeBlock i2d() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(135));
        return this;
    }

    public CodeBlock i2l() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(133));
        return this;
    }

    public CodeBlock i2f() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(134));
        return this;
    }

    public CodeBlock i2s() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(147));
        return this;
    }

    public CodeBlock i2c() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(146));
        return this;
    }

    public CodeBlock i2b() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(145));
        return this;
    }

    public CodeBlock ldiv() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(109));
        return this;
    }

    public CodeBlock lrem() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(113));
        return this;
    }

    public CodeBlock lneg() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(117));
        return this;
    }

    public CodeBlock l2d() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(138));
        return this;
    }

    public CodeBlock l2i() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(136));
        return this;
    }

    public CodeBlock l2f() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(137));
        return this;
    }

    public CodeBlock fdiv() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(110));
        return this;
    }

    public CodeBlock frem() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(114));
        return this;
    }

    public CodeBlock fneg() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(118));
        return this;
    }

    public CodeBlock f2d() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(141));
        return this;
    }

    public CodeBlock f2i() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(141));
        return this;
    }

    public CodeBlock f2l() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(140));
        return this;
    }

    public CodeBlock ddiv() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(111));
        return this;
    }

    public CodeBlock drem() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(115));
        return this;
    }

    public CodeBlock dneg() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(119));
        return this;
    }

    public CodeBlock d2f() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(144));
        return this;
    }

    public CodeBlock d2i() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(142));
        return this;
    }

    public CodeBlock d2l() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(143));
        return this;
    }

    public CodeBlock imul() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(104));
        return this;
    }

    public CodeBlock lmul() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(105));
        return this;
    }

    public CodeBlock fmul() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(106));
        return this;
    }

    public CodeBlock dmul() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(107));
        return this;
    }

    public CodeBlock iinc(int varIndex, int increment) {
        this.instructionList.add((AbstractInsnNode)new IincInsnNode(varIndex, increment));
        return this;
    }

    public CodeBlock monitorenter() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(194));
        return this;
    }

    public CodeBlock monitorexit() {
        this.instructionList.add((AbstractInsnNode)new InsnNode(195));
        return this;
    }

    public CodeBlock jsr(LabelNode branch) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(168, branch));
        return this;
    }

    public CodeBlock ret(int value) {
        this.instructionList.add((AbstractInsnNode)new IntInsnNode(169, value));
        return this;
    }

    public CodeBlock visitInsn(int opcode) {
        this.instructionList.add((AbstractInsnNode)new InsnNode(opcode));
        return this;
    }

    public CodeBlock visitIntInsn(int opcode, int operand) {
        this.instructionList.add((AbstractInsnNode)new IntInsnNode(opcode, operand));
        return this;
    }

    public CodeBlock visitInsnNode(int opcode, int operand) {
        this.instructionList.add((AbstractInsnNode)new IntInsnNode(opcode, operand));
        return this;
    }

    public CodeBlock visitTypeInsn(int opcode, String desc) {
        this.instructionList.add((AbstractInsnNode)new TypeInsnNode(opcode, desc));
        return this;
    }

    public CodeBlock visitFieldInsn(int opcode, String className, String fieldName, String fieldDesc) {
        this.instructionList.add((AbstractInsnNode)new FieldInsnNode(opcode, className, fieldName, fieldDesc));
        return this;
    }

    public CodeBlock visitMethodInsn(int opcode, String className, String methodName, String methodDesc) {
        boolean intf = opcode == 185;
        this.instructionList.add((AbstractInsnNode)new MethodInsnNode(opcode, className, methodName, methodDesc, intf));
        return this;
    }

    public CodeBlock visitInvokeDynamicInsn(String name, String desc, Handle bootstrapMethod, Object ... bootstrapArguments) {
        this.instructionList.add((AbstractInsnNode)new InvokeDynamicInsnNode(name, desc, bootstrapMethod, bootstrapArguments));
        return this;
    }

    public CodeBlock visitJumpInsn(int opcode, LabelNode node) {
        this.instructionList.add((AbstractInsnNode)new JumpInsnNode(opcode, node));
        return this;
    }

    public CodeBlock visitLabel(Label label) {
        this.instructionList.add((AbstractInsnNode)new LabelNode(label));
        return this;
    }

    public CodeBlock visitLdcInsn(Object value) {
        this.instructionList.add((AbstractInsnNode)new LdcInsnNode(value));
        return this;
    }

    public CodeBlock visitIincInsn(int varIndex, int increment) {
        this.instructionList.add((AbstractInsnNode)new IincInsnNode(varIndex, increment));
        return this;
    }

    public CodeBlock visitTableSwitchInsn(int min, int max, LabelNode defaultHandler, LabelNode[] handlers) {
        this.instructionList.add((AbstractInsnNode)new TableSwitchInsnNode(min, max, defaultHandler, handlers));
        return this;
    }

    public CodeBlock visitLookupSwitchInsn(LabelNode defaultHandler, int[] keys, LabelNode[] handlers) {
        this.instructionList.add((AbstractInsnNode)new LookupSwitchInsnNode(defaultHandler, keys, handlers));
        return this;
    }

    public CodeBlock visitMultiANewArrayInsn(String desc, int dims) {
        this.instructionList.add((AbstractInsnNode)new MultiANewArrayInsnNode(desc, dims));
        return this;
    }

    public CodeBlock visitTryCatchBlock(LabelNode scopeStart, LabelNode scopeEnd, LabelNode handler, String exceptionType) {
        this.tryCatchBlockList.add(new TryCatchBlockNode(scopeStart, scopeEnd, handler, exceptionType));
        return this;
    }

    public CodeBlock visitLocalVariable(String varName, String varDesc, String signature, LabelNode scopeStart, LabelNode scopeEnd, int varIndex) {
        this.localVariableList.add(new LocalVariableNode(varName, varDesc, signature, scopeStart, scopeEnd, varIndex));
        return this;
    }

    public CodeBlock visitLineNumber(int lineNumber, LabelNode start) {
        this.instructionList.add((AbstractInsnNode)new LineNumberNode(lineNumber, start));
        return this;
    }

    public CodeBlock tableswitch(int min, int max, LabelNode defaultLabel, LabelNode[] cases) {
        this.instructionList.add((AbstractInsnNode)new TableSwitchInsnNode(min, max, defaultLabel, cases));
        return this;
    }

    public CodeBlock visitFrame(int opcode, int nrLocals, Object[] localTypes, int nrStackElements, Object[] stackElements) {
        this.instructionList.add((AbstractInsnNode)new FrameNode(opcode, nrLocals, localTypes, nrStackElements, stackElements));
        return this;
    }

    public InsnList getInstructionList() {
        return this.instructionList;
    }

    public List<TryCatchBlockNode> getTryCatchBlockList() {
        return this.tryCatchBlockList;
    }

    public List<LocalVariableNode> getLocalVariableList() {
        return this.localVariableList;
    }

    public List<VisibleAnnotation> getAnnotations() {
        return this.annotations;
    }

    public CodeBlock frame_same(Object ... stackArguments) {
        int type;
        switch (stackArguments.length) {
            case 0: {
                type = 3;
                break;
            }
            case 1: {
                type = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("same frame should have 0 or 1 arguments on stack");
            }
        }
        this.instructionList.add((AbstractInsnNode)new FrameNode(type, 0, null, stackArguments.length, stackArguments));
        return this;
    }

    public CodeBlock prepend(CodeBlock codeBlock) {
        if (codeBlock.returns()) {
            this.returns = true;
        }
        this.annotations.addAll(codeBlock.annotations);
        this.instructionList.insert(codeBlock.instructionList);
        return this;
    }

    public CodeBlock append(CodeBlock codeBlock) {
        if (codeBlock.returns()) {
            this.returns = true;
        }
        this.instructionList.add(codeBlock.instructionList);
        this.tryCatchBlockList.addAll(codeBlock.tryCatchBlockList);
        this.annotations.addAll(codeBlock.annotations);
        return this;
    }

    public VisibleAnnotation annotation(Class<?> type) {
        VisibleAnnotation annotation = new VisibleAnnotation(CodegenUtils.ci(type));
        this.addAnnotation(annotation);
        return annotation;
    }

    public CodeBlock addAnnotation(VisibleAnnotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public CodeBlock addAll(InsnList insnList) {
        this.instructionList.add(insnList);
        return this;
    }

    public int arity() {
        return this.arity;
    }

    public boolean returns() {
        return this.returns;
    }
}

