/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.seata;

import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"consumer"})
public class SeataTransactionPropagationConsumerFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataTransactionPropagationConsumerFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String xid = RootContext.getXID();
        BranchType branchType = RootContext.getBranchType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Client side xid in RootContext[%s]", xid));
        }
        if (xid != null) {
            invocation.setAttachment("TX_XID", xid);
            if (branchType != null) {
                invocation.setAttachment("TX_BRANCH_TYPE", branchType.name());
            }
        }
        return invoker.invoke(invocation);
    }
}

