/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.seata;

import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class SeataTransactionPropagationProviderFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataTransactionPropagationProviderFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        block19: {
            String rpcBranchType;
            String rpcXid = invocation.getAttachment("TX_XID");
            if (rpcXid == null) {
                rpcXid = invocation.getAttachment("TX_XID".toLowerCase());
            }
            if ((rpcBranchType = invocation.getAttachment("TX_BRANCH_TYPE")) == null) {
                rpcBranchType = invocation.getAttachment("TX_BRANCH_TYPE".toLowerCase());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Server side xid in RpcContext[" + rpcXid + "]");
            }
            boolean bind = false;
            if (rpcXid != null) {
                RootContext.bind((String)rpcXid);
                if (StringUtils.equals((String)BranchType.TCC.name(), (String)rpcBranchType)) {
                    RootContext.bindBranchType((BranchType)BranchType.TCC);
                }
                bind = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("bind xid [%s] branchType [%s] to RootContext", rpcXid, rpcBranchType));
                }
            }
            try {
                result = invoker.invoke(invocation);
                if (!bind) break block19;
            }
            catch (Throwable throwable) {
                if (bind) {
                    BranchType previousBranchType = RootContext.getBranchType();
                    String unbindXid = RootContext.unbind();
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.unbindBranchType();
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("unbind xid [%s] branchType [%s] from RootContext", unbindXid, previousBranchType));
                    }
                    if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                        LOGGER.warn(String.format("xid in change during RPC from %s to %s,branchType from %s to %s", rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType));
                        if (unbindXid != null) {
                            RootContext.bind((String)unbindXid);
                            LOGGER.warn(String.format("bind xid [%s] back to RootContext", unbindXid));
                            if (BranchType.TCC == previousBranchType) {
                                RootContext.bindBranchType((BranchType)BranchType.TCC);
                                LOGGER.warn(String.format("bind branchType [%s] back to RootContext", previousBranchType));
                            }
                        }
                    }
                }
                throw throwable;
            }
            BranchType previousBranchType = RootContext.getBranchType();
            String unbindXid = RootContext.unbind();
            if (BranchType.TCC == previousBranchType) {
                RootContext.unbindBranchType();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("unbind xid [%s] branchType [%s] from RootContext", unbindXid, previousBranchType));
            }
            if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                LOGGER.warn(String.format("xid in change during RPC from %s to %s,branchType from %s to %s", rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : "AT", previousBranchType));
                if (unbindXid != null) {
                    RootContext.bind((String)unbindXid);
                    LOGGER.warn(String.format("bind xid [%s] back to RootContext", unbindXid));
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.bindBranchType((BranchType)BranchType.TCC);
                        LOGGER.warn(String.format("bind branchType [%s] back to RootContext", previousBranchType));
                    }
                }
            }
        }
        return result;
    }
}

