/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fory.Fory;
import org.apache.fory.builder.Generated;
import org.apache.fory.builder.ObjectCodecBuilder;
import org.apache.fory.builder.ObjectCodecOptimizer;
import org.apache.fory.codegen.CodeGenerator;
import org.apache.fory.codegen.Expression;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.serializer.CodegenSerializer;
import org.apache.fory.serializer.MetaSharedSerializer;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.DefaultValueUtils;
import org.apache.fory.util.ExceptionUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.StringUtils;
import org.apache.fory.util.record.RecordComponent;
import org.apache.fory.util.record.RecordUtils;

public class MetaSharedCodecBuilder
extends ObjectCodecBuilder {
    private final ClassDef classDef;
    private final String defaultValueLanguage;
    private final DefaultValueUtils.DefaultValueField[] defaultValueFields;
    private static final Map<Long, Integer> idGenerator = new ConcurrentHashMap<Long, Integer>();

    public MetaSharedCodecBuilder(TypeRef<?> beanType, Fory fory, ClassDef classDef) {
        super(beanType, fory, Generated.GeneratedMetaSharedSerializer.class);
        DefaultValueUtils.DefaultValueSupport kotlinDefaultValueSupport;
        Preconditions.checkArgument(!fory.getConfig().checkClassVersion(), "Class version check should be disabled when compatible mode is enabled.");
        this.classDef = classDef;
        Collection descriptors = this.fory(f -> MetaSharedSerializer.consolidateFields(f.isCrossLanguage() ? f.getXtypeResolver() : f.getClassResolver(), this.beanClass, classDef));
        DescriptorGrouper grouper = fory.getClassResolver().createDescriptorGrouper(descriptors, false);
        this.objectCodecOptimizer = new ObjectCodecOptimizer(this.beanClass, grouper, !fory.isBasicTypesRefIgnored(), this.ctx);
        String defaultValueLanguage = "None";
        DefaultValueUtils.DefaultValueField[] defaultValueFields = new DefaultValueUtils.DefaultValueField[]{};
        if (fory.getConfig().isScalaOptimizationEnabled() && (defaultValueFields = DefaultValueUtils.getScalaDefaultValueSupport().buildDefaultValueFields(fory, this.beanClass, grouper.getSortedDescriptors())).length > 0) {
            defaultValueLanguage = "Scala";
        }
        if (defaultValueFields.length == 0 && (kotlinDefaultValueSupport = DefaultValueUtils.getKotlinDefaultValueSupport()) != null && (defaultValueFields = kotlinDefaultValueSupport.buildDefaultValueFields(fory, this.beanClass, grouper.getSortedDescriptors())).length > 0) {
            defaultValueLanguage = "Kotlin";
        }
        this.defaultValueLanguage = defaultValueLanguage;
        this.defaultValueFields = defaultValueFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String codecSuffix() {
        Integer id = idGenerator.get(this.classDef.getId());
        if (id == null) {
            Map<Long, Integer> map = idGenerator;
            synchronized (map) {
                id = idGenerator.computeIfAbsent(this.classDef.getId(), k -> idGenerator.size());
            }
        }
        return "MetaShared" + id;
    }

    @Override
    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage(this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.extendsClasses(this.ctx.type(this.parentSerializerClass));
        this.ctx.reserveName("classType");
        this.ctx.reserveName("serializer");
        this.ctx.addField(this.ctx.type(Fory.class), "fory");
        String constructorCode = StringUtils.format("super(${fory}, ${cls});\nthis.${fory} = ${fory};\n${serializer} = ${builderClass}.setCodegenSerializer(${fory}, ${cls}, this);\n", "fory", "fory", "cls", "classType", "builderClass", MetaSharedCodecBuilder.class.getName(), "serializer", "serializer");
        this.ctx.clearExprState();
        Expression decodeExpr = this.buildDecodeExpression();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        decodeCode = this.ctx.optimizeMethodCode(decodeCode);
        this.ctx.overrideMethod("read", decodeCode, Object.class, MemoryBuffer.class, "buffer");
        this.registerJITNotifyCallback();
        this.ctx.addConstructor(constructorCode, Fory.class, "fory", Class.class, "classType");
        return this.ctx.genCode();
    }

    @Override
    protected void addCommonImports() {
        super.addCommonImports();
        this.ctx.addImport(Generated.GeneratedMetaSharedSerializer.class);
    }

    public static Serializer setCodegenSerializer(Fory fory, Class<?> cls, Generated.GeneratedMetaSharedSerializer s) {
        if (GraalvmSupport.isGraalRuntime()) {
            return fory.getJITContext().asyncVisitFory(f -> f.getClassResolver().getSerializer(s.getType()));
        }
        Class serializerClass = fory.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(fory, s.getType()), c -> {
            s.serializer = Serializers.newSerializer(fory, s.getType(), c);
        });
        return Serializers.newSerializer(fory, cls, serializerClass);
    }

    @Override
    public Expression buildEncodeExpression() {
        throw new IllegalStateException("unreachable");
    }

    @Override
    protected Expression buildComponentsArray() {
        return this.buildDefaultComponentsArray();
    }

    @Override
    protected Expression createRecord(SortedMap<Integer, Expression> recordComponents) {
        RecordComponent[] components = RecordUtils.getRecordComponents(this.beanClass);
        Object[] defaultValues = RecordUtils.buildRecordComponentDefaultValues(this.beanClass);
        for (int i = 0; i < defaultValues.length; ++i) {
            if (recordComponents.containsKey(i)) continue;
            Object defaultValue = defaultValues[i];
            assert (components != null);
            RecordComponent component = components[i];
            recordComponents.put(i, new Expression.Literal(defaultValue, TypeRef.of(component.getType())));
        }
        Expression[] params = recordComponents.values().toArray(new Expression[0]);
        return new Expression.NewInstance(this.beanType, params);
    }

    @Override
    protected Expression setFieldValue(Expression bean, Descriptor descriptor, Expression value) {
        if (descriptor.getField() == null) {
            return new Expression.StaticInvoke(ExceptionUtils.class, "ignore", value);
        }
        return super.setFieldValue(bean, descriptor, value);
    }

    @Override
    protected Expression newBean() {
        Expression bean = super.newBean();
        if (this.defaultValueFields.length == 0) {
            return bean;
        }
        Expression.ListExpression setDefaultsExpr = new Expression.ListExpression(new Expression[0]);
        setDefaultsExpr.add(bean);
        SortedMap<Member, Descriptor> descriptors = Descriptor.getAllDescriptorsMap(this.beanClass);
        for (DefaultValueUtils.DefaultValueField defaultField : this.defaultValueFields) {
            Expression.AbstractExpression defaultValueExpr;
            Object defaultValue = defaultField.getDefaultValue();
            Field member = defaultField.getFieldAccessor().getField();
            Descriptor descriptor = (Descriptor)descriptors.get(member);
            TypeRef<?> typeRef = descriptor.getTypeRef();
            if (typeRef.unwrap().isPrimitive() || typeRef.equals(TypeUtils.STRING_TYPE)) {
                defaultValueExpr = new Expression.Literal(defaultValue, typeRef);
            } else {
                String funcName = "get" + this.defaultValueLanguage + "DefaultValue";
                defaultValueExpr = this.getOrCreateField(true, typeRef.getRawType(), member.getName(), () -> {
                    Expression.StaticInvoke expr = new Expression.StaticInvoke(DefaultValueUtils.class, funcName, TypeUtils.OBJECT_TYPE, this.staticBeanClassExpr(), Expression.Literal.ofString(member.getName()));
                    return new Expression.Cast(expr, typeRef);
                });
            }
            setDefaultsExpr.add(super.setFieldValue(bean, descriptor, defaultValueExpr));
        }
        setDefaultsExpr.add(bean);
        return setDefaultsExpr;
    }
}

