/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.meta;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.ClassDefDecoder;
import org.apache.fory.meta.ClassDefEncoder;
import org.apache.fory.meta.ClassSpec;
import org.apache.fory.meta.TypeDefDecoder;
import org.apache.fory.meta.TypeDefEncoder;
import org.apache.fory.meta.TypeExtMeta;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.resolver.XtypeResolver;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.FinalObjectTypeStub;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.type.Types;
import org.apache.fory.util.Preconditions;

public class ClassDef
implements Serializable {
    static final int COMPRESS_META_FLAG = 8192;
    static final int HAS_FIELDS_META_FLAG = 4096;
    static final int META_SIZE_MASKS = 4095;
    static final int NUM_HASH_BITS = 50;
    private static final Logger LOG = LoggerFactory.getLogger(ClassDef.class);
    public static final Comparator<Field> FIELD_COMPARATOR = (f1, f2) -> {
        int compare;
        long offset2;
        long offset1 = Platform.objectFieldOffset(f1);
        long diff = offset1 - (offset2 = Platform.objectFieldOffset(f2));
        if (diff != 0L) {
            return (int)diff;
        }
        if (!f1.equals(f2)) {
            LOG.warn("Field {} has same offset with {}, please an issue with jdk info to fory", f1, f2);
        }
        if ((compare = f1.getDeclaringClass().getName().compareTo(f2.getName())) != 0) {
            return compare;
        }
        return f1.getName().compareTo(f2.getName());
    };
    private final ClassSpec classSpec;
    private final List<FieldInfo> fieldsInfo;
    private final boolean hasFieldsMeta;
    private final long id;
    private final byte[] encoded;
    private transient List<Descriptor> descriptors;

    ClassDef(ClassSpec classSpec, List<FieldInfo> fieldsInfo, boolean hasFieldsMeta, long id, byte[] encoded) {
        this.classSpec = classSpec;
        this.fieldsInfo = fieldsInfo;
        this.hasFieldsMeta = hasFieldsMeta;
        this.id = id;
        this.encoded = encoded;
    }

    public static void skipClassDef(MemoryBuffer buffer, long id) {
        int size = (int)(id & 0xFFFL);
        if (size == 4095) {
            size += buffer.readVarUint32Small14();
        }
        buffer.increaseReaderIndex(size);
    }

    public String getClassName() {
        return this.classSpec.entireClassName;
    }

    public ClassSpec getClassSpec() {
        return this.classSpec;
    }

    public List<FieldInfo> getFieldsInfo() {
        return this.fieldsInfo;
    }

    public boolean hasFieldsMeta() {
        return this.hasFieldsMeta;
    }

    public long getId() {
        return this.id;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDef classDef = (ClassDef)o;
        return this.hasFieldsMeta == classDef.hasFieldsMeta && this.id == classDef.id && Objects.equals(this.classSpec, classDef.classSpec) && Objects.equals(this.fieldsInfo, classDef.fieldsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.classSpec.entireClassName, this.fieldsInfo, this.id);
    }

    public String toString() {
        return "ClassDef{className='" + this.classSpec.entireClassName + '\'' + ", fieldsInfo=" + this.fieldsInfo + ", hasFieldsMeta=" + this.hasFieldsMeta + ", id=" + this.id + '}';
    }

    public void writeClassDef(MemoryBuffer buffer) {
        buffer.writeBytes(this.encoded, 0, this.encoded.length);
    }

    public static ClassDef readClassDef(Fory fory, MemoryBuffer buffer) {
        if (fory.isCrossLanguage()) {
            return TypeDefDecoder.decodeClassDef(fory.getXtypeResolver(), buffer, buffer.readInt64());
        }
        return ClassDefDecoder.decodeClassDef(fory.getClassResolver(), buffer, buffer.readInt64());
    }

    public static ClassDef readClassDef(Fory fory, MemoryBuffer buffer, long header) {
        if (fory.isCrossLanguage()) {
            return TypeDefDecoder.decodeClassDef(fory.getXtypeResolver(), buffer, header);
        }
        return ClassDefDecoder.decodeClassDef(fory.getClassResolver(), buffer, header);
    }

    public List<Descriptor> getDescriptors(TypeResolver resolver, Class<?> cls) {
        if (this.descriptors == null) {
            SortedMap<Member, Descriptor> allDescriptorsMap = resolver.getFory().getClassResolver().getAllDescriptorsMap(cls, true);
            HashMap<String, Descriptor> descriptorsMap = new HashMap<String, Descriptor>();
            for (Map.Entry<Member, Descriptor> e : allDescriptorsMap.entrySet()) {
                if (descriptorsMap.put(e.getKey().getDeclaringClass().getName() + "." + e.getKey().getName(), e.getValue()) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            this.descriptors = new ArrayList<Descriptor>(this.fieldsInfo.size());
            for (FieldInfo fieldInfo : this.fieldsInfo) {
                String typeAlias;
                Descriptor descriptor = (Descriptor)descriptorsMap.get(fieldInfo.getDefinedClass() + "." + fieldInfo.getFieldName());
                Descriptor newDesc = fieldInfo.toDescriptor(resolver, descriptor);
                Class<?> rawType = newDesc.getRawType();
                FieldType fieldType = fieldInfo.getFieldType();
                if (fieldType instanceof RegisteredFieldType && !(typeAlias = String.valueOf(((RegisteredFieldType)fieldType).getClassId())).equals(newDesc.getTypeName())) {
                    newDesc = newDesc.copyWithTypeName(typeAlias);
                }
                if (descriptor != null) {
                    if (rawType.isEnum() || rawType.isAssignableFrom(descriptor.getRawType()) || NonexistentClass.isNonexistent(rawType) || rawType == FinalObjectTypeStub.class || rawType.isArray() && TypeUtils.getArrayComponent(rawType) == FinalObjectTypeStub.class) {
                        descriptor = descriptor.copyWithTypeName(newDesc.getTypeName());
                        this.descriptors.add(descriptor);
                        continue;
                    }
                    this.descriptors.add(newDesc);
                    continue;
                }
                this.descriptors.add(newDesc);
            }
        }
        return this.descriptors;
    }

    static FieldType buildFieldType(TypeResolver resolver, Field field) {
        Preconditions.checkNotNull(field);
        GenericType genericType = resolver.buildGenericType(field.getGenericType());
        return ClassDef.buildFieldType(resolver, genericType);
    }

    private static FieldType buildFieldType(TypeResolver resolver, GenericType genericType) {
        boolean nullable;
        Preconditions.checkNotNull(genericType);
        Class<?> rawType = genericType.getCls();
        boolean isXlang = resolver.getFory().isCrossLanguage();
        int xtypeId = -1;
        if (isXlang) {
            ClassInfo info = resolver.getClassInfo(genericType.getCls(), false);
            xtypeId = info != null ? info.getXtypeId() : 63;
        }
        boolean isMonomorphic = genericType.isMonomorphic();
        boolean trackingRef = genericType.trackingRef(resolver);
        boolean bl = nullable = !genericType.getCls().isPrimitive();
        if (TypeUtils.COLLECTION_TYPE.isSupertypeOf(genericType.getTypeRef())) {
            return new CollectionFieldType(xtypeId, isMonomorphic, nullable, trackingRef, ClassDef.buildFieldType(resolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()));
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(genericType.getTypeRef())) {
            return new MapFieldType(xtypeId, isMonomorphic, nullable, trackingRef, ClassDef.buildFieldType(resolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()), ClassDef.buildFieldType(resolver, genericType.getTypeParameter1() == null ? GenericType.build(Object.class) : genericType.getTypeParameter1()));
        }
        if (isXlang && !Types.isUserDefinedType((byte)xtypeId) && resolver.isRegisteredById(rawType)) {
            return new RegisteredFieldType(isMonomorphic, nullable, trackingRef, xtypeId);
        }
        if (!isXlang && resolver.isRegisteredById(rawType)) {
            Short classId = ((ClassResolver)resolver).getRegisteredClassId(rawType);
            return new RegisteredFieldType(isMonomorphic, nullable, trackingRef, classId.shortValue());
        }
        if (rawType.isEnum()) {
            return new EnumFieldType(nullable, xtypeId);
        }
        if (rawType.isArray()) {
            Class<?> elemType = rawType.getComponentType();
            while (elemType.isArray()) {
                elemType = elemType.getComponentType();
            }
            if (isXlang && !elemType.isPrimitive()) {
                return new CollectionFieldType(xtypeId, isMonomorphic, nullable, trackingRef, ClassDef.buildFieldType(resolver, GenericType.build(elemType)));
            }
            Tuple2<Class<?>, Integer> info = TypeUtils.getArrayComponentInfo(rawType);
            return new ArrayFieldType(xtypeId, isMonomorphic, nullable, trackingRef, ClassDef.buildFieldType(resolver, GenericType.build((Type)info.f0)), (Integer)info.f1);
        }
        return new ObjectFieldType(xtypeId, isMonomorphic, nullable, trackingRef);
    }

    public static ClassDef buildClassDef(Fory fory, Class<?> cls) {
        return ClassDef.buildClassDef(fory, cls, true);
    }

    public static ClassDef buildClassDef(Fory fory, Class<?> cls, boolean resolveParent) {
        if (fory.isCrossLanguage()) {
            return TypeDefEncoder.buildTypeDef(fory, cls);
        }
        return ClassDefEncoder.buildClassDef(fory.getClassResolver(), cls, ClassDefEncoder.buildFields(fory, cls, resolveParent), true);
    }

    static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields) {
        return ClassDef.buildClassDef(classResolver, type, fields, true);
    }

    public static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields, boolean hasFieldsMeta) {
        return ClassDefEncoder.buildClassDef(classResolver, type, fields, hasFieldsMeta);
    }

    public ClassDef replaceRootClassTo(ClassResolver classResolver, Class<?> targetCls) {
        String name = targetCls.getName();
        List<FieldInfo> fieldInfos = this.fieldsInfo.stream().map(fieldInfo -> {
            if (((FieldInfo)fieldInfo).definedClass.equals(this.classSpec.entireClassName)) {
                return new FieldInfo(name, ((FieldInfo)fieldInfo).fieldName, ((FieldInfo)fieldInfo).fieldType);
            }
            return fieldInfo;
        }).collect(Collectors.toList());
        return ClassDefEncoder.buildClassDefWithFieldInfos(classResolver, targetCls, fieldInfos, this.hasFieldsMeta);
    }

    public static class FieldInfo
    implements Serializable {
        private final String definedClass;
        private final String fieldName;
        private final FieldType fieldType;

        FieldInfo(String definedClass, String fieldName, FieldType fieldType) {
            this.definedClass = definedClass;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public String getDefinedClass() {
            return this.definedClass;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean hasTag() {
            return false;
        }

        public short getTag() {
            return -1;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        Descriptor toDescriptor(TypeResolver resolver, Descriptor descriptor) {
            TypeRef<?> declared = descriptor != null ? descriptor.getTypeRef() : null;
            TypeRef<?> typeRef = this.fieldType.toTypeToken(resolver, declared);
            if (descriptor != null) {
                if (typeRef.equals(declared)) {
                    return descriptor;
                }
                descriptor.copyWithTypeName(typeRef.getType().getTypeName());
            }
            int stubModifiers = ReflectionUtils.getField(this.getClass(), "fieldName").getModifiers();
            return new Descriptor(typeRef, this.fieldName, stubModifiers, this.definedClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)o;
            return Objects.equals(this.definedClass, fieldInfo.definedClass) && Objects.equals(this.fieldName, fieldInfo.fieldName) && Objects.equals(this.fieldType, fieldInfo.fieldType);
        }

        public int hashCode() {
            return Objects.hash(this.definedClass, this.fieldName, this.fieldType);
        }

        public String toString() {
            return "FieldInfo{definedClass='" + this.definedClass + '\'' + ", fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
        }
    }

    public static abstract class FieldType
    implements Serializable {
        protected final int xtypeId;
        protected final boolean isMonomorphic;
        protected final boolean nullable;
        protected final boolean trackingRef;

        public FieldType(int xtypeId, boolean isMonomorphic, boolean nullable, boolean trackingRef) {
            this.isMonomorphic = isMonomorphic;
            this.trackingRef = trackingRef;
            this.nullable = nullable;
            this.xtypeId = xtypeId;
        }

        public boolean isMonomorphic() {
            return this.isMonomorphic;
        }

        public boolean trackingRef() {
            return this.trackingRef;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public abstract TypeRef<?> toTypeToken(TypeResolver var1, TypeRef<?> var2);

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldType fieldType = (FieldType)o;
            return this.isMonomorphic == fieldType.isMonomorphic && this.trackingRef == fieldType.trackingRef;
        }

        public int hashCode() {
            return Objects.hash(this.isMonomorphic, this.trackingRef);
        }

        public void write(MemoryBuffer buffer, boolean writeHeader) {
            byte header = (byte)((this.isMonomorphic ? 1 : 0) << 1);
            header = (byte)(header | (byte)(this.trackingRef ? 1 : 0));
            if (this instanceof RegisteredFieldType) {
                short classId = ((RegisteredFieldType)this).getClassId();
                buffer.writeVarUint32Small7(writeHeader ? 5 + classId << 2 | header : 5 + classId);
            } else if (this instanceof EnumFieldType) {
                buffer.writeVarUint32Small7(writeHeader ? 0x10 | header : 4);
            } else if (this instanceof ArrayFieldType) {
                ArrayFieldType arrayFieldType = (ArrayFieldType)this;
                buffer.writeVarUint32Small7(writeHeader ? 0xC | header : 3);
                buffer.writeVarUint32Small7(arrayFieldType.getDimensions());
                arrayFieldType.getComponentType().write(buffer);
            } else if (this instanceof CollectionFieldType) {
                buffer.writeVarUint32Small7(writeHeader ? 8 | header : 2);
                ((CollectionFieldType)this).getElementType().write(buffer);
            } else if (this instanceof MapFieldType) {
                buffer.writeVarUint32Small7(writeHeader ? 4 | header : 1);
                MapFieldType mapFieldType = (MapFieldType)this;
                mapFieldType.getKeyType().write(buffer);
                mapFieldType.getValueType().write(buffer);
            } else {
                Preconditions.checkArgument(this instanceof ObjectFieldType);
                buffer.writeVarUint32Small7(writeHeader ? header : (byte)0);
            }
        }

        public void write(MemoryBuffer buffer) {
            this.write(buffer, true);
        }

        public static FieldType read(MemoryBuffer buffer, TypeResolver resolver) {
            int header = buffer.readVarUint32Small7();
            boolean isMonomorphic = (header & 2) != 0;
            boolean trackingRef = (header & 1) != 0;
            return FieldType.read(buffer, resolver, isMonomorphic, trackingRef, header >>> 2);
        }

        public static FieldType read(MemoryBuffer buffer, TypeResolver resolver, boolean isFinal, boolean trackingRef, int typeId) {
            if (typeId == 0) {
                return new ObjectFieldType(-1, isFinal, true, trackingRef);
            }
            if (typeId == 1) {
                return new MapFieldType(-1, isFinal, true, trackingRef, FieldType.read(buffer, resolver), FieldType.read(buffer, resolver));
            }
            if (typeId == 2) {
                return new CollectionFieldType(-1, isFinal, true, trackingRef, FieldType.read(buffer, resolver));
            }
            if (typeId == 3) {
                int dims = buffer.readVarUint32Small7();
                return new ArrayFieldType(isFinal, trackingRef, FieldType.read(buffer, resolver), dims);
            }
            if (typeId == 4) {
                return new EnumFieldType(true, -1);
            }
            boolean nullable = ((ClassResolver)resolver).isPrimitive((short)typeId);
            return new RegisteredFieldType(isFinal, nullable, trackingRef, typeId - 5);
        }

        public final void xwrite(MemoryBuffer buffer, boolean writeFlags) {
            int xtypeId = this.xtypeId;
            if (writeFlags) {
                xtypeId <<= 2;
                if (this.nullable) {
                    xtypeId |= 2;
                }
                if (this.trackingRef) {
                    xtypeId |= 1;
                }
            }
            buffer.writeVarUint32Small7(xtypeId);
            switch (xtypeId) {
                case 21: {
                    ((CollectionFieldType)this).getElementType().xwrite(buffer, true);
                    break;
                }
                case 23: {
                    MapFieldType mapFieldType = (MapFieldType)this;
                    mapFieldType.getKeyType().xwrite(buffer, true);
                    mapFieldType.getValueType().xwrite(buffer, true);
                    break;
                }
            }
        }

        public static FieldType xread(MemoryBuffer buffer, XtypeResolver resolver) {
            int xtypeId = buffer.readVarUint32Small7();
            boolean trackingRef = (xtypeId & 1) != 0;
            boolean nullable = (xtypeId & 2) != 0;
            return FieldType.xread(buffer, resolver, xtypeId >>>= 2, nullable, trackingRef);
        }

        public static FieldType xread(MemoryBuffer buffer, XtypeResolver resolver, int xtypeId, boolean nullable, boolean trackingRef) {
            switch (xtypeId) {
                case 21: 
                case 22: {
                    return new CollectionFieldType(xtypeId, true, nullable, trackingRef, FieldType.xread(buffer, resolver));
                }
                case 23: {
                    return new MapFieldType(xtypeId, true, nullable, trackingRef, FieldType.xread(buffer, resolver), FieldType.xread(buffer, resolver));
                }
                case 13: 
                case 14: {
                    return new EnumFieldType(nullable, xtypeId);
                }
                case 63: {
                    return new ObjectFieldType(xtypeId, false, nullable, trackingRef);
                }
            }
            if (!Types.isUserDefinedType((byte)xtypeId)) {
                ClassInfo classInfo = resolver.getXtypeInfo(xtypeId);
                Preconditions.checkNotNull(classInfo);
                Class<?> cls = classInfo.getCls();
                return new RegisteredFieldType(resolver.isMonomorphic(cls), nullable, trackingRef, xtypeId);
            }
            return new ObjectFieldType(xtypeId, false, nullable, trackingRef);
        }
    }

    public static class RegisteredFieldType
    extends FieldType {
        private final short classId;

        public RegisteredFieldType(boolean isFinal, boolean nullable, boolean trackingRef, int classId) {
            super(classId, isFinal, nullable, trackingRef);
            this.classId = (short)classId;
        }

        public short getClassId() {
            return this.classId;
        }

        @Override
        public TypeRef<?> toTypeToken(TypeResolver resolver, TypeRef<?> declared) {
            Class<Object> cls;
            if (resolver instanceof XtypeResolver) {
                cls = ((XtypeResolver)resolver).getXtypeInfo(this.classId).getCls();
                if (Types.isPrimitiveType(this.classId)) {
                    if (declared.isPrimitive() && !this.nullable) {
                        cls = TypeUtils.unwrap(cls);
                    }
                    if (this.nullable && !declared.isPrimitive()) {
                        cls = TypeUtils.wrap(cls);
                    }
                }
            } else {
                cls = ((ClassResolver)resolver).getRegisteredClass(this.classId);
            }
            if (cls == null) {
                LOG.warn("Class {} not registered, take it as Struct type for deserialization.", (Object)this.classId);
                cls = NonexistentClass.NonexistentMetaShared.class;
            }
            return TypeRef.of(cls, new TypeExtMeta(this.nullable, this.trackingRef));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegisteredFieldType that = (RegisteredFieldType)o;
            return this.classId == that.classId;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.classId);
        }

        public String toString() {
            return "RegisteredFieldType{isMonomorphic=" + this.isMonomorphic() + ", trackingRef=" + this.trackingRef() + ", classId=" + this.classId + '}';
        }
    }

    public static class CollectionFieldType
    extends FieldType {
        private final FieldType elementType;

        public CollectionFieldType(int xtypeId, boolean isFinal, boolean nullable, boolean trackingRef, FieldType elementType) {
            super(xtypeId, isFinal, nullable, trackingRef);
            this.elementType = elementType;
        }

        public FieldType getElementType() {
            return this.elementType;
        }

        @Override
        public TypeRef<?> toTypeToken(TypeResolver classResolver, TypeRef<?> declared) {
            int i;
            TypeRef<Collection<?>> collectionTypeRef = TypeUtils.collectionOf(this.elementType.toTypeToken(classResolver, declared), new TypeExtMeta(this.nullable, this.trackingRef));
            if (declared == null) {
                return collectionTypeRef;
            }
            Class<?> declaredClass = declared.getRawType();
            if (!declaredClass.isArray()) {
                return collectionTypeRef;
            }
            Tuple2<Class<?>, Integer> info = TypeUtils.getArrayComponentInfo(declaredClass);
            ArrayList typeRefs = new ArrayList((Integer)info.f1 + 1);
            typeRefs.add(collectionTypeRef);
            for (i = 0; i < (Integer)info.f1; ++i) {
                typeRefs.add(TypeUtils.getElementType((TypeRef)typeRefs.get(i)));
            }
            Collections.reverse(typeRefs);
            for (i = 1; i < typeRefs.size(); ++i) {
                TypeRef arrayType = (TypeRef)typeRefs.get(i - 1);
                TypeRef<?> typeRef = TypeRef.of(Array.newInstance(arrayType.getRawType(), 1).getClass(), ((TypeRef)typeRefs.get(i)).getExtInfo());
                typeRefs.set(i, typeRef);
            }
            return (TypeRef)typeRefs.get(typeRefs.size() - 1);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollectionFieldType that = (CollectionFieldType)o;
            return Objects.equals(this.elementType, that.elementType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.elementType);
        }

        public String toString() {
            return "CollectionFieldType{elementType=" + this.elementType + ", isFinal=" + this.isMonomorphic() + ", trackingRef=" + this.trackingRef() + '}';
        }
    }

    public static class MapFieldType
    extends FieldType {
        private final FieldType keyType;
        private final FieldType valueType;

        public MapFieldType(int xtypeId, boolean isFinal, boolean nullable, boolean trackingRef, FieldType keyType, FieldType valueType) {
            super(xtypeId, isFinal, nullable, trackingRef);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public FieldType getKeyType() {
            return this.keyType;
        }

        public FieldType getValueType() {
            return this.valueType;
        }

        @Override
        public TypeRef<?> toTypeToken(TypeResolver classResolver, TypeRef<?> declared) {
            return TypeUtils.mapOf(this.keyType.toTypeToken(classResolver, declared), this.valueType.toTypeToken(classResolver, declared), new TypeExtMeta(this.nullable, this.trackingRef));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MapFieldType that = (MapFieldType)o;
            return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.keyType, this.valueType);
        }

        public String toString() {
            return "MapFieldType{keyType=" + this.keyType + ", valueType=" + this.valueType + ", isFinal=" + this.isMonomorphic() + ", trackingRef=" + this.trackingRef() + '}';
        }
    }

    public static class EnumFieldType
    extends FieldType {
        private EnumFieldType(boolean nullable, int xtypeId) {
            super(xtypeId, true, nullable, false);
        }

        @Override
        public TypeRef<?> toTypeToken(TypeResolver classResolver, TypeRef<?> declared) {
            return TypeRef.of(NonexistentClass.NonexistentEnum.class);
        }
    }

    public static class ArrayFieldType
    extends FieldType {
        private final FieldType componentType;
        private final int dimensions;

        public ArrayFieldType(boolean isMonomorphic, boolean trackingRef, FieldType componentType, int dimensions) {
            this(-1, isMonomorphic, true, trackingRef, componentType, dimensions);
        }

        public ArrayFieldType(int xtypeId, boolean isMonomorphic, boolean nullable, boolean trackingRef, FieldType componentType, int dimensions) {
            super(xtypeId, isMonomorphic, nullable, trackingRef);
            this.componentType = componentType;
            this.dimensions = dimensions;
        }

        @Override
        public TypeRef<?> toTypeToken(TypeResolver classResolver, TypeRef<?> declared) {
            while (declared != null && declared.isArray()) {
                declared = declared.getComponentType();
            }
            TypeRef<?> componentTypeRef = this.componentType.toTypeToken(classResolver, declared);
            Class<?> componentRawType = componentTypeRef.getRawType();
            if (NonexistentClass.class.isAssignableFrom(componentRawType)) {
                return TypeRef.of(NonexistentClass.getNonexistentClass(this.componentType instanceof EnumFieldType, this.dimensions, true), new TypeExtMeta(this.nullable, this.trackingRef));
            }
            return TypeRef.of(Array.newInstance(componentRawType, new int[this.dimensions]).getClass(), new TypeExtMeta(this.nullable, this.trackingRef));
        }

        public int getDimensions() {
            return this.dimensions;
        }

        public FieldType getComponentType() {
            return this.componentType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ArrayFieldType that = (ArrayFieldType)o;
            return this.dimensions == that.dimensions && Objects.equals(this.componentType, that.componentType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.componentType, this.dimensions);
        }

        public String toString() {
            return "ArrayFieldType{componentType=" + this.componentType + ", dimensions=" + this.dimensions + ", isMonomorphic=" + this.isMonomorphic + ", trackingRef=" + this.trackingRef + '}';
        }
    }

    public static class ObjectFieldType
    extends FieldType {
        public ObjectFieldType(int xtypeId, boolean isFinal, boolean nullable, boolean trackingRef) {
            super(xtypeId, isFinal, nullable, trackingRef);
        }

        @Override
        public TypeRef<?> toTypeToken(TypeResolver classResolver, TypeRef<?> declared) {
            return this.isMonomorphic() ? TypeRef.of(FinalObjectTypeStub.class, new TypeExtMeta(this.nullable, this.trackingRef)) : TypeRef.of(Object.class, new TypeExtMeta(this.nullable, this.trackingRef));
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

