/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.config;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.fory.Fory;
import org.apache.fory.ThreadLocalFory;
import org.apache.fory.ThreadSafeFory;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.config.Language;
import org.apache.fory.config.LongEncoding;
import org.apache.fory.config.UnknownEnumValueStrategy;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.DeflaterMetaCompressor;
import org.apache.fory.meta.MetaCompressor;
import org.apache.fory.pool.ThreadPoolFory;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.serializer.JavaSerializer;
import org.apache.fory.serializer.ObjectStreamSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;

public final class ForyBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ForyBuilder.class);
    private static final boolean ENABLE_CLASS_REGISTRATION_FORCIBLY;
    String name;
    boolean checkClassVersion = false;
    Language language = Language.JAVA;
    boolean trackingRef = false;
    boolean copyRef = false;
    boolean basicTypesRefIgnored = true;
    boolean stringRefIgnored = true;
    boolean timeRefIgnored = true;
    ClassLoader classLoader;
    boolean compressInt = true;
    public LongEncoding longEncoding = LongEncoding.SLI;
    boolean compressIntArray = false;
    boolean compressLongArray = false;
    boolean compressString = false;
    Boolean writeNumUtf16BytesForUtf8Encoding;
    CompatibleMode compatibleMode = CompatibleMode.SCHEMA_CONSISTENT;
    boolean checkJdkClassSerializable = true;
    Class<? extends Serializer> defaultJDKStreamSerializerType = ObjectStreamSerializer.class;
    boolean requireClassRegistration = true;
    Boolean metaShareEnabled;
    Boolean scopedMetaShareEnabled;
    boolean codeGenEnabled = true;
    Boolean deserializeNonexistentClass;
    boolean asyncCompilationEnabled = false;
    boolean registerGuavaTypes = true;
    boolean scalaOptimizationEnabled = false;
    boolean suppressClassRegistrationWarnings = true;
    UnknownEnumValueStrategy unknownEnumValueStrategy = UnknownEnumValueStrategy.NOT_ALLOWED;
    boolean serializeEnumByName = false;
    int bufferSizeLimitBytes = 131072;
    MetaCompressor metaCompressor = new DeflaterMetaCompressor();
    int maxDepth = 50;

    public ForyBuilder withLanguage(Language language) {
        this.language = language;
        return this;
    }

    public ForyBuilder withRefTracking(boolean trackingRef) {
        this.trackingRef = trackingRef;
        return this;
    }

    public ForyBuilder withRefCopy(boolean copyRef) {
        this.copyRef = copyRef;
        return this;
    }

    public ForyBuilder ignoreBasicTypesRef(boolean ignoreBasicTypesRef) {
        this.basicTypesRefIgnored = ignoreBasicTypesRef;
        return this;
    }

    public ForyBuilder ignoreStringRef(boolean ignoreStringRef) {
        this.stringRefIgnored = ignoreStringRef;
        return this;
    }

    public ForyBuilder deserializeNonexistentEnumValueAsNull(boolean deserializeNonexistentEnumValueAsNull) {
        this.unknownEnumValueStrategy = UnknownEnumValueStrategy.RETURN_NULL;
        return this;
    }

    public ForyBuilder withUnknownEnumValueStrategy(UnknownEnumValueStrategy action) {
        this.unknownEnumValueStrategy = action;
        return this;
    }

    public ForyBuilder serializeEnumByName(boolean serializeEnumByName) {
        this.serializeEnumByName = serializeEnumByName;
        return this;
    }

    public ForyBuilder ignoreTimeRef(boolean ignoreTimeRef) {
        this.timeRefIgnored = ignoreTimeRef;
        return this;
    }

    public ForyBuilder withNumberCompressed(boolean numberCompressed) {
        this.compressInt = numberCompressed;
        this.withLongCompressed(numberCompressed);
        return this;
    }

    public ForyBuilder withIntCompressed(boolean intCompressed) {
        this.compressInt = intCompressed;
        return this;
    }

    public ForyBuilder withLongCompressed(boolean longCompressed) {
        return this.withLongCompressed(longCompressed ? LongEncoding.SLI : LongEncoding.LE_RAW_BYTES);
    }

    public ForyBuilder withLongCompressed(LongEncoding longEncoding) {
        this.longEncoding = Objects.requireNonNull(longEncoding);
        return this;
    }

    public ForyBuilder withIntArrayCompressed(boolean intArrayCompressed) {
        this.compressIntArray = intArrayCompressed;
        return this;
    }

    public ForyBuilder withLongArrayCompressed(boolean longArrayCompressed) {
        this.compressLongArray = longArrayCompressed;
        return this;
    }

    public ForyBuilder withStringCompressed(boolean stringCompressed) {
        this.compressString = stringCompressed;
        return this;
    }

    public ForyBuilder withWriteNumUtf16BytesForUtf8Encoding(boolean writeNumUtf16BytesForUtf8Encoding) {
        this.writeNumUtf16BytesForUtf8Encoding = writeNumUtf16BytesForUtf8Encoding;
        return this;
    }

    public ForyBuilder withBufferSizeLimitBytes(int bufferSizeLimitBytes) {
        this.bufferSizeLimitBytes = bufferSizeLimitBytes;
        return this;
    }

    public ForyBuilder withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ForyBuilder withCompatibleMode(CompatibleMode compatibleMode) {
        this.compatibleMode = compatibleMode;
        return this;
    }

    public ForyBuilder withClassVersionCheck(boolean checkClassVersion) {
        if (this.language == Language.XLANG && this.compatibleMode == CompatibleMode.SCHEMA_CONSISTENT && !checkClassVersion) {
            throw new IllegalArgumentException("XLANG Schema consistent mode must enable class version check");
        }
        this.checkClassVersion = checkClassVersion;
        return this;
    }

    public ForyBuilder withJdkClassSerializableCheck(boolean checkJdkClassSerializable) {
        this.checkJdkClassSerializable = checkJdkClassSerializable;
        return this;
    }

    public ForyBuilder registerGuavaTypes(boolean register) {
        this.registerGuavaTypes = register;
        return this;
    }

    public ForyBuilder requireClassRegistration(boolean requireClassRegistration) {
        this.requireClassRegistration = requireClassRegistration;
        return this;
    }

    public ForyBuilder suppressClassRegistrationWarnings(boolean suppress) {
        this.suppressClassRegistrationWarnings = suppress;
        return this;
    }

    public ForyBuilder withMetaShare(boolean shareMeta) {
        this.metaShareEnabled = shareMeta;
        if (!shareMeta) {
            this.scopedMetaShareEnabled = false;
        }
        return this;
    }

    public ForyBuilder withScopedMetaShare(boolean scoped) {
        this.scopedMetaShareEnabled = scoped;
        return this;
    }

    public ForyBuilder withMetaCompressor(MetaCompressor metaCompressor) {
        this.metaCompressor = MetaCompressor.checkMetaCompressor(metaCompressor);
        return this;
    }

    public ForyBuilder withDeserializeNonexistentClass(boolean deserializeNonexistentClass) {
        this.deserializeNonexistentClass = deserializeNonexistentClass;
        return this;
    }

    public ForyBuilder withCodegen(boolean codeGen) {
        this.codeGenEnabled = codeGen;
        return this;
    }

    public ForyBuilder withAsyncCompilation(boolean asyncCompilation) {
        this.asyncCompilationEnabled = asyncCompilation;
        return this;
    }

    public ForyBuilder withMaxDepth(int maxDepth) {
        Preconditions.checkArgument(maxDepth >= 2, "maxDepth must >= 2 but got %s", maxDepth, new Object[0]);
        this.maxDepth = maxDepth;
        return this;
    }

    public ForyBuilder withScalaOptimizationEnabled(boolean enableScalaOptimization) {
        this.scalaOptimizationEnabled = enableScalaOptimization;
        if (enableScalaOptimization) {
            try {
                Class.forName(ReflectionUtils.getPackage(Fory.class) + ".serializer.scala.ScalaSerializers");
            }
            catch (ClassNotFoundException e) {
                LOG.warn("`fory-scala` library is not in the classpath, please add it to class path and invoke `org.apache.fory.serializer.scala.ScalaSerializers.registerSerializers` for peek performance");
            }
        }
        return this;
    }

    public ForyBuilder withName(String name) {
        this.name = name;
        return this;
    }

    private void finish() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (this.classLoader == null) {
                this.classLoader = Fory.class.getClassLoader();
            }
        }
        if (this.language != Language.JAVA) {
            this.stringRefIgnored = true;
            this.longEncoding = LongEncoding.PVL;
            this.compressInt = true;
            this.compressString = true;
        }
        if (ENABLE_CLASS_REGISTRATION_FORCIBLY && !this.requireClassRegistration) {
            LOG.warn("Class registration is enabled forcibly.");
            this.requireClassRegistration = true;
        }
        if (this.defaultJDKStreamSerializerType == JavaSerializer.class) {
            LOG.warn("JDK serialization is used for types which customized java serialization by implementing methods such as writeObject/readObject. This is not secure, try to use {} instead, or implement a custom {}.", (Object)ObjectStreamSerializer.class, (Object)Serializer.class);
        }
        if (this.writeNumUtf16BytesForUtf8Encoding == null) {
            this.writeNumUtf16BytesForUtf8Encoding = this.language == Language.JAVA;
        }
        if (this.compatibleMode == CompatibleMode.COMPATIBLE) {
            this.checkClassVersion = false;
            if (this.deserializeNonexistentClass == null) {
                this.deserializeNonexistentClass = true;
            }
            if (this.scopedMetaShareEnabled == null) {
                if (this.metaShareEnabled == null) {
                    this.metaShareEnabled = true;
                    this.scopedMetaShareEnabled = true;
                } else {
                    this.scopedMetaShareEnabled = false;
                }
            } else if (this.metaShareEnabled == null) {
                this.metaShareEnabled = this.scopedMetaShareEnabled;
            }
        } else {
            if (this.deserializeNonexistentClass == null) {
                this.deserializeNonexistentClass = false;
            }
            if (this.scopedMetaShareEnabled != null && this.scopedMetaShareEnabled.booleanValue()) {
                LOG.warn("Scoped meta share is for CompatibleMode only, disable it for {}", (Object)this.compatibleMode);
            }
            this.scopedMetaShareEnabled = false;
            if (this.metaShareEnabled == null) {
                this.metaShareEnabled = false;
            }
            if (this.language != Language.JAVA) {
                this.checkClassVersion = true;
            }
        }
        if (!this.requireClassRegistration) {
            LOG.warn("Class registration isn't forced, unknown classes can be deserialized. If the environment isn't secure, please enable class registration by `ForyBuilder#requireClassRegistration(true)` or configure TypeChecker by `TypeResolver#setTypeChecker`");
        }
        if (GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE && this.asyncCompilationEnabled) {
            LOG.info("Use sync compilation for graalvm native image since it doesn't support JIT.");
            this.asyncCompilationEnabled = false;
        }
    }

    private static Fory newFory(ForyBuilder builder, ClassLoader classLoader) {
        try {
            return new Fory(builder, classLoader);
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.error("Fory creation failed with classloader {}", (Object)classLoader);
            Platform.throwException(t);
            throw new RuntimeException(t);
        }
    }

    public Fory build() {
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        return ForyBuilder.newFory(this, loader);
    }

    public ThreadSafeFory buildThreadSafeFory() {
        return this.buildThreadLocalFory();
    }

    public ThreadLocalFory buildThreadLocalFory() {
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        ThreadLocalFory threadSafeFory = new ThreadLocalFory(classLoader -> ForyBuilder.newFory(this, classLoader));
        threadSafeFory.setClassLoader(loader);
        return threadSafeFory;
    }

    public ThreadSafeFory buildThreadSafeForyPool(int minPoolSize, int maxPoolSize) {
        return this.buildThreadSafeForyPool(minPoolSize, maxPoolSize, 30L, TimeUnit.SECONDS);
    }

    public ThreadSafeFory buildThreadSafeForyPool(int minPoolSize, int maxPoolSize, long expireTime, TimeUnit timeUnit) {
        if (minPoolSize < 0 || maxPoolSize < 0 || minPoolSize > maxPoolSize) {
            throw new IllegalArgumentException(String.format("thread safe fory pool's init pool size error, please check it, min:[%s], max:[%s]", minPoolSize, maxPoolSize));
        }
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        ThreadPoolFory threadSafeFory = new ThreadPoolFory(classLoader -> ForyBuilder.newFory(this, classLoader), minPoolSize, maxPoolSize, expireTime, timeUnit);
        threadSafeFory.setClassLoader(loader);
        return threadSafeFory;
    }

    static {
        String flagValue = System.getProperty("fory.enable_fory_security_mode_forcibly", System.getenv("ENABLE_CLASS_REGISTRATION_FORCIBLY"));
        ENABLE_CLASS_REGISTRATION_FORCIBLY = "true".equals(flagValue) || "1".equals(flagValue);
    }
}

