/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import org.apache.fory.collection.ClassValueCache;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.exception.ForyException;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ObjectCreator;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.record.RecordUtils;
import org.apache.fory.util.unsafe._JDKAccess;

public class ObjectCreators {
    private static final ClassValueCache<ObjectCreator<?>> cache = ClassValueCache.newClassKeySoftCache(8);

    public static <T> ObjectCreator<T> getObjectCreator(Class<T> type) {
        return cache.get(type, () -> ObjectCreators.creategetObjectCreator(type));
    }

    private static <T> ObjectCreator<T> creategetObjectCreator(Class<T> type) {
        if (RecordUtils.isRecord(type)) {
            return new RecordObjectCreator<T>(type);
        }
        Constructor<T> noArgConstructor = ReflectionUtils.getNoArgConstructor(type);
        if (GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE && Platform.JAVA_VERSION >= 25) {
            if (noArgConstructor != null) {
                return new DeclaredNoArgCtrObjectCreator<T>(type);
            }
            return new ParentNoArgCtrObjectCreator<T>(type);
        }
        if (noArgConstructor == null) {
            return new UnsafeObjectCreator<T>(type);
        }
        return new DeclaredNoArgCtrObjectCreator<T>(type);
    }

    public static final class RecordObjectCreator<T>
    extends ObjectCreator<T> {
        private final MethodHandle handle;
        private final Constructor<?> constructor;

        public RecordObjectCreator(Class<T> type) {
            super(type);
            Tuple2<Constructor, MethodHandle> tuple2 = RecordUtils.getRecordConstructor(type);
            this.constructor = (Constructor)tuple2.f0;
            this.handle = (MethodHandle)tuple2.f1;
            if (GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE && Platform.JAVA_VERSION >= 25) {
                try {
                    this.constructor.setAccessible(true);
                }
                catch (Throwable t) {
                    throw new ForyException("Failed to create instance, please provide a public constructor for " + type, t);
                }
            }
        }

        @Override
        public T newInstance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T newInstanceWithArguments(Object ... arguments) {
            try {
                if (GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE && Platform.JAVA_VERSION >= 25) {
                    return (T)this.constructor.newInstance(arguments);
                }
                return (T)this.handle.invokeWithArguments(arguments);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class DeclaredNoArgCtrObjectCreator<T>
    extends ObjectCreator<T> {
        private final MethodHandle handle;

        public DeclaredNoArgCtrObjectCreator(Class<T> type) {
            super(type);
            this.handle = ReflectionUtils.getCtrHandle(type, true);
        }

        @Override
        public T newInstance() {
            try {
                return (T)this.handle.invoke();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public T newInstanceWithArguments(Object ... arguments) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ParentNoArgCtrObjectCreator<T>
    extends ObjectCreator<T> {
        private static volatile Object reflectionFactory;
        private static volatile MethodHandle newConstructorForSerializationMethod;
        private final Constructor<T> constructor;

        public ParentNoArgCtrObjectCreator(Class<T> type) {
            super(type);
            this.constructor = ParentNoArgCtrObjectCreator.createSerializationConstructor(type);
        }

        private static <T> Constructor<T> createSerializationConstructor(Class<T> type) {
            try {
                Constructor<T> parentConstructor;
                if (reflectionFactory == null) {
                    Class<?> reflectionFactoryClass = Platform.JAVA_VERSION >= 9 ? Class.forName("jdk.internal.reflect.ReflectionFactory") : Class.forName("sun.reflect.ReflectionFactory");
                    MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(reflectionFactoryClass);
                    MethodHandle handle = lookup.findStatic(reflectionFactoryClass, "getReflectionFactory", MethodType.methodType(reflectionFactoryClass));
                    reflectionFactory = handle.invoke();
                    newConstructorForSerializationMethod = lookup.findVirtual(reflectionFactoryClass, "newConstructorForSerialization", MethodType.methodType(Constructor.class, Class.class, Constructor.class));
                }
                if ((parentConstructor = ParentNoArgCtrObjectCreator.findPublicNoArgConstructor(type)) == null) {
                    parentConstructor = Object.class.getDeclaredConstructor(new Class[0]);
                } else {
                    try {
                        parentConstructor.newInstance(new Object[0]);
                    }
                    catch (Throwable ignored) {
                        parentConstructor = Object.class.getDeclaredConstructor(new Class[0]);
                    }
                }
                return newConstructorForSerializationMethod.invoke(reflectionFactory, type, parentConstructor);
            }
            catch (Throwable e) {
                throw new ForyException("Failed to create instance, please provide a no-arg constructor for " + type, e);
            }
        }

        private static Constructor<?> findPublicNoArgConstructor(Class<?> type) {
            for (Class<?> current = type.getSuperclass(); current != null && current != Object.class; current = current.getSuperclass()) {
                try {
                    Constructor<?> constructor = current.getDeclaredConstructor(new Class[0]);
                    if (constructor.getModifiers() != 1) continue;
                    return constructor;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public T newInstance() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ForyException("Failed to create instance, please provide a no-arg constructor for " + this.type, e);
            }
        }

        @Override
        public T newInstanceWithArguments(Object ... arguments) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class UnsafeObjectCreator<T>
    extends ObjectCreator<T> {
        public UnsafeObjectCreator(Class<T> type) {
            super(type);
        }

        @Override
        public T newInstance() {
            return Platform.newInstance(this.type);
        }

        @Override
        public T newInstanceWithArguments(Object ... arguments) {
            throw new UnsupportedOperationException();
        }
    }
}

