/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.annotation.Internal;
import org.apache.fory.builder.CodecUtils;
import org.apache.fory.builder.Generated;
import org.apache.fory.codegen.CodeGenerator;
import org.apache.fory.codegen.Expression;
import org.apache.fory.collection.IdentityMap;
import org.apache.fory.collection.LongMap;
import org.apache.fory.collection.ObjectArray;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.ClassSpec;
import org.apache.fory.meta.TypeExtMeta;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.FieldResolver;
import org.apache.fory.resolver.MetaContext;
import org.apache.fory.resolver.MetaStringResolver;
import org.apache.fory.resolver.TypeChecker;
import org.apache.fory.serializer.CodegenSerializer;
import org.apache.fory.serializer.MetaSharedSerializer;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.serializer.NonexistentClassSerializers;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.SerializerFactory;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.ScalaTypes;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.function.Functions;

@Internal
public abstract class TypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ClassResolver.class);
    public static final short NO_CLASS_ID = 0;
    static final ClassInfo NIL_CLASS_INFO = new ClassInfo(null, null, null, null, false, null, 0, 0);
    static final float foryMapLoadFactor = 0.25f;
    static final int estimatedNumRegistered = 150;
    static final String SET_META__CONTEXT_MSG = "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
    final Fory fory;
    final boolean metaContextShareEnabled;
    final MetaStringResolver metaStringResolver;
    final IdentityMap<Class<?>, ClassInfo> classInfoMap = new IdentityMap(64, 0.25f);
    final ExtRegistry extRegistry;
    private static final ConcurrentMap<Integer, GraalvmClassRegistry> GRAALVM_REGISTRY = new ConcurrentHashMap<Integer, GraalvmClassRegistry>();

    protected TypeResolver(Fory fory) {
        this.fory = fory;
        this.metaContextShareEnabled = fory.getConfig().isMetaShareEnabled();
        this.extRegistry = new ExtRegistry();
        this.metaStringResolver = fory.getMetaStringResolver();
    }

    public abstract void register(Class<?> var1);

    public abstract void register(Class<?> var1, int var2);

    public abstract void register(Class<?> var1, String var2, String var3);

    public void register(String className) {
        this.register(this.loadClass(className));
    }

    public void register(String className, int classId) {
        this.register(this.loadClass(className), classId);
    }

    public void register(String className, String namespace, String typeName) {
        this.register(this.loadClass(className), namespace, typeName);
    }

    public abstract void registerSerializer(Class<?> var1, Serializer<?> var2);

    public abstract <T> void registerSerializer(Class<T> var1, Class<? extends Serializer> var2);

    public final boolean needToWriteRef(TypeRef<?> typeRef) {
        Object extInfo = typeRef.getExtInfo();
        if (extInfo instanceof TypeExtMeta) {
            TypeExtMeta meta = (TypeExtMeta)extInfo;
            return meta.trackingRef();
        }
        Class<?> cls = typeRef.getRawType();
        if (this.fory.trackingRef()) {
            ClassInfo classInfo = this.classInfoMap.get(cls);
            if (classInfo == null || classInfo.serializer == null) {
                return !cls.isEnum();
            }
            return classInfo.serializer.needToWriteRef();
        }
        return false;
    }

    public final boolean needToWriteClassDef(Serializer serializer) {
        if (this.fory.getConfig().getCompatibleMode() != CompatibleMode.COMPATIBLE) {
            return false;
        }
        if (GraalvmSupport.isGraalBuildtime() && serializer instanceof GraalvmSupport.GraalvmSerializerHolder) {
            Class<? extends Serializer> serializerClass = ((GraalvmSupport.GraalvmSerializerHolder)serializer).getSerializerClass();
            return Generated.GeneratedObjectSerializer.class.isAssignableFrom(serializerClass) || Generated.GeneratedMetaSharedSerializer.class.isAssignableFrom(serializerClass);
        }
        return serializer instanceof Generated.GeneratedObjectSerializer || serializer instanceof Generated.GeneratedMetaSharedSerializer || serializer instanceof CodegenSerializer.LazyInitBeanSerializer || serializer instanceof ObjectSerializer || serializer instanceof MetaSharedSerializer;
    }

    public abstract boolean isRegistered(Class<?> var1);

    public abstract boolean isRegisteredById(Class<?> var1);

    public abstract boolean isRegisteredByName(Class<?> var1);

    public abstract boolean isMonomorphic(Class<?> var1);

    public abstract ClassInfo getClassInfo(Class<?> var1);

    public abstract ClassInfo getClassInfo(Class<?> var1, boolean var2);

    public abstract ClassInfo getClassInfo(Class<?> var1, ClassInfoHolder var2);

    public abstract void writeClassInfo(MemoryBuffer var1, ClassInfo var2);

    public Expression writeClassExpr(Expression classResolverRef, Expression buffer, Expression classInfo) {
        return new Expression.Invoke(classResolverRef, "writeClassInfo", buffer, classInfo);
    }

    public abstract ClassInfo readClassInfo(MemoryBuffer var1, ClassInfoHolder var2);

    public abstract ClassInfo readClassInfo(MemoryBuffer var1, ClassInfo var2);

    abstract ClassInfo readSharedClassMeta(MemoryBuffer var1, MetaContext var2);

    public final ClassInfo readSharedClassMeta(MemoryBuffer buffer, Class<?> targetClass) {
        ClassInfo classInfo = this.readSharedClassMeta(buffer, this.fory.getSerializationContext().getMetaContext());
        Class<?> readClass = classInfo.getCls();
        if (targetClass != readClass) {
            Tuple2<Class<?>, Class<?>> key = Tuple2.of(readClass, targetClass);
            ClassInfo newClassInfo = this.extRegistry.transformedClassInfo.get(key);
            if (newClassInfo == null) {
                newClassInfo = this.getMetaSharedClassInfo(classInfo.classDef.replaceRootClassTo((ClassResolver)this, targetClass), targetClass);
                this.extRegistry.transformedClassInfo.put(key, newClassInfo);
            }
            return newClassInfo;
        }
        return classInfo;
    }

    final ClassInfo readSharedClassMeta(MetaContext metaContext, int index) {
        ClassDef classDef = metaContext.readClassDefs.get(index);
        Tuple2<ClassDef, ClassInfo> classDefTuple = this.extRegistry.classIdToDef.get(classDef.getId());
        ClassInfo classInfo = classDefTuple == null || classDefTuple.f1 == null || ((ClassInfo)classDefTuple.f1).serializer == null ? this.buildMetaSharedClassInfo(classDefTuple, classDef) : (ClassInfo)classDefTuple.f1;
        metaContext.readClassInfos.set(index, classInfo);
        return classInfo;
    }

    final ClassInfo buildMetaSharedClassInfo(Tuple2<ClassDef, ClassInfo> classDefTuple, ClassDef classDef) {
        if (classDefTuple != null) {
            classDef = (ClassDef)classDefTuple.f0;
        }
        Class<?> cls = this.loadClass(classDef.getClassSpec());
        ClassInfo classInfo = !classDef.hasFieldsMeta() ? this.getClassInfo(cls) : this.getMetaSharedClassInfo(classDef, cls);
        this.putClassDef(classDef, classInfo);
        return classInfo;
    }

    private ClassInfo getMetaSharedClassInfo(ClassDef classDef, Class<?> clz) {
        Short classId;
        Class<?> cls;
        if (clz == NonexistentClass.NonexistentSkip.class) {
            clz = NonexistentClass.NonexistentMetaShared.class;
        }
        ClassInfo classInfo = new ClassInfo(this, cls, null, (classId = this.extRegistry.registeredClassIdMap.get(cls = clz)) == null ? (short)0 : classId, 0);
        classInfo.classDef = classDef;
        if (NonexistentClass.class.isAssignableFrom(TypeUtils.getComponentIfArray(cls))) {
            if (cls == NonexistentClass.NonexistentMetaShared.class) {
                classInfo.setSerializer(this, new NonexistentClassSerializers.NonexistentClassSerializer(this.fory, classDef));
                if (!this.fory.isCrossLanguage()) {
                    Preconditions.checkNotNull(classId);
                }
            } else {
                classInfo.serializer = NonexistentClassSerializers.getSerializer(this.fory, classDef.getClassName(), cls);
            }
            return classInfo;
        }
        if (clz.isArray() || cls.isEnum()) {
            return this.getClassInfo(cls);
        }
        Class sc = this.getMetaSharedDeserializerClassFromGraalvmRegistry(cls, classDef);
        if (sc == null) {
            if (GraalvmSupport.isGraalRuntime()) {
                sc = MetaSharedSerializer.class;
                LOG.warn("Can't generate class at runtime in graalvm for class def {}, use {} instead", (Object)classDef, (Object)sc);
            } else {
                sc = this.fory.getJITContext().registerSerializerJITCallback(() -> MetaSharedSerializer.class, () -> CodecUtils.loadOrGenMetaSharedCodecClass(this.fory, cls, classDef), c -> classInfo.setSerializer(this, Serializers.newSerializer(this.fory, cls, c)));
            }
        }
        if (sc == MetaSharedSerializer.class) {
            classInfo.setSerializer(this, new MetaSharedSerializer(this.fory, cls, classDef));
        } else {
            classInfo.setSerializer(this, Serializers.newSerializer(this.fory, cls, sc));
        }
        return classInfo;
    }

    public final void writeClassDefs(MemoryBuffer buffer) {
        MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
        ObjectArray<ClassDef> writingClassDefs = metaContext.writingClassDefs;
        int size = writingClassDefs.size;
        buffer.writeVarUint32Small7(size);
        if (buffer.isHeapFullyWriteable()) {
            this.writeClassDefs(buffer, writingClassDefs, size);
        } else {
            for (int i = 0; i < size; ++i) {
                writingClassDefs.get(i).writeClassDef(buffer);
            }
        }
        metaContext.writingClassDefs.size = 0;
    }

    private void writeClassDefs(MemoryBuffer buffer, ObjectArray<ClassDef> writingClassDefs, int size) {
        for (int i = 0; i < size; ++i) {
            buffer.writeBytes(writingClassDefs.get(i).getEncoded());
            MemoryBuffer memoryBuffer = MemoryBuffer.fromByteArray(writingClassDefs.get(i).getEncoded());
            ClassDef.readClassDef(this.fory, memoryBuffer, memoryBuffer.readInt64());
        }
    }

    public final void readClassDefs(MemoryBuffer buffer) {
        MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        int numClassDefs = buffer.readVarUint32Small7();
        for (int i = 0; i < numClassDefs; ++i) {
            long id = buffer.readInt64();
            Tuple2<ClassDef, ClassInfo> tuple2 = this.extRegistry.classIdToDef.get(id);
            if (tuple2 != null) {
                ClassDef.skipClassDef(buffer, id);
            } else {
                tuple2 = this.readClassDef(buffer, id);
            }
            metaContext.readClassDefs.add((ClassDef)tuple2.f0);
            metaContext.readClassInfos.add((ClassInfo)tuple2.f1);
        }
    }

    private Tuple2<ClassDef, ClassInfo> readClassDef(MemoryBuffer buffer, long header) {
        ClassDef readClassDef = ClassDef.readClassDef(this.fory, buffer, header);
        Tuple2<ClassDef, ClassInfo> tuple2 = this.extRegistry.classIdToDef.get(readClassDef.getId());
        if (tuple2 == null) {
            tuple2 = this.putClassDef(readClassDef, null);
        }
        return tuple2;
    }

    private Tuple2<ClassDef, ClassInfo> putClassDef(ClassDef classDef, ClassInfo classInfo) {
        Tuple2<ClassDef, ClassInfo> tuple2 = Tuple2.of(classDef, classInfo);
        this.extRegistry.classIdToDef.put(classDef.getId(), tuple2);
        return tuple2;
    }

    final Class<?> loadClass(ClassSpec classSpec) {
        if (classSpec.type != null) {
            return classSpec.type;
        }
        return this.loadClass(classSpec.entireClassName, classSpec.isEnum, classSpec.dimension);
    }

    final Class<?> loadClass(String className, boolean isEnum, int arrayDims) {
        return this.loadClass(className, isEnum, arrayDims, this.fory.getConfig().deserializeNonexistentClass());
    }

    final Class<?> loadClass(String className) {
        return this.loadClass(className, false, -1, false);
    }

    final Class<?> loadClass(String className, boolean isEnum, int arrayDims, boolean deserializeNonexistentClass) {
        this.extRegistry.typeChecker.checkType(this, className);
        Class cls = (Class)this.extRegistry.registeredClasses.get((Object)className);
        if (cls != null) {
            return cls;
        }
        try {
            return Class.forName(className, false, this.fory.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                String msg = String.format("Class %s not found from classloaders [%s, %s]", className, this.fory.getClassLoader(), Thread.currentThread().getContextClassLoader());
                if (deserializeNonexistentClass) {
                    LOG.warn(msg);
                    return NonexistentClass.getNonexistentClass(className, isEnum, arrayDims, this.metaContextShareEnabled);
                }
                throw new IllegalStateException(msg, ex);
            }
        }
    }

    public abstract <T> Serializer<T> getSerializer(Class<T> var1);

    public abstract Serializer<?> getRawSerializer(Class<?> var1);

    public abstract <T> void setSerializer(Class<T> var1, Serializer<T> var2);

    public abstract <T> void setSerializerIfAbsent(Class<T> var1, Serializer<T> var2);

    public abstract ClassInfo nilClassInfo();

    public abstract ClassInfoHolder nilClassInfoHolder();

    public abstract GenericType buildGenericType(TypeRef<?> var1);

    public abstract GenericType buildGenericType(Type var1);

    public abstract void initialize();

    public abstract ClassDef getTypeDef(Class<?> var1, boolean var2);

    public final boolean isSerializable(Class<?> cls) {
        if (ReflectionUtils.isAbstract(cls) || cls.isInterface()) {
            return false;
        }
        try {
            ClassInfo classInfo = this.classInfoMap.get(cls);
            Serializer<?> serializer = null;
            if (classInfo != null) {
                serializer = classInfo.serializer;
            }
            this.getSerializerClass(cls, false);
            if (classInfo != null && serializer == null) {
                classInfo.serializer = null;
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public abstract Class<? extends Serializer> getSerializerClass(Class<?> var1);

    public abstract Class<? extends Serializer> getSerializerClass(Class<?> var1, boolean var2);

    public final boolean isCollection(Class<?> cls) {
        if (Collection.class.isAssignableFrom(cls)) {
            return true;
        }
        if (this.fory.getConfig().isScalaOptimizationEnabled()) {
            if (ScalaTypes.getScalaMapType().isAssignableFrom(cls)) {
                return false;
            }
            return ScalaTypes.getScalaIterableType().isAssignableFrom(cls);
        }
        return false;
    }

    public final boolean isSet(Class<?> cls) {
        if (Set.class.isAssignableFrom(cls)) {
            return true;
        }
        if (this.fory.getConfig().isScalaOptimizationEnabled()) {
            if (ScalaTypes.getScalaMapType().isAssignableFrom(cls)) {
                return false;
            }
            return ScalaTypes.getScalaSetType().isAssignableFrom(cls);
        }
        return false;
    }

    public final boolean isMap(Class<?> cls) {
        if (cls == NonexistentClass.NonexistentMetaShared.class) {
            return false;
        }
        return Map.class.isAssignableFrom(cls) || this.fory.getConfig().isScalaOptimizationEnabled() && ScalaTypes.getScalaMapType().isAssignableFrom(cls);
    }

    public final DescriptorGrouper createDescriptorGrouper(Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered) {
        return this.createDescriptorGrouper(descriptors, descriptorsGroupedOrdered, null);
    }

    public abstract DescriptorGrouper createDescriptorGrouper(Collection<Descriptor> var1, boolean var2, Function<Descriptor, Descriptor> var3);

    public abstract Collection<Descriptor> getFieldDescriptors(Class<?> var1, boolean var2);

    protected final Map<String, GenericType> buildGenericMap(Class<?> cls) {
        HashMap<String, GenericType> map = new HashMap<String, GenericType>();
        HashMap<String, GenericType> map2 = new HashMap<String, GenericType>();
        for (Field field : ReflectionUtils.getFields(cls, true)) {
            Type type = field.getGenericType();
            GenericType genericType = this.buildGenericType(type);
            this.buildGenericMap(map, genericType);
            TypeRef typeRef = TypeRef.of(type);
            this.buildGenericMap(map2, typeRef);
        }
        map.putAll(map2);
        return map;
    }

    private void buildGenericMap(Map<String, GenericType> map, TypeRef<?> typeRef) {
        if (map.containsKey(typeRef.getType().getTypeName())) {
            return;
        }
        map.put(typeRef.getType().getTypeName(), this.buildGenericType(typeRef));
        Class<?> rawType = typeRef.getRawType();
        if (TypeUtils.isMap(rawType)) {
            Tuple2<TypeRef<?>, TypeRef<?>> kvTypes = TypeUtils.getMapKeyValueType(typeRef);
            this.buildGenericMap(map, (TypeRef)kvTypes.f0);
            this.buildGenericMap(map, (TypeRef)kvTypes.f1);
        } else if (TypeUtils.isCollection(rawType)) {
            TypeRef<?> elementType = TypeUtils.getElementType(typeRef);
            this.buildGenericMap(map, elementType);
        } else if (rawType.isArray()) {
            TypeRef<?> arrayComponent = TypeUtils.getArrayComponent(typeRef);
            this.buildGenericMap(map, arrayComponent);
        }
    }

    private void buildGenericMap(Map<String, GenericType> map, GenericType genericType) {
        if (map.containsKey(genericType.getType().getTypeName())) {
            return;
        }
        map.put(genericType.getType().getTypeName(), genericType);
        for (GenericType t : genericType.getTypeParameters()) {
            this.buildGenericMap(map, t);
        }
    }

    public void setTypeChecker(TypeChecker typeChecker) {
        this.extRegistry.typeChecker = typeChecker;
    }

    public static void _addGraalvmClassRegistry(int foryConfigHash, ClassResolver classResolver) {
        if (GraalvmSupport.isGraalBuildtime()) {
            GraalvmClassRegistry registry = GRAALVM_REGISTRY.computeIfAbsent(foryConfigHash, k -> new GraalvmClassRegistry());
            registry.resolvers.add(classResolver);
        }
    }

    final GraalvmClassRegistry getGraalvmClassRegistry() {
        return GRAALVM_REGISTRY.computeIfAbsent(this.fory.getConfig().getConfigHash(), k -> new GraalvmClassRegistry());
    }

    final Class<? extends Serializer> getGraalvmSerializerClass(Serializer serializer) {
        if (serializer instanceof GraalvmSupport.GraalvmSerializerHolder) {
            return ((GraalvmSupport.GraalvmSerializerHolder)serializer).getSerializerClass();
        }
        return serializer.getClass();
    }

    final Class<? extends Serializer> getSerializerClassFromGraalvmRegistry(Class<?> cls) {
        GraalvmClassRegistry registry = this.getGraalvmClassRegistry();
        List<ClassResolver> classResolvers = registry.resolvers;
        if (classResolvers.isEmpty()) {
            return null;
        }
        for (ClassResolver classResolver : classResolvers) {
            ClassInfo classInfo;
            if (classResolver == this || (classInfo = this.getClassInfo(cls, false)) == null || classInfo.serializer == null) continue;
            return classInfo.serializer.getClass();
        }
        Class<? extends Serializer> serializerClass = registry.serializerClassMap.get(cls);
        if (serializerClass != null) {
            return serializerClass;
        }
        if (GraalvmSupport.isGraalRuntime()) {
            if (Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls)) {
                return null;
            }
            throw new RuntimeException(String.format("Class %s is not registered", cls));
        }
        return null;
    }

    private Class<? extends Serializer> getMetaSharedDeserializerClassFromGraalvmRegistry(Class<?> cls, ClassDef classDef) {
        GraalvmClassRegistry registry = this.getGraalvmClassRegistry();
        List<ClassResolver> classResolvers = registry.resolvers;
        if (classResolvers.isEmpty()) {
            return null;
        }
        Class<? extends Serializer> deserializerClass = registry.deserializerClassMap.get(classDef.getId());
        if (deserializerClass != null) {
            return deserializerClass;
        }
        if (GraalvmSupport.isGraalRuntime()) {
            if (Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls)) {
                return null;
            }
            throw new RuntimeException(String.format("Class %s is not registered, registered classes: %s", cls, registry.deserializerClassMap));
        }
        return null;
    }

    public final Fory getFory() {
        return this.fory;
    }

    public final MetaStringResolver getMetaStringResolver() {
        return this.metaStringResolver;
    }

    static class ExtRegistry {
        short classIdGenerator = 1;
        SerializerFactory serializerFactory;
        final IdentityMap<Class<?>, Short> registeredClassIdMap = new IdentityMap(150);
        final BiMap<String, Class<?>> registeredClasses = HashBiMap.create((int)150);
        final IdentityMap<Class<?>, ClassInfo> absClassInfo = new IdentityMap(150, 0.25f);
        final Set<Class<?>> getClassCtx = new HashSet();
        final Map<Class<?>, FieldResolver> fieldResolverMap = new HashMap();
        final LongMap<Tuple2<ClassDef, ClassInfo>> classIdToDef = new LongMap();
        final Map<Class<?>, ClassDef> currentLayerClassDef = new HashMap();
        final Map<Tuple2<Class<?>, Class<?>>, ClassInfo> transformedClassInfo = new HashMap();
        final ConcurrentHashMap<Tuple2<Class<?>, Boolean>, SortedMap<Member, Descriptor>> descriptorsCache = new ConcurrentHashMap();
        TypeChecker typeChecker = (resolver, className) -> true;
        GenericType objectGenericType;
        final IdentityMap<Type, GenericType> genericTypes = new IdentityMap();
        final Map<Class, Map<String, GenericType>> classGenericTypes = new HashMap<Class, Map<String, GenericType>>();
        final Map<List<ClassLoader>, CodeGenerator> codeGeneratorMap = new HashMap<List<ClassLoader>, CodeGenerator>();
        final Set<ClassInfo> registeredClassInfos = new HashSet<ClassInfo>();
        boolean ensureSerializersCompiled;

        ExtRegistry() {
        }
    }

    static class GraalvmClassRegistry {
        final List<ClassResolver> resolvers = Collections.synchronizedList(new ArrayList());
        final Map<Class<?>, Class<? extends Serializer>> serializerClassMap = new ConcurrentHashMap();
        final Map<Long, Class<? extends Serializer>> deserializerClassMap = new ConcurrentHashMap<Long, Class<? extends Serializer>>();

        private GraalvmClassRegistry() {
        }
    }
}

