/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.fory.Fory;
import org.apache.fory.collection.ClassValueCache;
import org.apache.fory.exception.ForyException;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.serializer.CodegenSerializer;
import org.apache.fory.serializer.JavaSerializer;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.function.SerializableFunction;
import org.apache.fory.util.unsafe._JDKAccess;

public class LambdaSerializer
extends Serializer {
    public static Class<?> STUB_LAMBDA_CLASS = ((SerializableFunction)x -> x * 2).getClass();
    private static final Class<SerializedLambda> SERIALIZED_LAMBDA = SerializedLambda.class;
    private static final MethodHandle READ_RESOLVE_HANDLE;
    private static final boolean SERIALIZED_LAMBDA_HAS_JDK_WRITE;
    private static final boolean SERIALIZED_LAMBDA_HAS_JDK_READ;
    private static final ClassValueCache<MethodHandle> writeReplaceMethodCache;
    private final MethodHandle writeReplaceHandle;
    private Serializer dataSerializer;

    public LambdaSerializer(Fory fory, Class<?> cls) {
        super(fory, cls);
        if (cls != ReplaceStub.class) {
            if (!Serializable.class.isAssignableFrom(cls)) {
                String msg = String.format("Lambda %s needs to implement %s for serialization", cls, Serializable.class.getName());
                throw new UnsupportedOperationException(msg);
            }
            MethodHandle methodHandle = writeReplaceMethodCache.getIfPresent(cls);
            if (methodHandle == null) {
                try {
                    MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(cls);
                    Object writeReplaceMethod = ReflectionUtils.getObjectFieldValue((Object)ObjectStreamClass.lookup(cls), "writeReplaceMethod");
                    methodHandle = lookup.unreflect((Method)Objects.requireNonNull(writeReplaceMethod));
                    writeReplaceMethodCache.put(cls, methodHandle);
                }
                catch (Throwable e) {
                    throw new RuntimeException(String.format("Failed to create writeReplace MethodHandle for %s", cls), e);
                }
            }
            this.writeReplaceHandle = methodHandle;
        } else {
            this.writeReplaceHandle = null;
        }
        if (cls == STUB_LAMBDA_CLASS) {
            this.getDataSerializer();
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        assert (value.getClass() != ReplaceStub.class);
        try {
            Object replacement = this.writeReplaceHandle.invoke(value);
            Preconditions.checkArgument(SERIALIZED_LAMBDA.isInstance(replacement));
            this.getDataSerializer().write(buffer, replacement);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't serialize lambda " + value, e);
        }
    }

    public Object copy(Object value) {
        try {
            Object replacement = this.writeReplaceHandle.invoke(value);
            Object newReplacement = this.getDataSerializer().copy(replacement);
            return READ_RESOLVE_HANDLE.invoke(newReplacement);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't copy lambda " + value, e);
        }
    }

    public Object read(MemoryBuffer buffer) {
        try {
            Object replacement = this.getDataSerializer().read(buffer);
            return READ_RESOLVE_HANDLE.invoke(replacement);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't deserialize lambda", e);
        }
    }

    private Serializer getDataSerializer() {
        Serializer dataSerializer = this.dataSerializer;
        if (dataSerializer == null) {
            Class sc = SERIALIZED_LAMBDA_HAS_JDK_WRITE || SERIALIZED_LAMBDA_HAS_JDK_READ ? this.fory.getDefaultJDKStreamSerializerType() : this.fory.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(this.fory, SERIALIZED_LAMBDA), c -> {
                this.dataSerializer = Serializers.newSerializer(this.fory, SERIALIZED_LAMBDA, c);
                this.fory.getClassResolver().clearSerializer(SERIALIZED_LAMBDA);
            });
            this.dataSerializer = dataSerializer = Serializers.newSerializer(this.fory, SERIALIZED_LAMBDA, sc);
            this.fory.getClassResolver().clearSerializer(SERIALIZED_LAMBDA);
        }
        return dataSerializer;
    }

    static {
        SERIALIZED_LAMBDA_HAS_JDK_WRITE = JavaSerializer.getWriteObjectMethod(SERIALIZED_LAMBDA) != null;
        SERIALIZED_LAMBDA_HAS_JDK_READ = JavaSerializer.getReadObjectMethod(SERIALIZED_LAMBDA) != null;
        writeReplaceMethodCache = ClassValueCache.newClassKeySoftCache(32);
        try {
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(SERIALIZED_LAMBDA);
            Object readResolveMethod = ReflectionUtils.getObjectFieldValue((Object)ObjectStreamClass.lookup(SERIALIZED_LAMBDA), "readResolveMethod");
            READ_RESOLVE_HANDLE = lookup.unreflect((Method)readResolveMethod);
        }
        catch (IllegalAccessException e) {
            throw new ForyException(e);
        }
    }

    public static class ReplaceStub {
    }
}

