/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.collection.Tuple3;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.reflect.FieldAccessor;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.SerializationBinding;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.Generics;
import org.apache.fory.util.DefaultValueUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.record.RecordInfo;
import org.apache.fory.util.record.RecordUtils;

public class MetaSharedSerializer<T>
extends AbstractObjectSerializer<T> {
    private final AbstractObjectSerializer.FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final AbstractObjectSerializer.GenericTypeField[] otherFields;
    private final AbstractObjectSerializer.GenericTypeField[] containerFields;
    private final RecordInfo recordInfo;
    private Serializer<T> serializer;
    private final ClassInfoHolder classInfoHolder;
    private final SerializationBinding binding;
    private final boolean hasDefaultValues;
    private final DefaultValueUtils.DefaultValueField[] defaultValueFields;

    public MetaSharedSerializer(Fory fory, Class<T> type, ClassDef classDef) {
        super(fory, type);
        DefaultValueUtils.DefaultValueSupport kotlinDefaultValueSupport;
        Preconditions.checkArgument(!fory.getConfig().checkClassVersion(), "Class version check should be disabled when compatible mode is enabled.");
        Preconditions.checkArgument(fory.getConfig().isMetaShareEnabled(), "Meta share must be enabled.");
        Collection<Descriptor> descriptors = MetaSharedSerializer.consolidateFields(fory._getTypeResolver(), type, classDef);
        DescriptorGrouper descriptorGrouper = fory._getTypeResolver().createDescriptorGrouper(descriptors, false);
        Tuple3<Tuple2<AbstractObjectSerializer.FinalTypeField[], boolean[]>, AbstractObjectSerializer.GenericTypeField[], AbstractObjectSerializer.GenericTypeField[]> infos = AbstractObjectSerializer.buildFieldInfos(fory, descriptorGrouper);
        this.finalFields = (AbstractObjectSerializer.FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (AbstractObjectSerializer.GenericTypeField[])infos.f1;
        this.containerFields = (AbstractObjectSerializer.GenericTypeField[])infos.f2;
        this.classInfoHolder = this.classResolver.nilClassInfoHolder();
        if (this.isRecord) {
            List<String> fieldNames = descriptorGrouper.getSortedDescriptors().stream().map(Descriptor::getName).collect(Collectors.toList());
            this.recordInfo = new RecordInfo(type, fieldNames);
        } else {
            this.recordInfo = null;
        }
        this.binding = SerializationBinding.createBinding(fory);
        boolean hasDefaultValues = false;
        DefaultValueUtils.DefaultValueField[] defaultValueFields = new DefaultValueUtils.DefaultValueField[]{};
        DefaultValueUtils.DefaultValueSupport defaultValueSupport = null;
        if (fory.getConfig().isScalaOptimizationEnabled() && (defaultValueSupport = DefaultValueUtils.getScalaDefaultValueSupport()) != null) {
            hasDefaultValues = defaultValueSupport.hasDefaultValues(type);
            defaultValueFields = defaultValueSupport.buildDefaultValueFields(fory, type, descriptorGrouper.getSortedDescriptors());
        }
        if (!hasDefaultValues && (kotlinDefaultValueSupport = DefaultValueUtils.getKotlinDefaultValueSupport()) != null) {
            hasDefaultValues = kotlinDefaultValueSupport.hasDefaultValues(type);
            defaultValueFields = kotlinDefaultValueSupport.buildDefaultValueFields(fory, type, descriptorGrouper.getSortedDescriptors());
        }
        this.hasDefaultValues = hasDefaultValues;
        this.defaultValueFields = defaultValueFields;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        if (this.serializer == null) {
            this.serializer = this.classResolver.createSerializerSafe(this.type, () -> new ObjectSerializer(this.fory, this.type));
        }
        this.serializer.write(buffer, value);
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        this.write(buffer, value);
    }

    @Override
    public T read(MemoryBuffer buffer) {
        FieldAccessor fieldAccessor;
        if (this.isRecord) {
            Object[] fieldValues = new Object[this.finalFields.length + this.otherFields.length + this.containerFields.length];
            this.readFields(buffer, fieldValues);
            fieldValues = RecordUtils.remapping(this.recordInfo, fieldValues);
            Object t = this.objectCreator.newInstanceWithArguments(fieldValues);
            Arrays.fill(this.recordInfo.getRecordComponents(), null);
            return t;
        }
        T obj = this.newInstance();
        Fory fory = this.fory;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        SerializationBinding binding = this.binding;
        refResolver.reference(obj);
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = this.isFinal[i];
            FieldAccessor fieldAccessor2 = fieldInfo.fieldAccessor;
            boolean nullable = fieldInfo.nullable;
            if (fieldAccessor2 != null) {
                short classId = fieldInfo.classId;
                if (!AbstractObjectSerializer.readPrimitiveFieldValueFailed(fory, buffer, obj, fieldAccessor2, classId) || !(nullable ? AbstractObjectSerializer.readBasicNullableObjectFieldValueFailed(fory, buffer, obj, fieldAccessor2, classId) : AbstractObjectSerializer.readBasicObjectFieldValueFailed(fory, buffer, obj, fieldAccessor2, classId))) continue;
                assert (fieldInfo.classInfo != null);
                Object fieldValue = AbstractObjectSerializer.readFinalObjectFieldValue(binding, refResolver, classResolver, fieldInfo, isFinal, buffer);
                fieldAccessor2.putObject(obj, fieldValue);
                continue;
            }
            if (fieldInfo.fieldConverter == null) {
                if (!MetaSharedSerializer.skipPrimitiveFieldValueFailed(fory, fieldInfo.classId, buffer)) continue;
                if (fieldInfo.classInfo == null) {
                    fory.readRef(buffer, this.classInfoHolder);
                    continue;
                }
                AbstractObjectSerializer.readFinalObjectFieldValue(binding, refResolver, classResolver, fieldInfo, isFinal, buffer);
                continue;
            }
            this.compatibleRead(buffer, fieldInfo, isFinal, obj);
        }
        Generics generics = fory.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue = AbstractObjectSerializer.readContainerFieldValue(binding, generics, fieldInfo, buffer);
            fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue);
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue = AbstractObjectSerializer.readOtherFieldValue(binding, fieldInfo, buffer);
            fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    private void compatibleRead(MemoryBuffer buffer, AbstractObjectSerializer.FinalTypeField fieldInfo, boolean isFinal, Object obj) {
        short classId = fieldInfo.classId;
        Object fieldValue = classId >= 5 && classId <= 12 ? Serializers.readPrimitiveValue(this.fory, buffer, classId) : AbstractObjectSerializer.readFinalObjectFieldValue(this.binding, this.refResolver, this.classResolver, fieldInfo, isFinal, buffer);
        fieldInfo.fieldConverter.set(obj, fieldValue);
    }

    private T newInstance() {
        if (!this.hasDefaultValues) {
            return this.newBean();
        }
        Object obj = GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE ? this.newBean() : Platform.newInstance(this.type);
        DefaultValueUtils.setDefaultValues(obj, this.defaultValueFields);
        return obj;
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        return this.read(buffer);
    }

    private void readFields(MemoryBuffer buffer, Object[] fields) {
        Object fieldValue;
        int counter = 0;
        Fory fory = this.fory;
        RefResolver refResolver = this.refResolver;
        ClassResolver classResolver = this.classResolver;
        SerializationBinding binding = this.binding;
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = this.isFinal[i];
            if (fieldInfo.fieldAccessor != null) {
                assert (fieldInfo.classInfo != null);
                short classId = fieldInfo.classId;
                if (classId >= 5 && classId <= 12) {
                    fields[counter++] = Serializers.readPrimitiveValue(fory, buffer, classId);
                    continue;
                }
                fieldValue = AbstractObjectSerializer.readFinalObjectFieldValue(binding, refResolver, classResolver, fieldInfo, isFinal, buffer);
                fields[counter++] = fieldValue;
                continue;
            }
            if (MetaSharedSerializer.skipPrimitiveFieldValueFailed(fory, fieldInfo.classId, buffer)) {
                if (fieldInfo.classInfo == null) {
                    fory.readRef(buffer, this.classInfoHolder);
                } else {
                    AbstractObjectSerializer.readFinalObjectFieldValue(binding, refResolver, classResolver, fieldInfo, isFinal, buffer);
                }
            }
            fields[counter++] = null;
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            fieldValue = AbstractObjectSerializer.readOtherFieldValue(binding, fieldInfo, buffer);
            fields[counter++] = fieldValue;
        }
        Generics generics = fory.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue2 = AbstractObjectSerializer.readContainerFieldValue(binding, generics, fieldInfo, buffer);
            fields[counter++] = fieldValue2;
        }
    }

    static boolean skipPrimitiveFieldValueFailed(Fory fory, short classId, MemoryBuffer buffer) {
        switch (classId) {
            case 5: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 6: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 7: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 8: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 9: {
                if (fory.compressInt()) {
                    buffer.readVarInt32();
                } else {
                    buffer.increaseReaderIndex(4);
                }
                return false;
            }
            case 10: {
                buffer.increaseReaderIndex(4);
                return false;
            }
            case 11: {
                fory.readInt64(buffer);
                return false;
            }
            case 12: {
                buffer.increaseReaderIndex(8);
                return false;
            }
        }
        return true;
    }

    public static Collection<Descriptor> consolidateFields(TypeResolver resolver, Class<?> cls, ClassDef classDef) {
        return classDef.getDescriptors(resolver, cls);
    }
}

