/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.ImmutableSerializer;
import org.apache.fory.serializer.Serializer;

public final class OptionalSerializers {
    public static void registerDefaultSerializers(Fory fory) {
        ClassResolver resolver = fory.getClassResolver();
        resolver.registerSerializer(Optional.class, new OptionalSerializer(fory));
        resolver.registerSerializer(OptionalInt.class, new OptionalIntSerializer(fory));
        resolver.registerSerializer(OptionalLong.class, new OptionalLongSerializer(fory));
        resolver.registerSerializer(OptionalDouble.class, new OptionalDoubleSerializer(fory));
    }

    public static final class OptionalSerializer
    extends Serializer<Optional> {
        public OptionalSerializer(Fory fory) {
            super(fory, Optional.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Optional value) {
            Object nullable = value.isPresent() ? value.get() : null;
            this.fory.writeRef(buffer, nullable);
        }

        @Override
        public Optional copy(Optional originOptional) {
            if (originOptional.isPresent()) {
                return Optional.ofNullable(this.fory.copyObject(originOptional.get()));
            }
            return originOptional;
        }

        @Override
        public Optional read(MemoryBuffer buffer) {
            return Optional.ofNullable(this.fory.readRef(buffer));
        }
    }

    public static final class OptionalIntSerializer
    extends ImmutableSerializer<OptionalInt> {
        public OptionalIntSerializer(Fory fory) {
            super(fory, OptionalInt.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalInt value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeInt32(value.getAsInt());
            }
        }

        @Override
        public OptionalInt read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalInt.of(buffer.readInt32());
            }
            return OptionalInt.empty();
        }
    }

    public static final class OptionalLongSerializer
    extends ImmutableSerializer<OptionalLong> {
        public OptionalLongSerializer(Fory fory) {
            super(fory, OptionalLong.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalLong value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeInt64(value.getAsLong());
            }
        }

        @Override
        public OptionalLong read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalLong.of(buffer.readInt64());
            }
            return OptionalLong.empty();
        }
    }

    public static final class OptionalDoubleSerializer
    extends ImmutableSerializer<OptionalDouble> {
        public OptionalDoubleSerializer(Fory fory) {
            super(fory, OptionalDouble.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalDouble value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeFloat64(value.getAsDouble());
            }
        }

        @Override
        public OptionalDouble read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalDouble.of(buffer.readFloat64());
            }
            return OptionalDouble.empty();
        }
    }
}

