/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fory.Fory;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.FieldResolver;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.CompatibleSerializer;
import org.apache.fory.serializer.JavaSerializer;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.util.Preconditions;

public class ChildContainerSerializers {
    public static Class<? extends Serializer> getCollectionSerializerClass(Class<?> cls) {
        if (ChildCollectionSerializer.superClasses.contains(cls)) {
            return null;
        }
        if (ClassResolver.useReplaceResolveSerializer(cls)) {
            return null;
        }
        if (!ReflectionUtils.hasNoArgConstructor(cls)) {
            return null;
        }
        while (cls != Object.class) {
            if (ChildCollectionSerializer.superClasses.contains(cls)) {
                if (cls == ArrayList.class) {
                    return ChildArrayListSerializer.class;
                }
                return ChildCollectionSerializer.class;
            }
            if (JavaSerializer.getReadObjectMethod(cls, false) != null || JavaSerializer.getWriteObjectMethod(cls, false) != null) {
                return null;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Class<? extends Serializer> getMapSerializerClass(Class<?> cls) {
        if (ChildMapSerializer.superClasses.contains(cls)) {
            return null;
        }
        if (ClassResolver.useReplaceResolveSerializer(cls)) {
            return null;
        }
        if (!ReflectionUtils.hasNoArgConstructor(cls)) {
            return null;
        }
        while (cls != Object.class) {
            if (ChildMapSerializer.superClasses.contains(cls)) {
                return ChildMapSerializer.class;
            }
            if (JavaSerializer.getReadObjectMethod(cls, false) != null || JavaSerializer.getWriteObjectMethod(cls, false) != null) {
                return null;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    private static <T> Serializer[] buildSlotsSerializers(Fory fory, Set<Class<?>> superClasses, Class<T> cls) {
        Preconditions.checkArgument(!superClasses.contains(cls));
        ArrayList<ObjectSerializer<T>> serializers = new ArrayList<ObjectSerializer<T>>();
        while (!superClasses.contains(cls)) {
            AbstractObjectSerializer slotsSerializer = fory.getConfig().getCompatibleMode() == CompatibleMode.COMPATIBLE ? new CompatibleSerializer<T>(fory, cls, FieldResolver.of(fory, cls, false, false)) : new ObjectSerializer<T>(fory, cls, false);
            serializers.add((ObjectSerializer<T>)slotsSerializer);
            cls = cls.getSuperclass();
        }
        Collections.reverse(serializers);
        return serializers.toArray(new Serializer[0]);
    }

    private static void readAndSetFields(MemoryBuffer buffer, Object collection, Serializer[] slotsSerializers) {
        for (Serializer slotsSerializer : slotsSerializers) {
            if (slotsSerializer.getClass() == CompatibleSerializer.class) {
                ((CompatibleSerializer)slotsSerializer).readAndSetFields(buffer, collection);
                continue;
            }
            ((ObjectSerializer)slotsSerializer).readAndSetFields(buffer, collection);
        }
    }

    public static class ChildCollectionSerializer<T extends Collection>
    extends CollectionSerializer<T> {
        public static Set<Class<?>> superClasses = org.apache.fory.collection.Collections.ofHashSet(ArrayList.class, LinkedList.class, ArrayDeque.class, Vector.class, HashSet.class);
        protected AbstractObjectSerializer.InternalFieldInfo[] fieldInfos;
        protected final Serializer[] slotsSerializers;

        public ChildCollectionSerializer(Fory fory, Class<T> cls) {
            super(fory, cls);
            this.slotsSerializers = ChildContainerSerializers.buildSlotsSerializers(fory, ChildCollectionSerializer.superClasses, cls);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            for (Serializer slotsSerializer : this.slotsSerializers) {
                slotsSerializer.write(buffer, value);
            }
            return value;
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            Collection collection = super.newCollection(buffer);
            ChildContainerSerializers.readAndSetFields(buffer, collection, this.slotsSerializers);
            return collection;
        }

        @Override
        public Collection newCollection(Collection originCollection) {
            Collection newCollection = super.newCollection(originCollection);
            if (this.fieldInfos == null) {
                List<Field> fields = ReflectionUtils.getFieldsWithoutSuperClasses(this.type, superClasses);
                this.fieldInfos = AbstractObjectSerializer.buildFieldsInfo(this.fory, fields);
            }
            AbstractObjectSerializer.copyFields(this.fory, this.fieldInfos, originCollection, newCollection);
            return newCollection;
        }
    }

    public static final class ChildArrayListSerializer<T extends ArrayList>
    extends ChildCollectionSerializer<T> {
        public ChildArrayListSerializer(Fory fory, Class<T> cls) {
            super(fory, cls);
        }

        public T newCollection(MemoryBuffer buffer) {
            ArrayList collection = (ArrayList)super.newCollection(buffer);
            int numElements = this.getAndClearNumElements();
            this.setNumElements(numElements);
            collection.ensureCapacity(numElements);
            return (T)collection;
        }
    }

    public static class ChildMapSerializer<T extends Map>
    extends MapSerializer<T> {
        public static Set<Class<?>> superClasses = org.apache.fory.collection.Collections.ofHashSet(HashMap.class, LinkedHashMap.class, ConcurrentHashMap.class);
        private final Serializer[] slotsSerializers;
        private AbstractObjectSerializer.InternalFieldInfo[] fieldInfos;

        public ChildMapSerializer(Fory fory, Class<T> cls) {
            super(fory, cls);
            this.slotsSerializers = ChildContainerSerializers.buildSlotsSerializers(fory, ChildMapSerializer.superClasses, cls);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            for (Serializer slotsSerializer : this.slotsSerializers) {
                slotsSerializer.write(buffer, value);
            }
            return value;
        }

        @Override
        public Map newMap(MemoryBuffer buffer) {
            Map map = super.newMap(buffer);
            ChildContainerSerializers.readAndSetFields(buffer, map, this.slotsSerializers);
            return map;
        }

        @Override
        public Map newMap(Map originMap) {
            Map newMap = super.newMap(originMap);
            if (this.fieldInfos == null || this.fieldInfos.length == 0) {
                List<Field> fields = ReflectionUtils.getFieldsWithoutSuperClasses(this.type, superClasses);
                this.fieldInfos = AbstractObjectSerializer.buildFieldsInfo(this.fory, fields);
            }
            AbstractObjectSerializer.copyFields(this.fory, this.fieldInfos, originMap, newMap);
            return newMap;
        }
    }
}

