/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.lang.invoke.MethodHandle;
import java.util.Collection;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.CollectionFlags;
import org.apache.fory.serializer.collection.SerializationBinding;
import org.apache.fory.type.GenericType;
import org.apache.fory.util.Preconditions;

public abstract class CollectionLikeSerializer<T>
extends Serializer<T> {
    private MethodHandle constructor;
    private int numElements;
    protected final boolean supportCodegenHook;
    private Serializer<?> elemSerializer;
    protected final ClassInfoHolder elementClassInfoHolder;
    private final TypeResolver typeResolver;
    protected final SerializationBinding binding;

    public CollectionLikeSerializer(Fory fory, Class<T> cls) {
        this(fory, cls, !ReflectionUtils.isDynamicGeneratedCLass(cls));
    }

    public CollectionLikeSerializer(Fory fory, Class<T> cls, boolean supportCodegenHook) {
        super(fory, cls);
        this.supportCodegenHook = supportCodegenHook;
        this.elementClassInfoHolder = fory.getClassResolver().nilClassInfoHolder();
        this.typeResolver = fory.isCrossLanguage() ? fory.getXtypeResolver() : fory.getClassResolver();
        this.binding = SerializationBinding.createBinding(fory);
    }

    public CollectionLikeSerializer(Fory fory, Class<T> cls, boolean supportCodegenHook, boolean immutable) {
        super(fory, cls, immutable);
        this.supportCodegenHook = supportCodegenHook;
        this.elementClassInfoHolder = fory.getClassResolver().nilClassInfoHolder();
        this.typeResolver = fory.isCrossLanguage() ? fory.getXtypeResolver() : fory.getClassResolver();
        this.binding = SerializationBinding.createBinding(fory);
    }

    private GenericType getElementGenericType(Fory fory) {
        GenericType genericType = fory.getGenerics().nextGenericType();
        GenericType elemGenericType = null;
        if (genericType != null) {
            elemGenericType = genericType.getTypeParameter0();
        }
        return elemGenericType;
    }

    public void setElementSerializer(Serializer serializer) {
        this.elemSerializer = serializer;
    }

    public final boolean supportCodegenHook() {
        return this.supportCodegenHook;
    }

    public abstract Collection onCollectionWrite(MemoryBuffer var1, T var2);

    public void onCollectionWriteFinish(Collection map) {
    }

    protected final int writeElementsHeader(MemoryBuffer buffer, Collection value) {
        GenericType elemGenericType = this.getElementGenericType(this.fory);
        if (elemGenericType != null) {
            boolean trackingRef = elemGenericType.trackingRef(this.typeResolver);
            if (elemGenericType.isMonomorphic()) {
                if (trackingRef) {
                    buffer.writeByte(CollectionFlags.DECL_SAME_TYPE_TRACKING_REF);
                    return CollectionFlags.DECL_SAME_TYPE_TRACKING_REF;
                }
                return this.writeNullabilityHeader(buffer, value);
            }
            if (trackingRef) {
                return this.writeTypeHeader(buffer, value, elemGenericType.getCls(), this.elementClassInfoHolder);
            }
            return this.writeTypeNullabilityHeader(buffer, value, elemGenericType.getCls(), this.elementClassInfoHolder);
        }
        if (this.elemSerializer != null) {
            if (this.elemSerializer.needToWriteRef()) {
                buffer.writeByte(CollectionFlags.DECL_SAME_TYPE_TRACKING_REF);
                return CollectionFlags.DECL_SAME_TYPE_TRACKING_REF;
            }
            return this.writeNullabilityHeader(buffer, value);
        }
        if (this.fory.trackingRef()) {
            return this.writeTypeHeader(buffer, value, this.elementClassInfoHolder);
        }
        return this.writeTypeNullabilityHeader(buffer, value, null, this.elementClassInfoHolder);
    }

    public int writeNullabilityHeader(MemoryBuffer buffer, Collection value) {
        for (Object elem : value) {
            if (elem != null) continue;
            buffer.writeByte(CollectionFlags.DECL_SAME_TYPE_HAS_NULL);
            return CollectionFlags.DECL_SAME_TYPE_HAS_NULL;
        }
        buffer.writeByte(CollectionFlags.DECL_SAME_TYPE_NOT_HAS_NULL);
        return CollectionFlags.DECL_SAME_TYPE_NOT_HAS_NULL;
    }

    public int writeTypeHeader(MemoryBuffer buffer, Collection value, Class<?> declareElementType, ClassInfoHolder cache) {
        int bitmap = CollectionFlags.TRACKING_REF;
        boolean hasDifferentClass = false;
        Class<Void> elemClass = null;
        for (Object elem : value) {
            if (elem == null) continue;
            if (elemClass == null) {
                elemClass = elem.getClass();
                continue;
            }
            if (elemClass == elem.getClass()) continue;
            hasDifferentClass = true;
            break;
        }
        if (hasDifferentClass) {
            buffer.writeByte(bitmap);
        } else {
            if (elemClass == null) {
                elemClass = Void.TYPE;
            }
            bitmap |= CollectionFlags.IS_SAME_TYPE;
            if (!this.fory.getConfig().isMetaShareEnabled() && elemClass == declareElementType) {
                buffer.writeByte(bitmap |= CollectionFlags.IS_DECL_ELEMENT_TYPE);
            } else {
                buffer.writeByte(bitmap);
                TypeResolver typeResolver = this.typeResolver;
                typeResolver.writeClassInfo(buffer, typeResolver.getClassInfo(elemClass, cache));
            }
        }
        return bitmap;
    }

    public int writeTypeHeader(MemoryBuffer buffer, Collection value, ClassInfoHolder cache) {
        int bitmap = 0;
        boolean hasDifferentClass = false;
        Class<Object> elemClass = null;
        boolean containsNull = false;
        for (Object elem : value) {
            if (elem == null) {
                containsNull = true;
                continue;
            }
            if (elemClass == null) {
                elemClass = elem.getClass();
                continue;
            }
            if (hasDifferentClass || elem.getClass() == elemClass) continue;
            hasDifferentClass = true;
        }
        if (containsNull) {
            bitmap |= CollectionFlags.HAS_NULL;
        }
        if (hasDifferentClass) {
            buffer.writeByte(bitmap |= CollectionFlags.TRACKING_REF);
        } else {
            TypeResolver typeResolver = this.typeResolver;
            if (elemClass == null) {
                elemClass = Void.TYPE;
            }
            bitmap |= CollectionFlags.IS_SAME_TYPE;
            ClassInfo classInfo = typeResolver.getClassInfo(elemClass, cache);
            if (classInfo.getSerializer().needToWriteRef()) {
                bitmap |= CollectionFlags.TRACKING_REF;
            }
            buffer.writeByte(bitmap);
            typeResolver.writeClassInfo(buffer, classInfo);
        }
        return bitmap;
    }

    public int writeTypeNullabilityHeader(MemoryBuffer buffer, Collection value, Class<?> declareElementType, ClassInfoHolder cache) {
        int bitmap = 0;
        boolean containsNull = false;
        boolean hasDifferentClass = false;
        Class elemClass = null;
        for (Object elem : value) {
            if (elem == null) {
                containsNull = true;
                continue;
            }
            if (elemClass == null) {
                elemClass = elem.getClass();
                continue;
            }
            if (hasDifferentClass || elem.getClass() == elemClass) continue;
            hasDifferentClass = true;
        }
        if (containsNull) {
            bitmap |= CollectionFlags.HAS_NULL;
        }
        if (hasDifferentClass) {
            buffer.writeByte(bitmap);
        } else {
            if (elemClass == null) {
                elemClass = Object.class;
            }
            bitmap |= CollectionFlags.IS_SAME_TYPE;
            if (!this.fory.getConfig().isMetaShareEnabled() && elemClass == declareElementType) {
                buffer.writeByte(bitmap |= CollectionFlags.IS_DECL_ELEMENT_TYPE);
            } else {
                buffer.writeByte(bitmap);
                TypeResolver typeResolver = this.typeResolver;
                ClassInfo classInfo = typeResolver.getClassInfo(elemClass, cache);
                typeResolver.writeClassInfo(buffer, classInfo);
            }
        }
        return bitmap;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Collection collection = this.onCollectionWrite(buffer, value);
        int len = collection.size();
        if (len != 0) {
            this.writeElements(this.fory, buffer, collection);
        }
        this.onCollectionWriteFinish(collection);
    }

    protected final void writeElements(Fory fory, MemoryBuffer buffer, Collection value) {
        int flags = this.writeElementsHeader(buffer, value);
        Serializer<?> serializer = this.elemSerializer;
        this.elemSerializer = null;
        if (serializer == null) {
            GenericType elemGenericType = this.getElementGenericType(fory);
            if (elemGenericType != null) {
                this.javaWriteWithGenerics(fory, buffer, value, elemGenericType, flags);
            } else {
                this.generalJavaWrite(fory, buffer, value, null, flags);
            }
        } else {
            this.compatibleWrite(buffer, value, serializer, flags);
        }
    }

    private <T extends Collection> void compatibleWrite(MemoryBuffer buffer, T value, Serializer serializer, int flags) {
        if (serializer.needToWriteRef()) {
            for (Object elem : value) {
                this.binding.writeRef(buffer, elem, serializer);
            }
        } else {
            boolean hasNull;
            boolean bl = hasNull = (flags & CollectionFlags.HAS_NULL) == CollectionFlags.HAS_NULL;
            if (hasNull) {
                for (Object elem : value) {
                    if (elem == null) {
                        buffer.writeByte((byte)-3);
                        continue;
                    }
                    buffer.writeByte((byte)-1);
                    this.binding.write(buffer, serializer, elem);
                }
            } else {
                for (Object elem : value) {
                    this.binding.write(buffer, serializer, elem);
                }
            }
        }
    }

    private void javaWriteWithGenerics(Fory fory, MemoryBuffer buffer, Collection collection, GenericType elemGenericType, int flags) {
        boolean hasGenericParameters = elemGenericType.hasGenericParameters();
        if (hasGenericParameters) {
            fory.getGenerics().pushGenericType(elemGenericType);
        }
        if (elemGenericType.isMonomorphic()) {
            Serializer serializer = elemGenericType.getSerializer(this.typeResolver);
            this.writeSameTypeElements(fory, buffer, serializer, flags, collection);
        } else {
            this.generalJavaWrite(fory, buffer, collection, elemGenericType, flags);
        }
        if (hasGenericParameters) {
            fory.getGenerics().popGenericType();
        }
    }

    private void generalJavaWrite(Fory fory, MemoryBuffer buffer, Collection collection, GenericType elemGenericType, int flags) {
        if ((flags & CollectionFlags.IS_SAME_TYPE) == CollectionFlags.IS_SAME_TYPE) {
            Serializer serializer;
            if ((flags & CollectionFlags.IS_DECL_ELEMENT_TYPE) == CollectionFlags.IS_DECL_ELEMENT_TYPE) {
                Preconditions.checkNotNull(elemGenericType);
                serializer = elemGenericType.getSerializer(this.typeResolver);
            } else {
                serializer = this.elementClassInfoHolder.getSerializer();
            }
            this.writeSameTypeElements(fory, buffer, serializer, flags, collection);
        } else {
            this.writeDifferentTypeElements(buffer, flags, collection);
        }
    }

    private <T extends Collection> void writeSameTypeElements(Fory fory, MemoryBuffer buffer, Serializer serializer, int flags, T collection) {
        fory.incDepth(1);
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            RefResolver refResolver = fory.getRefResolver();
            for (Object elem : collection) {
                if (refResolver.writeRefOrNull(buffer, elem)) continue;
                this.binding.write(buffer, serializer, elem);
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (Object elem : collection) {
                this.binding.write(buffer, serializer, elem);
            }
        } else {
            for (Object elem : collection) {
                if (elem == null) {
                    buffer.writeByte((byte)-3);
                    continue;
                }
                buffer.writeByte((byte)-1);
                this.binding.write(buffer, serializer, elem);
            }
        }
        fory.incDepth(-1);
    }

    private <T extends Collection> void writeDifferentTypeElements(MemoryBuffer buffer, int flags, T collection) {
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            for (Object elem : collection) {
                this.binding.writeRef(buffer, elem);
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (Object elem : collection) {
                this.binding.writeNonRef(buffer, elem);
            }
        } else {
            for (Object elem : collection) {
                if (elem == null) {
                    buffer.writeByte((byte)-3);
                    continue;
                }
                buffer.writeByte((byte)-1);
                this.binding.writeNonRef(buffer, elem);
            }
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        this.write(buffer, value);
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Collection collection = this.newCollection(buffer);
        int numElements = this.getAndClearNumElements();
        if (numElements != 0) {
            this.readElements(this.fory, buffer, collection, numElements);
        }
        return this.onCollectionRead(collection);
    }

    public Collection newCollection(MemoryBuffer buffer) {
        this.numElements = buffer.readVarUint32Small7();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            Object instance = this.constructor.invoke();
            this.fory.getRefResolver().reference(instance);
            return (Collection)instance;
        }
        catch (Throwable e) {
            throw this.buildException(e);
        }
    }

    public Collection newCollection(Collection collection) {
        this.numElements = collection.size();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            return this.constructor.invoke();
        }
        catch (Throwable e) {
            throw this.buildException(e);
        }
    }

    public void copyElements(Collection originCollection, Collection newCollection) {
        for (Object element : originCollection) {
            ClassInfo classInfo;
            if (element != null && !(classInfo = this.typeResolver.getClassInfo(element.getClass(), this.elementClassInfoHolder)).getSerializer().isImmutable()) {
                element = this.fory.copyObject(element, classInfo.getClassId());
            }
            newCollection.add(element);
        }
    }

    public void copyElements(Collection originCollection, Object[] elements) {
        int index = 0;
        for (Object element : originCollection) {
            ClassInfo classInfo;
            if (element != null && !(classInfo = this.typeResolver.getClassInfo(element.getClass(), this.elementClassInfoHolder)).getSerializer().isImmutable()) {
                element = this.fory.copyObject(element, classInfo.getSerializer());
            }
            elements[index++] = element;
        }
    }

    private RuntimeException buildException(Throwable e) {
        return new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
    }

    public int getAndClearNumElements() {
        int size = this.numElements;
        this.numElements = -1;
        return size;
    }

    protected void setNumElements(int numElements) {
        this.numElements = numElements;
    }

    public abstract T onCollectionRead(Collection var1);

    protected void readElements(Fory fory, MemoryBuffer buffer, Collection collection, int numElements) {
        byte flags = buffer.readByte();
        Serializer<?> serializer = this.elemSerializer;
        this.elemSerializer = null;
        if (serializer == null) {
            GenericType elemGenericType = this.getElementGenericType(fory);
            if (elemGenericType != null) {
                this.javaReadWithGenerics(fory, buffer, collection, numElements, elemGenericType, flags);
            } else {
                this.generalJavaRead(fory, buffer, collection, numElements, flags, null);
            }
        } else {
            this.compatibleRead(fory, buffer, collection, numElements, serializer, flags);
        }
    }

    private void compatibleRead(Fory fory, MemoryBuffer buffer, Collection collection, int numElements, Serializer serializer, int flags) {
        if (serializer.needToWriteRef()) {
            for (int i = 0; i < numElements; ++i) {
                collection.add(this.binding.readRef(buffer, serializer));
            }
        } else if ((flags & CollectionFlags.HAS_NULL) == CollectionFlags.HAS_NULL) {
            for (int i = 0; i < numElements; ++i) {
                if (buffer.readByte() == -3) {
                    collection.add(null);
                    continue;
                }
                Object elem = this.binding.read(buffer, serializer);
                collection.add(elem);
            }
        } else {
            for (int i = 0; i < numElements; ++i) {
                Object elem = this.binding.read(buffer, serializer);
                collection.add(elem);
            }
        }
    }

    private void javaReadWithGenerics(Fory fory, MemoryBuffer buffer, Collection collection, int numElements, GenericType elemGenericType, int flags) {
        boolean hasGenericParameters = elemGenericType.hasGenericParameters();
        if (hasGenericParameters) {
            fory.getGenerics().pushGenericType(elemGenericType);
        }
        if (elemGenericType.isMonomorphic()) {
            Serializer serializer = elemGenericType.getSerializer(this.typeResolver);
            this.readSameTypeElements(fory, buffer, serializer, flags, collection, numElements);
        } else {
            this.generalJavaRead(fory, buffer, collection, numElements, flags, elemGenericType);
        }
        if (hasGenericParameters) {
            fory.getGenerics().popGenericType();
        }
    }

    private void generalJavaRead(Fory fory, MemoryBuffer buffer, Collection collection, int numElements, int flags, GenericType elemGenericType) {
        if ((flags & CollectionFlags.IS_SAME_TYPE) == CollectionFlags.IS_SAME_TYPE) {
            TypeResolver typeResolver = this.typeResolver;
            Serializer serializer = (flags & CollectionFlags.IS_DECL_ELEMENT_TYPE) != CollectionFlags.IS_DECL_ELEMENT_TYPE ? typeResolver.readClassInfo(buffer, this.elementClassInfoHolder).getSerializer() : elemGenericType.getSerializer(typeResolver);
            this.readSameTypeElements(fory, buffer, serializer, flags, collection, numElements);
        } else {
            this.readDifferentTypeElements(fory, buffer, flags, collection, numElements);
        }
    }

    private <T extends Collection> void readSameTypeElements(Fory fory, MemoryBuffer buffer, Serializer serializer, int flags, T collection, int numElements) {
        fory.incReadDepth();
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            for (int i = 0; i < numElements; ++i) {
                collection.add(this.binding.readRef(buffer, serializer));
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (int i = 0; i < numElements; ++i) {
                collection.add((Object)this.binding.read(buffer, serializer));
            }
        } else {
            for (int i = 0; i < numElements; ++i) {
                if (buffer.readByte() == -3) {
                    collection.add(null);
                    continue;
                }
                collection.add((Object)this.binding.read(buffer, serializer));
            }
        }
        fory.decDepth();
    }

    private <T extends Collection> void readDifferentTypeElements(Fory fory, MemoryBuffer buffer, int flags, T collection, int numElements) {
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            for (int i = 0; i < numElements; ++i) {
                collection.add((Object)this.binding.readRef(buffer));
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (int i = 0; i < numElements; ++i) {
                collection.add((Object)this.binding.readNonRef(buffer));
            }
        } else {
            for (int i = 0; i < numElements; ++i) {
                byte headFlag = buffer.readByte();
                if (headFlag == -3) {
                    collection.add(null);
                    continue;
                }
                collection.add((Object)this.binding.readNonRef(buffer));
            }
        }
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        return this.read(buffer);
    }
}

