/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.Collection;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.collection.CollectionLikeSerializer;
import org.apache.fory.util.Preconditions;

public class CollectionSerializer<T extends Collection>
extends CollectionLikeSerializer<T> {
    public CollectionSerializer(Fory fory, Class<T> type) {
        super(fory, type);
    }

    public CollectionSerializer(Fory fory, Class<T> type, boolean supportCodegenHook) {
        super(fory, type, supportCodegenHook);
    }

    public CollectionSerializer(Fory fory, Class<T> type, boolean supportCodegenHook, boolean immutable) {
        super(fory, type, supportCodegenHook, immutable);
    }

    @Override
    public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
        buffer.writeVarUint32Small7(value.size());
        return value;
    }

    @Override
    public T onCollectionRead(Collection collection) {
        return (T)collection;
    }

    @Override
    public T copy(T originCollection) {
        if (this.isImmutable()) {
            return originCollection;
        }
        Preconditions.checkArgument(this.supportCodegenHook);
        Collection newCollection = this.newCollection((Collection)originCollection);
        if (this.needToCopyRef) {
            this.fory.reference(originCollection, newCollection);
        }
        this.copyElements((Collection)originCollection, newCollection);
        return (T)newCollection;
    }
}

