/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.Collection;
import org.apache.fory.Fory;
import org.apache.fory.collection.CollectionSnapshot;
import org.apache.fory.collection.ObjectArray;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.collection.CollectionSerializer;

public class ConcurrentCollectionSerializer<T extends Collection>
extends CollectionSerializer<T> {
    protected final ObjectArray<CollectionSnapshot> snapshots = new ObjectArray(1);

    public ConcurrentCollectionSerializer(Fory fory, Class<T> type, boolean supportCodegen) {
        super(fory, type, supportCodegen);
    }

    @Override
    public CollectionSnapshot onCollectionWrite(MemoryBuffer buffer, T value) {
        CollectionSnapshot snapshot = this.snapshots.popOrNull();
        if (snapshot == null) {
            snapshot = new CollectionSnapshot();
        }
        snapshot.setCollection(value);
        buffer.writeVarUint32Small7(snapshot.size());
        return snapshot;
    }

    @Override
    public void onCollectionWriteFinish(Collection collection) {
        CollectionSnapshot snapshot = (CollectionSnapshot)collection;
        snapshot.clear();
        this.snapshots.add(snapshot);
    }
}

