/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.serializer.Serializer;

interface SerializationBinding {
    public <T> void writeRef(MemoryBuffer var1, T var2);

    public <T> void writeRef(MemoryBuffer var1, T var2, Serializer<T> var3);

    public void writeRef(MemoryBuffer var1, Object var2, ClassInfoHolder var3);

    public void writeNonRef(MemoryBuffer var1, Object var2);

    public void write(MemoryBuffer var1, Serializer var2, Object var3);

    public Object read(MemoryBuffer var1, Serializer var2);

    public <T> T readRef(MemoryBuffer var1, Serializer<T> var2);

    public Object readRef(MemoryBuffer var1, ClassInfoHolder var2);

    public Object readRef(MemoryBuffer var1);

    public Object readNonRef(MemoryBuffer var1);

    public Object readNonRef(MemoryBuffer var1, ClassInfoHolder var2);

    public static SerializationBinding createBinding(Fory fory) {
        if (fory.isCrossLanguage()) {
            return new XlangSerializationBinding(fory);
        }
        return new JavaSerializationBinding(fory);
    }

    public static final class XlangSerializationBinding
    implements SerializationBinding {
        private final Fory fory;

        XlangSerializationBinding(Fory fory) {
            this.fory = fory;
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj) {
            this.fory.xwriteRef(buffer, obj);
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
            this.fory.xwriteRef(buffer, obj, serializer);
        }

        @Override
        public void writeRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            this.fory.xwriteRef(buffer, obj);
        }

        @Override
        public <T> T readRef(MemoryBuffer buffer, Serializer<T> serializer) {
            return (T)this.fory.xreadRef(buffer, serializer);
        }

        @Override
        public Object readRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.xreadRef(buffer);
        }

        @Override
        public Object readRef(MemoryBuffer buffer) {
            return this.fory.xreadRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer) {
            return this.fory.xreadNonRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.xreadNonRef(buffer, classInfoHolder);
        }

        @Override
        public void write(MemoryBuffer buffer, Serializer serializer, Object value) {
            serializer.xwrite(buffer, value);
        }

        @Override
        public Object read(MemoryBuffer buffer, Serializer serializer) {
            return serializer.xread(buffer);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object elem) {
            this.fory.xwriteNonRef(buffer, elem);
        }
    }

    public static final class JavaSerializationBinding
    implements SerializationBinding {
        private final Fory fory;

        JavaSerializationBinding(Fory fory) {
            this.fory = fory;
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj) {
            this.fory.writeRef(buffer, obj);
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
            this.fory.writeRef(buffer, obj, serializer);
        }

        @Override
        public void writeRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            this.fory.writeRef(buffer, obj, classInfoHolder);
        }

        @Override
        public <T> T readRef(MemoryBuffer buffer, Serializer<T> serializer) {
            return this.fory.readRef(buffer, serializer);
        }

        @Override
        public Object readRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.readRef(buffer, classInfoHolder);
        }

        @Override
        public Object readRef(MemoryBuffer buffer) {
            return this.fory.readRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer) {
            return this.fory.readNonRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.readNonRef(buffer, classInfoHolder);
        }

        @Override
        public void write(MemoryBuffer buffer, Serializer serializer, Object value) {
            serializer.write(buffer, value);
        }

        @Override
        public Object read(MemoryBuffer buffer, Serializer serializer) {
            return serializer.read(buffer);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object elem) {
            this.fory.writeNonRef(buffer, elem);
        }
    }
}

