/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.archetype.ArchetypeCreationRequest;
import org.apache.maven.archetype.ArchetypeCreationResult;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.creator.ArchetypeCreator;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

@Component(role=ArchetypeManager.class)
public class DefaultArchetypeManager
extends AbstractLogEnabled
implements ArchetypeManager {
    @Requirement(hint="fileset")
    private ArchetypeCreator creator;
    @Requirement
    private ArchetypeGenerator generator;
    @Requirement(role=ArchetypeDataSource.class)
    private Map<String, ArchetypeDataSource> archetypeSources;

    @Override
    public ArchetypeCreationResult createArchetypeFromProject(ArchetypeCreationRequest request) {
        ArchetypeCreationResult result = new ArchetypeCreationResult();
        this.creator.createArchetype(request, result);
        return result;
    }

    @Override
    public ArchetypeGenerationResult generateProjectFromArchetype(ArchetypeGenerationRequest request) {
        ArchetypeGenerationResult result = new ArchetypeGenerationResult();
        this.generator.generateArchetype(request, result);
        return result;
    }

    @Override
    public File archiveArchetype(File archetypeDirectory, File outputDirectory, String finalName) throws DependencyResolutionRequiredException, IOException {
        File jarFile = new File(outputDirectory, finalName + ".jar");
        this.zip(archetypeDirectory, jarFile);
        return jarFile;
    }

    public void zip(File sourceDirectory, File archive) throws IOException {
        if (!archive.getParentFile().exists()) {
            archive.getParentFile().mkdirs();
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive));){
            zos.setLevel(9);
            this.zipper(zos, sourceDirectory.getAbsolutePath().length(), sourceDirectory);
        }
    }

    private void zipper(ZipOutputStream zos, int offset, File currentSourceDirectory) throws IOException {
        File[] files = currentSourceDirectory.listFiles();
        if (files.length == 0) {
            String dirName = currentSourceDirectory.getAbsolutePath().substring(offset + 1);
            if (File.separatorChar != '/') {
                dirName = dirName.replace('\\', '/');
            }
            zos.putNextEntry(new ZipEntry(dirName + '/'));
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.zipper(zos, offset, files[i]);
                continue;
            }
            String fileName = files[i].getAbsolutePath().substring(offset + 1);
            if (File.separatorChar != '/') {
                fileName = fileName.replace('\\', '/');
            }
            ZipEntry e = new ZipEntry(fileName);
            zos.putNextEntry(e);
            try (FileInputStream is = new FileInputStream(files[i]);){
                IOUtil.copy((InputStream)is, (OutputStream)zos);
            }
            zos.flush();
            zos.closeEntry();
        }
    }

    @Override
    public ArchetypeCatalog getInternalCatalog() {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("internal-catalog");
            return source.getArchetypeCatalog(null);
        }
        catch (ArchetypeDataSourceException e) {
            return new ArchetypeCatalog();
        }
    }

    @Override
    public ArchetypeCatalog getLocalCatalog(ProjectBuildingRequest buildingRequest) {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("catalog");
            return source.getArchetypeCatalog(buildingRequest);
        }
        catch (ArchetypeDataSourceException e) {
            return new ArchetypeCatalog();
        }
    }

    @Override
    public ArchetypeCatalog getRemoteCatalog(ProjectBuildingRequest buildingRequest) {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("remote-catalog");
            return source.getArchetypeCatalog(buildingRequest);
        }
        catch (ArchetypeDataSourceException e) {
            return new ArchetypeCatalog();
        }
    }

    @Override
    public void updateLocalCatalog(ProjectBuildingRequest buildingRequest, Archetype archetype) {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("catalog");
            source.updateCatalog(buildingRequest, archetype);
        }
        catch (ArchetypeDataSourceException archetypeDataSourceException) {
            // empty catch block
        }
    }
}

