/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.common.MavenJDOMWriter;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.common.util.Format;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

@Component(role=PomManager.class)
public class DefaultPomManager
extends AbstractLogEnabled
implements PomManager {
    @Override
    public void addModule(File pom, String artifactId) throws IOException, XmlPullParserException, DocumentException, InvalidPackaging {
        boolean found = false;
        StringWriter writer = new StringWriter();
        try (XmlStreamReader fileReader = ReaderFactory.newXmlReader((File)pom);){
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)fileReader);
            Element project = document.getRootElement();
            String packaging = null;
            Element packagingElement = project.element("packaging");
            if (packagingElement != null) {
                packaging = packagingElement.getStringValue();
            }
            if (!"pom".equals(packaging)) {
                throw new InvalidPackaging("Unable to add module to the current project as it is not of packaging type 'pom'");
            }
            Element modules = project.element("modules");
            if (modules == null) {
                modules = project.addText("  ").addElement("modules");
                modules.setText("\n  ");
                project.addText("\n");
            }
            Iterator i = modules.elementIterator("module");
            while (i.hasNext() && !found) {
                Element module = (Element)i.next();
                if (!module.getText().equals(artifactId)) continue;
                found = true;
            }
            if (!found) {
                Node lastTextNode = null;
                Iterator i2 = modules.nodeIterator();
                while (i2.hasNext()) {
                    Node node = (Node)i2.next();
                    if (node.getNodeType() == 1) {
                        lastTextNode = null;
                        continue;
                    }
                    if (node.getNodeType() != 3) continue;
                    lastTextNode = node;
                }
                if (lastTextNode != null) {
                    modules.remove(lastTextNode);
                }
                modules.addText("\n    ");
                modules.addElement("module").setText(artifactId);
                modules.addText("\n  ");
                XMLWriter xmlWriter = new XMLWriter((Writer)writer);
                xmlWriter.write(document);
                FileUtils.fileWrite((String)pom.getAbsolutePath(), (String)writer.toString());
            }
        }
    }

    @Override
    public void addParent(File pom, File parentPom) throws IOException, XmlPullParserException {
        Model generatedModel = this.readPom(pom);
        if (null != generatedModel.getParent()) {
            this.getLogger().info("Parent element not overwritten in " + pom);
            return;
        }
        Model parentModel = this.readPom(parentPom);
        Parent parent = new Parent();
        parent.setGroupId(parentModel.getGroupId());
        if (parent.getGroupId() == null) {
            parent.setGroupId(parentModel.getParent().getGroupId());
        }
        parent.setArtifactId(parentModel.getArtifactId());
        parent.setVersion(parentModel.getVersion());
        if (parent.getVersion() == null) {
            parent.setVersion(parentModel.getParent().getVersion());
        }
        generatedModel.setParent(parent);
        this.writePom(generatedModel, pom, pom);
    }

    @Override
    public void mergePoms(File pom, File temporaryPom) throws IOException, XmlPullParserException {
        Model model = this.readPom(pom);
        Model generatedModel = this.readPom(temporaryPom);
        model.getProperties().putAll((Map<?, ?>)generatedModel.getProperties());
        this.mergeModelBase((ModelBase)model, (ModelBase)generatedModel);
        this.mergeModelBuild(model, generatedModel);
        this.mergeProfiles(model, generatedModel);
        this.mergeReportPlugins(model, generatedModel);
        this.writePom(model, pom, pom);
    }

    @Override
    public Model readPom(File pomFile) throws IOException, XmlPullParserException {
        try (XmlStreamReader pomReader = ReaderFactory.newXmlReader((File)pomFile);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)pomReader);
            return model;
        }
    }

    @Override
    public Model readPom(InputStream pomStream) throws IOException, XmlPullParserException {
        try (XmlStreamReader pomReader = ReaderFactory.newXmlReader((InputStream)pomStream);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)pomReader);
            return model;
        }
    }

    @Override
    public void writePom(Model model, File pomFile, File initialPomFile) throws IOException {
        org.jdom.Document doc;
        String fileEncoding = StringUtils.isEmpty((String)model.getModelEncoding()) ? "UTF-8" : model.getModelEncoding();
        try (FileInputStream inputStream = new FileInputStream(initialPomFile);){
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)inputStream);
        }
        catch (JDOMException exc) {
            IOException ioe = new IOException("Cannot parse the POM by JDOM while reading " + initialPomFile + ": " + exc.getMessage());
            ioe.initCause(exc);
            throw ioe;
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pomFile), fileEncoding);){
            MavenJDOMWriter writer = new MavenJDOMWriter();
            String ls = System.lineSeparator();
            Format form = Format.getRawFormat().setEncoding(fileEncoding).setLineSeparator(ls);
            writer.write(model, doc, outputStreamWriter, form);
        }
        catch (FileNotFoundException e) {
            this.getLogger().debug("Creating pom file " + pomFile);
            try (OutputStreamWriter pomWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pomFile), fileEncoding);){
                MavenXpp3Writer writer = new MavenXpp3Writer();
                writer.write((Writer)pomWriter, model);
            }
        }
    }

    private Map<String, Dependency> createDependencyMap(List<Dependency> dependencies) {
        HashMap<String, Dependency> dependencyMap = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            dependencyMap.put(dependency.getManagementKey(), dependency);
        }
        return dependencyMap;
    }

    private void mergeModelBuild(Model model, Model generatedModel) {
        if (generatedModel.getBuild() != null) {
            if (model.getBuild() == null) {
                model.setBuild(new Build());
            }
            this.mergeBuildPlugins((BuildBase)model.getBuild(), (BuildBase)generatedModel.getBuild());
        }
    }

    private void mergeProfiles(Model model, Model generatedModel) {
        List generatedProfiles = generatedModel.getProfiles();
        if (generatedProfiles != null && generatedProfiles.size() > 0) {
            ArrayList modelProfiles = model.getProfiles();
            HashMap<String, Profile> modelProfileIdMap = new HashMap<String, Profile>();
            if (modelProfiles == null) {
                modelProfiles = new ArrayList();
                model.setProfiles(modelProfiles);
            } else if (modelProfiles.size() > 0) {
                for (Profile modelProfile : modelProfiles) {
                    modelProfileIdMap.put(modelProfile.getId(), modelProfile);
                }
            }
            for (Profile generatedProfile : generatedProfiles) {
                String generatedProfileId = generatedProfile.getId();
                if (!modelProfileIdMap.containsKey(generatedProfileId)) {
                    model.addProfile(generatedProfile);
                    continue;
                }
                this.getLogger().warn("Try to merge profiles with id " + generatedProfileId);
                this.mergeModelBase((ModelBase)modelProfileIdMap.get(generatedProfileId), (ModelBase)generatedProfile);
                this.mergeProfileBuild((Profile)modelProfileIdMap.get(generatedProfileId), generatedProfile);
            }
        }
    }

    private void mergeProfileBuild(Profile modelProfile, Profile generatedProfile) {
        if (generatedProfile.getBuild() != null) {
            if (modelProfile.getBuild() == null) {
                modelProfile.setBuild((BuildBase)new Build());
            }
            this.mergeBuildPlugins(modelProfile.getBuild(), generatedProfile.getBuild());
        }
    }

    private void mergeModelBase(ModelBase model, ModelBase generatedModel) {
        Map<String, Dependency> dependenciesByIds = this.createDependencyMap(model.getDependencies());
        Map<String, Dependency> generatedDependenciesByIds = this.createDependencyMap(generatedModel.getDependencies());
        for (String generatedDependencyId : generatedDependenciesByIds.keySet()) {
            if (!dependenciesByIds.containsKey(generatedDependencyId)) {
                model.addDependency(generatedDependenciesByIds.get(generatedDependencyId));
            } else {
                this.getLogger().warn("Can not override property: " + generatedDependencyId);
            }
            model.getProperties().putAll((Map<?, ?>)generatedModel.getProperties());
        }
    }

    private void mergeReportPlugins(Model model, Model generatedModel) {
        if (generatedModel.getReporting() != null) {
            if (model.getReporting() == null) {
                model.setReporting(new Reporting());
            }
            Map reportPluginsByIds = model.getReporting().getReportPluginsAsMap();
            Map generatedReportPluginsByIds = generatedModel.getReporting().getReportPluginsAsMap();
            for (String generatedReportPluginsId : generatedReportPluginsByIds.keySet()) {
                if (!reportPluginsByIds.containsKey(generatedReportPluginsId)) {
                    model.getReporting().addPlugin((ReportPlugin)generatedReportPluginsByIds.get(generatedReportPluginsId));
                    continue;
                }
                this.getLogger().warn("Can not override report: " + generatedReportPluginsId);
            }
        }
    }

    private void mergeBuildPlugins(BuildBase modelBuild, BuildBase generatedModelBuild) {
        Map pluginsByIds = modelBuild.getPluginsAsMap();
        List generatedPlugins = generatedModelBuild.getPlugins();
        for (Plugin generatedPlugin : generatedPlugins) {
            String generatedPluginsId = generatedPlugin.getKey();
            if (!pluginsByIds.containsKey(generatedPluginsId)) {
                modelBuild.addPlugin(generatedPlugin);
                continue;
            }
            this.getLogger().info("Try to merge plugin configuration of plugins with id: " + generatedPluginsId);
            Plugin modelPlugin = (Plugin)pluginsByIds.get(generatedPluginsId);
            modelPlugin.setConfiguration((Object)Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)generatedPlugin.getConfiguration()), (Xpp3Dom)((Xpp3Dom)modelPlugin.getConfiguration())));
        }
    }
}

