/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.creator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archetype.ArchetypeCreationRequest;
import org.apache.maven.archetype.ArchetypeCreationResult;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.common.util.FileCharsetDetector;
import org.apache.maven.archetype.common.util.ListScanner;
import org.apache.maven.archetype.common.util.PathUtils;
import org.apache.maven.archetype.creator.ArchetypeCreator;
import org.apache.maven.archetype.exception.TemplateCreationException;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Writer;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ArchetypeCreator.class, hint="fileset")
public class FilesetArchetypeCreator
extends AbstractLogEnabled
implements ArchetypeCreator {
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target" + File.separator + "generated-sources" + File.separator + "archetype";
    @Requirement
    private ArchetypeFilesResolver archetypeFilesResolver;
    @Requirement
    private PomManager pomManager;
    @Requirement
    private Invoker invoker;
    private static final String MAVEN_PROPERTIES = "META-INF/maven/org.apache.maven.archetype/archetype-common/pom.properties";

    @Override
    public void createArchetype(ArchetypeCreationRequest request, ArchetypeCreationResult result) {
        MavenProject project = request.getProject();
        List<String> languages = request.getLanguages();
        List<String> filtereds = request.getFiltereds();
        String defaultEncoding = request.getDefaultEncoding();
        boolean preserveCData = request.isPreserveCData();
        boolean keepParent = request.isKeepParent();
        boolean partialArchetype = request.isPartialArchetype();
        File outputDirectory = request.getOutputDirectory();
        File basedir = project.getBasedir();
        Properties properties = new Properties();
        Properties configurationProperties = new Properties();
        if (request.getProperties() != null) {
            properties.putAll((Map<?, ?>)request.getProperties());
            configurationProperties.putAll((Map<?, ?>)request.getProperties());
        }
        this.extractPropertiesFromProject(project, properties, configurationProperties, request.getPackageName());
        if (outputDirectory == null) {
            this.getLogger().debug("No output directory defined, using default: " + DEFAULT_OUTPUT_DIRECTORY);
            outputDirectory = FileUtils.resolveFile((File)basedir, (String)DEFAULT_OUTPUT_DIRECTORY);
        }
        outputDirectory.mkdirs();
        this.getLogger().debug("Creating archetype in " + outputDirectory);
        try {
            InvocationResult invokerResult;
            String httpsProtocols;
            Object moduleId22;
            File archetypePomFile = this.createArchetypeProjectPom(project, request.getProjectBuildingRequest(), configurationProperties, outputDirectory);
            File archetypeResourcesDirectory = new File(outputDirectory, this.getTemplateOutputDirectory());
            File archetypeFilesDirectory = new File(archetypeResourcesDirectory, "archetype-resources");
            this.getLogger().debug("Archetype's files output directory " + archetypeFilesDirectory);
            File archetypeDescriptorFile = new File(archetypeResourcesDirectory, "META-INF/maven/archetype-metadata.xml");
            archetypeDescriptorFile.getParentFile().mkdirs();
            File archetypePostGenerationScript = new File(archetypeResourcesDirectory, "META-INF/archetype-post-generate.groovy");
            archetypePostGenerationScript.getParentFile().mkdirs();
            if (request.getProject().getBuild() != null && CollectionUtils.isNotEmpty((Collection)request.getProject().getBuild().getResources())) {
                for (Resource resource : request.getProject().getBuild().getResources()) {
                    File inputFile = new File(resource.getDirectory() + File.separator + "META-INF/archetype-post-generate.groovy");
                    if (!inputFile.exists()) continue;
                    FileUtils.copyFile((File)inputFile, (File)archetypePostGenerationScript);
                }
            }
            this.getLogger().debug("Starting archetype's descriptor " + project.getArtifactId());
            ArchetypeDescriptor archetypeDescriptor = new ArchetypeDescriptor();
            archetypeDescriptor.setName(project.getArtifactId());
            archetypeDescriptor.setPartial(partialArchetype);
            this.addRequiredProperties(archetypeDescriptor, properties);
            Properties reverseProperties = this.getReversedProperties(archetypeDescriptor, properties);
            Properties pomReversedProperties = this.getReversedProperties(archetypeDescriptor, properties);
            String packageName = configurationProperties.getProperty("package");
            Model pom = this.pomManager.readPom(project.getFile());
            List<String> excludePatterns = configurationProperties.getProperty("excludePatterns") != null ? Arrays.asList(StringUtils.split((String)configurationProperties.getProperty("excludePatterns"), (String)",")) : Collections.emptyList();
            List<String> fileNames = this.resolveFileNames(pom, basedir, excludePatterns);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Scanned for files " + fileNames.size());
                for (String string : fileNames) {
                    this.getLogger().debug("- " + string);
                }
            }
            List<FileSet> filesets = this.resolveFileSets(packageName, fileNames, languages, filtereds, defaultEncoding);
            this.getLogger().debug("Resolved filesets for " + archetypeDescriptor.getName());
            archetypeDescriptor.setFileSets(filesets);
            this.createArchetypeFiles(reverseProperties, filesets, packageName, basedir, archetypeFilesDirectory, defaultEncoding, excludePatterns);
            this.getLogger().debug("Created files for " + archetypeDescriptor.getName());
            this.setParentArtifactId(reverseProperties, configurationProperties.getProperty("artifactId"));
            for (Object moduleId22 : pom.getModules()) {
                String rootArtifactId = configurationProperties.getProperty("artifactId");
                String moduleIdDirectory = moduleId22;
                if (((String)moduleId22).indexOf(rootArtifactId) >= 0) {
                    moduleIdDirectory = StringUtils.replace((String)moduleId22, (String)rootArtifactId, (String)"__rootArtifactId__");
                }
                this.getLogger().debug("Creating module " + (String)moduleId22);
                ModuleDescriptor moduleDescriptor = this.createModule(reverseProperties, rootArtifactId, (String)moduleId22, packageName, FileUtils.resolveFile((File)basedir, (String)moduleId22), new File(archetypeFilesDirectory, moduleIdDirectory), languages, filtereds, defaultEncoding, preserveCData, keepParent);
                archetypeDescriptor.addModule(moduleDescriptor);
                this.getLogger().debug("Added module " + moduleDescriptor.getName() + " in " + archetypeDescriptor.getName());
            }
            this.restoreParentArtifactId(reverseProperties, null);
            this.restoreArtifactId(reverseProperties, configurationProperties.getProperty("artifactId"));
            this.createPoms(pom, configurationProperties.getProperty("artifactId"), configurationProperties.getProperty("artifactId"), archetypeFilesDirectory, basedir, project.getFile(), pomReversedProperties, preserveCData, keepParent);
            this.getLogger().debug("Created Archetype " + archetypeDescriptor.getName() + " template pom(s)");
            XmlStreamWriter xmlStreamWriter = WriterFactory.newXmlWriter((File)archetypeDescriptorFile);
            moduleId22 = null;
            try {
                ArchetypeDescriptorXpp3Writer writer = new ArchetypeDescriptorXpp3Writer();
                writer.write((Writer)xmlStreamWriter, archetypeDescriptor);
                this.getLogger().debug("Archetype " + archetypeDescriptor.getName() + " descriptor written");
            }
            catch (Throwable writer) {
                moduleId22 = writer;
                throw writer;
            }
            finally {
                if (xmlStreamWriter != null) {
                    if (moduleId22 != null) {
                        try {
                            xmlStreamWriter.close();
                        }
                        catch (Throwable writer) {
                            ((Throwable)moduleId22).addSuppressed(writer);
                        }
                    } else {
                        xmlStreamWriter.close();
                    }
                }
            }
            this.createArchetypeBasicIt(archetypeDescriptor, outputDirectory);
            File file = new File(basedir, "src" + File.separator + "it" + File.separator + "projects");
            File archetypeIntegrationTestOutputFolder = new File(outputDirectory, "src" + File.separator + "test" + File.separator + "resources" + File.separator + "projects");
            if (file.exists()) {
                this.getLogger().info("Copying: " + file.getAbsolutePath() + " into " + archetypeIntegrationTestOutputFolder.getAbsolutePath());
                FileUtils.copyDirectoryStructure((File)file, (File)archetypeIntegrationTestOutputFolder);
            }
            DefaultInvocationRequest internalRequest = new DefaultInvocationRequest();
            internalRequest.setPomFile(archetypePomFile);
            internalRequest.setUserSettingsFile(request.getSettingsFile());
            internalRequest.setGoals(Collections.singletonList(request.getPostPhase()));
            if (request.getLocalRepository() != null) {
                internalRequest.setLocalRepositoryDirectory(new File(request.getLocalRepository().getBasedir()));
            }
            if ((httpsProtocols = System.getProperty("https.protocols")) != null) {
                Properties userProperties = new Properties();
                userProperties.setProperty("https.protocols", httpsProtocols);
                internalRequest.setProperties(userProperties);
            }
            if ((invokerResult = this.invoker.execute((InvocationRequest)internalRequest)).getExitCode() != 0) {
                if (invokerResult.getExecutionException() != null) {
                    throw invokerResult.getExecutionException();
                }
                throw new Exception("Invoker process ended with result different than 0!");
            }
        }
        catch (Exception e) {
            result.setCause(e);
        }
    }

    private void createArchetypeBasicIt(ArchetypeDescriptor archetypeDescriptor, File generatedSourcesDirectory) throws IOException {
        String basic = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "projects" + File.separator + "basic";
        File basicItDirectory = new File(generatedSourcesDirectory, basic);
        basicItDirectory.mkdirs();
        try (InputStream in = FilesetArchetypeCreator.class.getResourceAsStream("archetype.properties");
             FileOutputStream out = new FileOutputStream(new File(basicItDirectory, "archetype.properties"));){
            Properties archetypeProperties = new Properties();
            archetypeProperties.load(in);
            for (RequiredProperty req : archetypeDescriptor.getRequiredProperties()) {
                archetypeProperties.put(req.getKey(), req.getDefaultValue());
            }
            archetypeProperties.store(out, null);
        }
        this.copyResource("goal.txt", new File(basicItDirectory, "goal.txt"));
        this.getLogger().debug("Added basic integration test");
    }

    private void extractPropertiesFromProject(MavenProject project, Properties properties, Properties configurationProperties, String packageName) {
        if (!properties.containsKey("groupId")) {
            properties.setProperty("groupId", project.getGroupId());
        }
        configurationProperties.setProperty("groupId", properties.getProperty("groupId"));
        if (!properties.containsKey("artifactId")) {
            properties.setProperty("artifactId", project.getArtifactId());
        }
        configurationProperties.setProperty("artifactId", properties.getProperty("artifactId"));
        if (!properties.containsKey("version")) {
            properties.setProperty("version", project.getVersion());
        }
        configurationProperties.setProperty("version", properties.getProperty("version"));
        if (packageName != null) {
            properties.setProperty("package", packageName);
        } else if (!properties.containsKey("package")) {
            properties.setProperty("package", project.getGroupId());
        }
        configurationProperties.setProperty("package", properties.getProperty("package"));
    }

    private File createArchetypeProjectPom(MavenProject project, ProjectBuildingRequest buildingRequest, Properties configurationProperties, File projectDir) throws TemplateCreationException, IOException {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(configurationProperties.getProperty("archetype.groupId", project.getGroupId()));
        model.setArtifactId(configurationProperties.getProperty("archetype.artifactId", project.getArtifactId()));
        model.setVersion(configurationProperties.getProperty("archetype.version", project.getVersion()));
        model.setPackaging("maven-archetype");
        model.setName(configurationProperties.getProperty("archetype.artifactId", project.getArtifactId()));
        model.setUrl(configurationProperties.getProperty("archetype.url", project.getUrl()));
        model.setDescription(configurationProperties.getProperty("archetype.description", project.getDescription()));
        model.setLicenses(project.getLicenses());
        model.setDevelopers(project.getDevelopers());
        model.setScm(project.getScm());
        Build build = new Build();
        model.setBuild(build);
        if (project.getParent() != null) {
            MavenProject p = project.getParent();
            if (p.getDistributionManagement() != null) {
                model.setDistributionManagement(p.getDistributionManagement());
            }
            if (p.getBuildExtensions() != null) {
                for (Extension be : p.getBuildExtensions()) {
                    model.getBuild().addExtension(be);
                }
            }
        }
        Extension extension = new Extension();
        extension.setGroupId("org.apache.maven.archetype");
        extension.setArtifactId("archetype-packaging");
        extension.setVersion(this.getArchetypeVersion());
        model.getBuild().addExtension(extension);
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-archetype-plugin");
        plugin.setVersion(this.getArchetypeVersion());
        PluginManagement pluginManagement = new PluginManagement();
        pluginManagement.addPlugin(plugin);
        model.getBuild().setPluginManagement(pluginManagement);
        this.getLogger().debug("Creating archetype's pom");
        File archetypePomFile = new File(projectDir, "pom.xml");
        archetypePomFile.getParentFile().mkdirs();
        this.copyResource("pom-prototype.xml", archetypePomFile);
        this.pomManager.writePom(model, archetypePomFile, archetypePomFile);
        return archetypePomFile;
    }

    private void copyResource(String name, File destination) throws IOException {
        try (InputStream in = FilesetArchetypeCreator.class.getResourceAsStream(name);
             FileOutputStream out = new FileOutputStream(destination);){
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
    }

    private void addRequiredProperties(ArchetypeDescriptor archetypeDescriptor, Properties properties) {
        Properties requiredProperties = new Properties();
        requiredProperties.putAll((Map<?, ?>)properties);
        requiredProperties.remove("archetype.groupId");
        requiredProperties.remove("archetype.artifactId");
        requiredProperties.remove("archetype.version");
        requiredProperties.remove("groupId");
        requiredProperties.remove("artifactId");
        requiredProperties.remove("version");
        requiredProperties.remove("package");
        requiredProperties.remove("excludePatterns");
        for (String string : requiredProperties.keySet()) {
            RequiredProperty requiredProperty = new RequiredProperty();
            requiredProperty.setKey(string);
            requiredProperty.setDefaultValue(requiredProperties.getProperty(string));
            archetypeDescriptor.addRequiredProperty(requiredProperty);
            this.getLogger().debug("Adding requiredProperty " + string + "=" + requiredProperties.getProperty(string) + " to archetype's descriptor");
        }
    }

    private void createModulePoms(Properties pomReversedProperties, String rootArtifactId, String packageName, File basedir, File archetypeFilesDirectory, boolean preserveCData, boolean keepParent) throws FileNotFoundException, IOException, XmlPullParserException {
        Model pom = this.pomManager.readPom(FileUtils.resolveFile((File)basedir, (String)"pom.xml"));
        String parentArtifactId = pomReversedProperties.getProperty("parentArtifactId");
        String artifactId = pom.getArtifactId();
        this.setParentArtifactId(pomReversedProperties, pomReversedProperties.getProperty("artifactId"));
        this.setArtifactId(pomReversedProperties, pom.getArtifactId());
        Iterator iterator = pom.getModules().iterator();
        while (iterator.hasNext()) {
            String subModuleId;
            String subModuleIdDirectory = subModuleId = (String)iterator.next();
            if (subModuleId.indexOf(rootArtifactId) >= 0) {
                subModuleIdDirectory = StringUtils.replace((String)subModuleId, (String)rootArtifactId, (String)"__rootArtifactId__");
            }
            this.createModulePoms(pomReversedProperties, rootArtifactId, packageName, FileUtils.resolveFile((File)basedir, (String)subModuleId), FileUtils.resolveFile((File)archetypeFilesDirectory, (String)subModuleIdDirectory), preserveCData, keepParent);
        }
        this.createModulePom(pom, rootArtifactId, archetypeFilesDirectory, pomReversedProperties, FileUtils.resolveFile((File)basedir, (String)"pom.xml"), preserveCData, keepParent);
        this.restoreParentArtifactId(pomReversedProperties, parentArtifactId);
        this.restoreArtifactId(pomReversedProperties, artifactId);
    }

    private void createPoms(Model pom, String rootArtifactId, String artifactId, File archetypeFilesDirectory, File basedir, File rootPom, Properties pomReversedProperties, boolean preserveCData, boolean keepParent) throws IOException, FileNotFoundException, XmlPullParserException {
        this.setArtifactId(pomReversedProperties, pom.getArtifactId());
        Iterator iterator = pom.getModules().iterator();
        while (iterator.hasNext()) {
            String moduleId;
            String moduleIdDirectory = moduleId = (String)iterator.next();
            if (moduleId.indexOf(rootArtifactId) >= 0) {
                moduleIdDirectory = StringUtils.replace((String)moduleId, (String)rootArtifactId, (String)"__rootArtifactId__");
            }
            this.createModulePoms(pomReversedProperties, rootArtifactId, moduleId, FileUtils.resolveFile((File)basedir, (String)moduleId), new File(archetypeFilesDirectory, moduleIdDirectory), preserveCData, keepParent);
        }
        this.restoreParentArtifactId(pomReversedProperties, null);
        this.restoreArtifactId(pomReversedProperties, artifactId);
        this.createArchetypePom(pom, archetypeFilesDirectory, pomReversedProperties, rootPom, preserveCData, keepParent);
    }

    private String getPackageInPathFormat(String aPackage) {
        return StringUtils.replace((String)aPackage, (String)".", (String)"/");
    }

    private void rewriteReferences(Model pom, String rootArtifactId, String groupId) {
        if (pom.getDependencies() != null && !pom.getDependencies().isEmpty()) {
            for (Dependency dependency : pom.getDependencies()) {
                this.rewriteDependencyReferences(dependency, rootArtifactId, groupId);
            }
        }
        if (pom.getDependencyManagement() != null && pom.getDependencyManagement().getDependencies() != null && !pom.getDependencyManagement().getDependencies().isEmpty()) {
            for (Dependency dependency : pom.getDependencyManagement().getDependencies()) {
                this.rewriteDependencyReferences(dependency, rootArtifactId, groupId);
            }
        }
        if (pom.getBuild() != null && pom.getBuild().getPlugins() != null && !pom.getBuild().getPlugins().isEmpty()) {
            for (Plugin plugin : pom.getBuild().getPlugins()) {
                this.rewritePluginReferences(plugin, rootArtifactId, groupId);
            }
        }
        if (pom.getBuild() != null && pom.getBuild().getPluginManagement() != null && pom.getBuild().getPluginManagement().getPlugins() != null && !pom.getBuild().getPluginManagement().getPlugins().isEmpty()) {
            for (Plugin plugin : pom.getBuild().getPluginManagement().getPlugins()) {
                this.rewritePluginReferences(plugin, rootArtifactId, groupId);
            }
        }
        if (pom.getProfiles() != null) {
            for (Profile profile : pom.getProfiles()) {
                if (profile.getDependencies() != null && !profile.getDependencies().isEmpty()) {
                    for (Dependency dependency : profile.getDependencies()) {
                        this.rewriteDependencyReferences(dependency, rootArtifactId, groupId);
                    }
                }
                if (profile.getDependencyManagement() != null && profile.getDependencyManagement().getDependencies() != null && !profile.getDependencyManagement().getDependencies().isEmpty()) {
                    for (Dependency dependency : profile.getDependencyManagement().getDependencies()) {
                        this.rewriteDependencyReferences(dependency, rootArtifactId, groupId);
                    }
                }
                if (profile.getBuild() != null && profile.getBuild().getPlugins() != null && !profile.getBuild().getPlugins().isEmpty()) {
                    for (Plugin plugin : profile.getBuild().getPlugins()) {
                        this.rewritePluginReferences(plugin, rootArtifactId, groupId);
                    }
                }
                if (profile.getBuild() == null || profile.getBuild().getPluginManagement() == null || profile.getBuild().getPluginManagement().getPlugins() == null || profile.getBuild().getPluginManagement().getPlugins().isEmpty()) continue;
                for (Plugin plugin : profile.getBuild().getPluginManagement().getPlugins()) {
                    this.rewritePluginReferences(plugin, rootArtifactId, groupId);
                }
            }
        }
    }

    private void rewriteDependencyReferences(Dependency dependency, String rootArtifactId, String groupId) {
        if (dependency.getArtifactId() != null && dependency.getArtifactId().indexOf(rootArtifactId) >= 0) {
            if (dependency.getGroupId() != null) {
                dependency.setGroupId(StringUtils.replace((String)dependency.getGroupId(), (String)groupId, (String)"${groupId}"));
            }
            dependency.setArtifactId(StringUtils.replace((String)dependency.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
            if (dependency.getVersion() != null) {
                dependency.setVersion("${version}");
            }
        }
    }

    private void rewritePluginReferences(Plugin plugin, String rootArtifactId, String groupId) {
        if (plugin.getArtifactId() != null && plugin.getArtifactId().indexOf(rootArtifactId) >= 0) {
            if (plugin.getGroupId() != null) {
                String g = StringUtils.replace((String)plugin.getGroupId(), (String)groupId, (String)"${groupId}");
                plugin.setGroupId(g);
            }
            plugin.setArtifactId(StringUtils.replace((String)plugin.getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
            if (plugin.getVersion() != null) {
                plugin.setVersion("${version}");
            }
        }
        if (plugin.getArtifactId() != null && "maven-ear-plugin".equals(plugin.getArtifactId())) {
            this.rewriteEARPluginReferences(plugin, rootArtifactId, groupId);
        }
    }

    private void rewriteEARPluginReferences(Plugin plugin, String rootArtifactId, String groupId) {
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration != null) {
            Xpp3Dom[] modules = configuration.getChild("modules").getChildren();
            for (int i = 0; i < modules.length; ++i) {
                Xpp3Dom module = modules[i];
                Xpp3Dom moduleGroupId = module.getChild("groupId");
                Xpp3Dom moduleArtifactId = module.getChild("artifactId");
                Xpp3Dom moduleBundleFileName = module.getChild("bundleFileName");
                Xpp3Dom moduleModuleId = module.getChild("moduleId");
                Xpp3Dom moduleContextRoot = module.getChild("contextRoot");
                if (moduleGroupId != null) {
                    moduleGroupId.setValue(StringUtils.replace((String)moduleGroupId.getValue(), (String)groupId, (String)"${groupId}"));
                }
                if (moduleArtifactId != null) {
                    moduleArtifactId.setValue(StringUtils.replace((String)moduleArtifactId.getValue(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                }
                if (moduleBundleFileName != null) {
                    moduleBundleFileName.setValue(StringUtils.replace((String)moduleBundleFileName.getValue(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                }
                if (moduleModuleId != null) {
                    moduleModuleId.setValue(StringUtils.replace((String)moduleModuleId.getValue(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                }
                if (moduleContextRoot == null) continue;
                moduleContextRoot.setValue(StringUtils.replace((String)moduleContextRoot.getValue(), (String)rootArtifactId, (String)"${rootArtifactId}"));
            }
        }
    }

    private void setArtifactId(Properties properties, String artifactId) {
        properties.setProperty("artifactId", artifactId);
    }

    private List<String> concatenateToList(List<String> toConcatenate, String with) {
        ArrayList<String> result = new ArrayList<String>(toConcatenate.size());
        for (String concatenate : toConcatenate) {
            result.add(with.length() > 0 ? with + "/" + concatenate : concatenate);
        }
        return result;
    }

    private List<String> addLists(List<String> list, List<String> other) {
        ArrayList<String> result = new ArrayList<String>(list.size() + other.size());
        result.addAll(list);
        result.addAll(other);
        return result;
    }

    private void copyFiles(File basedir, File archetypeFilesDirectory, String directory, List<String> fileSetResources, boolean packaged, String packageName, Properties reverseProperties) throws IOException {
        String packageAsDirectory = StringUtils.replace((String)packageName, (String)".", (String)File.separator);
        this.getLogger().debug("Package as Directory: Package:" + packageName + "->" + packageAsDirectory);
        for (String inputFileName : fileSetResources) {
            String outputFileName = packaged ? StringUtils.replace((String)inputFileName, (String)(packageAsDirectory + File.separator), (String)"") : inputFileName;
            this.getLogger().debug("InputFileName:" + inputFileName);
            this.getLogger().debug("OutputFileName:" + outputFileName);
            reverseProperties.remove("archetype.languages");
            String reversedOutputFilename = this.getReversedFilename(outputFileName, reverseProperties);
            File outputFile = new File(archetypeFilesDirectory, reversedOutputFilename);
            File inputFile = new File(basedir, inputFileName);
            outputFile.getParentFile().mkdirs();
            FileUtils.copyFile((File)inputFile, (File)outputFile);
        }
    }

    private void createArchetypeFiles(Properties reverseProperties, List<FileSet> fileSets, String packageName, File basedir, File archetypeFilesDirectory, String defaultEncoding, List<String> excludePatterns) throws IOException {
        this.getLogger().debug("Creating Archetype/Module files from " + basedir + " to " + archetypeFilesDirectory);
        for (FileSet fileSet : fileSets) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(basedir);
            scanner.setIncludes(this.concatenateToList(fileSet.getIncludes(), fileSet.getDirectory()).toArray(new String[fileSet.getIncludes().size()]));
            scanner.setExcludes(this.addLists(fileSet.getExcludes(), excludePatterns).toArray(new String[fileSet.getExcludes().size()]));
            scanner.addDefaultExcludes();
            this.getLogger().debug("Using fileset " + fileSet);
            scanner.scan();
            List<String> fileSetResources = Arrays.asList(scanner.getIncludedFiles());
            this.getLogger().debug("Scanned " + fileSetResources.size() + " resources");
            if (fileSet.isFiltered()) {
                this.processFileSet(basedir, archetypeFilesDirectory, fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, reverseProperties, defaultEncoding);
                this.getLogger().debug("Processed " + fileSet.getDirectory() + " files");
                continue;
            }
            this.copyFiles(basedir, archetypeFilesDirectory, fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, reverseProperties);
            this.getLogger().debug("Copied " + fileSet.getDirectory() + " files");
        }
    }

    private void createArchetypePom(Model pom, File archetypeFilesDirectory, Properties pomReversedProperties, File initialPomFile, boolean preserveCData, boolean keepParent) throws IOException {
        File outputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml");
        if (preserveCData) {
            this.getLogger().debug("Preserving CDATA parts of pom");
            File inputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml.tmp");
            FileUtils.copyFile((File)initialPomFile, (File)inputFile);
            try (XmlStreamReader in = ReaderFactory.newXmlReader((File)inputFile);){
                Throwable throwable = null;
                try (XmlStreamWriter out = WriterFactory.newXmlWriter((File)outputFile);){
                    String initialcontent = IOUtil.toString((Reader)in);
                    String content = this.getReversedContent(initialcontent, pomReversedProperties);
                    outputFile.getParentFile().mkdirs();
                    IOUtil.copy((String)content, (Writer)out);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            inputFile.delete();
        } else {
            if (!keepParent) {
                pom.setParent(null);
            }
            pom.setModules(null);
            pom.setGroupId("${groupId}");
            pom.setArtifactId("${artifactId}");
            pom.setVersion("${version}");
            pom.setName(this.getReversedPlainContent(pom.getName(), pomReversedProperties));
            pom.setDescription(this.getReversedPlainContent(pom.getDescription(), pomReversedProperties));
            pom.setUrl(this.getReversedPlainContent(pom.getUrl(), pomReversedProperties));
            this.rewriteReferences(pom, pomReversedProperties.getProperty("artifactId"), pomReversedProperties.getProperty("groupId"));
            this.pomManager.writePom(pom, outputFile, initialPomFile);
        }
        try (XmlStreamReader in = ReaderFactory.newXmlReader((File)initialPomFile);){
            String initialcontent = IOUtil.toString((Reader)in);
            for (String string : pomReversedProperties.keySet()) {
                if (initialcontent.indexOf("${" + string + "}") <= 0) continue;
                this.getLogger().warn("Archetype uses ${" + string + "} for internal processing, but file " + initialPomFile + " contains this property already");
            }
        }
    }

    private FileSet createFileSet(List<String> excludes, boolean packaged, boolean filtered, String group, List<String> includes, String defaultEncoding) {
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(group);
        fileSet.setPackaged(packaged);
        fileSet.setFiltered(filtered);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setEncoding(defaultEncoding);
        this.getLogger().debug("Created Fileset " + fileSet);
        return fileSet;
    }

    private List<FileSet> createFileSets(List<String> files, int level, boolean packaged, String packageName, boolean filtered, String defaultEncoding) {
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        if (!files.isEmpty()) {
            this.getLogger().debug("Creating filesets" + (packaged ? " packaged (" + packageName + ")" : "") + (filtered ? " filtered" : "") + " at level " + level);
            if (level == 0) {
                ArrayList<String> includes = new ArrayList<String>(files);
                ArrayList<String> excludes = new ArrayList<String>();
                if (!includes.isEmpty()) {
                    fileSets.add(this.createFileSet(excludes, packaged, filtered, "", includes, defaultEncoding));
                }
            } else {
                Map<String, List<String>> groups = this.getGroupsMap(files, level);
                for (String group : groups.keySet()) {
                    this.getLogger().debug("Creating filesets for group " + group);
                    if (!packaged) {
                        fileSets.add(this.getUnpackagedFileSet(filtered, group, groups.get(group), defaultEncoding));
                        continue;
                    }
                    fileSets.addAll(this.getPackagedFileSets(filtered, group, groups.get(group), packageName, defaultEncoding));
                }
            }
            this.getLogger().debug("Resolved fileSets " + fileSets);
        }
        return fileSets;
    }

    private ModuleDescriptor createModule(Properties reverseProperties, String rootArtifactId, String moduleId, String packageName, File basedir, File archetypeFilesDirectory, List<String> languages, List<String> filtereds, String defaultEncoding, boolean preserveCData, boolean keepParent) throws IOException, XmlPullParserException {
        ModuleDescriptor archetypeDescriptor = new ModuleDescriptor();
        this.getLogger().debug("Starting module's descriptor " + moduleId);
        archetypeFilesDirectory.mkdirs();
        this.getLogger().debug("Module's files output directory " + archetypeFilesDirectory);
        Model pom = this.pomManager.readPom(FileUtils.resolveFile((File)basedir, (String)"pom.xml"));
        String replacementId = pom.getArtifactId();
        String moduleDirectory = pom.getArtifactId();
        if (replacementId.indexOf(rootArtifactId) >= 0) {
            replacementId = StringUtils.replace((String)replacementId, (String)rootArtifactId, (String)"${rootArtifactId}");
            moduleDirectory = StringUtils.replace((String)moduleId, (String)rootArtifactId, (String)"__rootArtifactId__");
        }
        if (moduleId.indexOf(rootArtifactId) >= 0) {
            moduleDirectory = StringUtils.replace((String)moduleId, (String)rootArtifactId, (String)"__rootArtifactId__");
        }
        archetypeDescriptor.setName(replacementId);
        archetypeDescriptor.setId(replacementId);
        archetypeDescriptor.setDir(moduleDirectory);
        this.setArtifactId(reverseProperties, pom.getArtifactId());
        List<String> excludePatterns = reverseProperties.getProperty("excludePatterns") != null ? Arrays.asList(StringUtils.split((String)reverseProperties.getProperty("excludePatterns"), (String)",")) : Collections.emptyList();
        List<String> fileNames = this.resolveFileNames(pom, basedir, excludePatterns);
        List<FileSet> filesets = this.resolveFileSets(packageName, fileNames, languages, filtereds, defaultEncoding);
        this.getLogger().debug("Resolved filesets for module " + archetypeDescriptor.getName());
        archetypeDescriptor.setFileSets(filesets);
        this.createArchetypeFiles(reverseProperties, filesets, packageName, basedir, archetypeFilesDirectory, defaultEncoding, excludePatterns);
        this.getLogger().debug("Created files for module " + archetypeDescriptor.getName());
        String parentArtifactId = reverseProperties.getProperty("parentArtifactId");
        this.setParentArtifactId(reverseProperties, pom.getArtifactId());
        Iterator iterator = pom.getModules().iterator();
        while (iterator.hasNext()) {
            String subModuleId;
            String subModuleIdDirectory = subModuleId = (String)iterator.next();
            if (subModuleId.indexOf(rootArtifactId) >= 0) {
                subModuleIdDirectory = StringUtils.replace((String)subModuleId, (String)rootArtifactId, (String)"__rootArtifactId__");
            }
            this.getLogger().debug("Creating module " + subModuleId);
            ModuleDescriptor moduleDescriptor = this.createModule(reverseProperties, rootArtifactId, subModuleId, packageName, FileUtils.resolveFile((File)basedir, (String)subModuleId), FileUtils.resolveFile((File)archetypeFilesDirectory, (String)subModuleIdDirectory), languages, filtereds, defaultEncoding, preserveCData, keepParent);
            archetypeDescriptor.addModule(moduleDescriptor);
            this.getLogger().debug("Added module " + moduleDescriptor.getName() + " in " + archetypeDescriptor.getName());
        }
        this.restoreParentArtifactId(reverseProperties, parentArtifactId);
        this.restoreArtifactId(reverseProperties, pom.getArtifactId());
        this.getLogger().debug("Created Module " + archetypeDescriptor.getName() + " pom");
        return archetypeDescriptor;
    }

    private void createModulePom(Model pom, String rootArtifactId, File archetypeFilesDirectory, Properties pomReversedProperties, File initialPomFile, boolean preserveCData, boolean keepParent) throws IOException {
        File outputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml");
        if (preserveCData) {
            this.getLogger().debug("Preserving CDATA parts of pom");
            File inputFile = FileUtils.resolveFile((File)archetypeFilesDirectory, (String)"pom.xml.tmp");
            FileUtils.copyFile((File)initialPomFile, (File)inputFile);
            try (XmlStreamReader in = ReaderFactory.newXmlReader((File)inputFile);){
                Throwable throwable = null;
                try (XmlStreamWriter out = WriterFactory.newXmlWriter((File)outputFile);){
                    String initialcontent = IOUtil.toString((Reader)in);
                    String content = this.getReversedContent(initialcontent, pomReversedProperties);
                    outputFile.getParentFile().mkdirs();
                    IOUtil.copy((String)content, (Writer)out);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            inputFile.delete();
        } else {
            if (pom.getParent() != null) {
                pom.getParent().setGroupId(StringUtils.replace((String)pom.getParent().getGroupId(), (String)pomReversedProperties.getProperty("groupId"), (String)"${groupId}"));
                if (pom.getParent().getArtifactId() != null && pom.getParent().getArtifactId().indexOf(rootArtifactId) >= 0) {
                    pom.getParent().setArtifactId(StringUtils.replace((String)pom.getParent().getArtifactId(), (String)rootArtifactId, (String)"${rootArtifactId}"));
                }
                if (pom.getParent().getVersion() != null) {
                    pom.getParent().setVersion("${version}");
                }
            }
            pom.setModules(null);
            if (pom.getGroupId() != null) {
                pom.setGroupId(StringUtils.replace((String)pom.getGroupId(), (String)pomReversedProperties.getProperty("groupId"), (String)"${groupId}"));
            }
            pom.setArtifactId("${artifactId}");
            if (pom.getVersion() != null) {
                pom.setVersion("${version}");
            }
            pom.setName(this.getReversedPlainContent(pom.getName(), pomReversedProperties));
            pom.setDescription(this.getReversedPlainContent(pom.getDescription(), pomReversedProperties));
            pom.setUrl(this.getReversedPlainContent(pom.getUrl(), pomReversedProperties));
            this.rewriteReferences(pom, rootArtifactId, pomReversedProperties.getProperty("groupId"));
            this.pomManager.writePom(pom, outputFile, initialPomFile);
        }
        try (XmlStreamReader in = ReaderFactory.newXmlReader((File)initialPomFile);){
            String initialcontent = IOUtil.toString((Reader)in);
            for (String string : pomReversedProperties.keySet()) {
                if (initialcontent.indexOf("${" + string + "}") <= 0) continue;
                this.getLogger().warn("OldArchetype uses ${" + string + "} for internal processing, but file " + initialPomFile + " contains this property already");
            }
        }
    }

    private Set<String> getExtensions(List<String> files) {
        HashSet<String> extensions = new HashSet<String>();
        for (String file : files) {
            extensions.add(FileUtils.extension((String)file));
        }
        return extensions;
    }

    private Map<String, List<String>> getGroupsMap(List<String> files, int level) {
        HashMap<String, List<String>> groups = new HashMap<String, List<String>>();
        for (String file : files) {
            String directory = PathUtils.getDirectory(file, level);
            if (!groups.containsKey(directory = StringUtils.replace((String)directory, (String)File.separator, (String)"/"))) {
                groups.put(directory, new ArrayList());
            }
            List group = (List)groups.get(directory);
            String innerPath = file.substring(directory.length() + 1);
            innerPath = StringUtils.replace((String)innerPath, (String)File.separator, (String)"/");
            group.add(innerPath);
        }
        this.getLogger().debug("Sorted " + groups.size() + " groups in " + files.size() + " files");
        this.getLogger().debug("Sorted Files: " + files);
        return groups;
    }

    private FileSet getPackagedFileSet(boolean filtered, Set<String> packagedExtensions, String group, Set<String> unpackagedExtensions, List<String> unpackagedFiles, String defaultEncoding) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String extension : packagedExtensions) {
            includes.add("**/*." + extension);
            if (!unpackagedExtensions.contains(extension)) continue;
            excludes.addAll(this.archetypeFilesResolver.getFilesWithExtension(unpackagedFiles, extension));
        }
        return this.createFileSet(excludes, true, filtered, group, includes, defaultEncoding);
    }

    private List<FileSet> getPackagedFileSets(boolean filtered, String group, List<String> groupFiles, String packageName, String defaultEncoding) {
        String packageAsDir = StringUtils.replace((String)packageName, (String)".", (String)"/");
        ArrayList<FileSet> packagedFileSets = new ArrayList<FileSet>();
        List<String> packagedFiles = this.archetypeFilesResolver.getPackagedFiles(groupFiles, packageAsDir);
        this.getLogger().debug("Found packaged Files:" + packagedFiles);
        List<String> unpackagedFiles = this.archetypeFilesResolver.getUnpackagedFiles(groupFiles, packageAsDir);
        this.getLogger().debug("Found unpackaged Files:" + unpackagedFiles);
        Set<String> packagedExtensions = this.getExtensions(packagedFiles);
        this.getLogger().debug("Found packaged extensions " + packagedExtensions);
        Set<String> unpackagedExtensions = this.getExtensions(unpackagedFiles);
        if (!packagedExtensions.isEmpty()) {
            packagedFileSets.add(this.getPackagedFileSet(filtered, packagedExtensions, group, unpackagedExtensions, unpackagedFiles, defaultEncoding));
        }
        if (!unpackagedExtensions.isEmpty()) {
            this.getLogger().debug("Found unpackaged extensions " + unpackagedExtensions);
            packagedFileSets.add(this.getUnpackagedFileSet(filtered, unpackagedExtensions, unpackagedFiles, group, packagedExtensions, defaultEncoding));
        }
        return packagedFileSets;
    }

    private void setParentArtifactId(Properties properties, String parentArtifactId) {
        properties.setProperty("parentArtifactId", parentArtifactId);
    }

    private void processFileSet(File basedir, File archetypeFilesDirectory, String directory, List<String> fileSetResources, boolean packaged, String packageName, Properties reverseProperties, String defaultEncoding) throws IOException {
        String packageAsDirectory = StringUtils.replace((String)packageName, (String)".", (String)File.separator);
        this.getLogger().debug("Package as Directory: Package:" + packageName + "->" + packageAsDirectory);
        for (String inputFileName : fileSetResources) {
            String initialFilename = packaged ? StringUtils.replace((String)inputFileName, (String)(packageAsDirectory + File.separator), (String)"") : inputFileName;
            this.getLogger().debug("InputFileName:" + inputFileName);
            File inputFile = new File(basedir, inputFileName);
            FileCharsetDetector detector = new FileCharsetDetector(inputFile);
            String fileEncoding = detector.isFound() ? detector.getCharset() : defaultEncoding;
            String initialcontent = IOUtil.toString((InputStream)new FileInputStream(inputFile), (String)fileEncoding);
            for (String string : reverseProperties.keySet()) {
                if (initialcontent.indexOf("${" + string + "}") <= 0) continue;
                this.getLogger().warn("Archetype uses ${" + string + "} for internal processing, but file " + inputFile + " contains this property already");
            }
            String content = this.getReversedContent(initialcontent, reverseProperties);
            String string = this.getReversedFilename(initialFilename, reverseProperties);
            this.getLogger().debug("OutputFileName:" + string);
            File outputFile = new File(archetypeFilesDirectory, string);
            outputFile.getParentFile().mkdirs();
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(outputFile), (String)fileEncoding);
        }
    }

    private Properties getReversedProperties(ArchetypeDescriptor archetypeDescriptor, Properties properties) {
        Properties reversedProperties = new Properties();
        reversedProperties.putAll((Map<?, ?>)properties);
        reversedProperties.remove("archetype.groupId");
        reversedProperties.remove("archetype.artifactId");
        reversedProperties.remove("archetype.version");
        String packageName = properties.getProperty("package");
        String packageInPathFormat = this.getPackageInPathFormat(packageName);
        if (!packageInPathFormat.equals(packageName)) {
            reversedProperties.setProperty("packageInPathFormat", packageInPathFormat);
        }
        return reversedProperties;
    }

    private List<String> resolveFileNames(Model pom, File basedir, List<String> excludePatterns) throws IOException {
        this.getLogger().debug("Resolving files for " + pom.getId() + " in " + basedir);
        StringBuilder buff = new StringBuilder("pom.xml*,archetype.properties*,target/**,");
        for (String module : pom.getModules()) {
            buff.append(',').append(module).append("/**");
        }
        for (String defaultExclude : ListScanner.DEFAULTEXCLUDES) {
            buff.append(',').append(defaultExclude).append("/**");
        }
        for (String excludePattern : excludePatterns) {
            buff.append(',').append(excludePattern);
        }
        String excludes = PathUtils.convertPathForOS(buff.toString());
        List fileNames = FileUtils.getFileNames((File)basedir, (String)"**,.*,**/.*", (String)excludes, (boolean)false);
        this.getLogger().debug("Resolved " + fileNames.size() + " files");
        this.getLogger().debug("Resolved Files:" + fileNames);
        return fileNames;
    }

    private List<FileSet> resolveFileSets(String packageName, List<String> fileNames, List<String> languages, List<String> filtereds, String defaultEncoding) {
        List<String> rootResourcesfiles;
        List<String> secondLevelResourcesfiles;
        List<String> secondLevelSourcesfiles;
        List<String> thirdLevelSourcesfiles;
        List<String> siteFiles;
        List<String> resourcesTestFiles;
        List<String> sourcesTestFiles;
        List<String> resourcesMainFiles;
        ArrayList<FileSet> resolvedFileSets = new ArrayList<FileSet>();
        this.getLogger().debug("Resolving filesets with package=" + packageName + ", languages=" + languages + " and extentions=" + filtereds);
        ArrayList<String> files = new ArrayList<String>(fileNames);
        StringBuilder languageIncludes = new StringBuilder();
        for (String string : languages) {
            languageIncludes.append((languageIncludes.length() == 0 ? "" : ",") + string + "/**");
        }
        this.getLogger().debug("Using languages includes " + languageIncludes);
        StringBuilder filteredIncludes = new StringBuilder();
        for (String filtered : filtereds) {
            filteredIncludes.append((filteredIncludes.length() == 0 ? "" : ",") + "**/" + (filtered.startsWith(".") ? "" : "*.") + filtered);
        }
        this.getLogger().debug("Using filtered includes " + filteredIncludes);
        List<String> list = this.archetypeFilesResolver.findSourcesMainFiles(files, languageIncludes.toString());
        if (!list.isEmpty()) {
            files.removeAll(list);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(list, filteredIncludes.toString());
            list.removeAll(filteredFiles);
            List<String> unfilteredFiles = list;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, true, packageName, false, defaultEncoding));
            }
        }
        if (!(resourcesMainFiles = this.archetypeFilesResolver.findResourcesMainFiles(files, languageIncludes.toString())).isEmpty()) {
            files.removeAll(resourcesMainFiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(resourcesMainFiles, filteredIncludes.toString());
            resourcesMainFiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = resourcesMainFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, false, packageName, false, defaultEncoding));
            }
        }
        if (!(sourcesTestFiles = this.archetypeFilesResolver.findSourcesTestFiles(files, languageIncludes.toString())).isEmpty()) {
            files.removeAll(sourcesTestFiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(sourcesTestFiles, filteredIncludes.toString());
            sourcesTestFiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = sourcesTestFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, true, packageName, false, defaultEncoding));
            }
        }
        if (!(resourcesTestFiles = this.archetypeFilesResolver.findResourcesTestFiles(files, languageIncludes.toString())).isEmpty()) {
            files.removeAll(resourcesTestFiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(resourcesTestFiles, filteredIncludes.toString());
            resourcesTestFiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = resourcesTestFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, false, packageName, false, defaultEncoding));
            }
        }
        if (!(siteFiles = this.archetypeFilesResolver.findSiteFiles(files, languageIncludes.toString())).isEmpty()) {
            files.removeAll(siteFiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(siteFiles, filteredIncludes.toString());
            siteFiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = siteFiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 2, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 2, false, packageName, false, defaultEncoding));
            }
        }
        if (!(thirdLevelSourcesfiles = this.archetypeFilesResolver.findOtherSources(3, files, languageIncludes.toString())).isEmpty()) {
            List<String> thirdLevelResourcesfiles;
            files.removeAll(thirdLevelSourcesfiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(thirdLevelSourcesfiles, filteredIncludes.toString());
            thirdLevelSourcesfiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = thirdLevelSourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, true, packageName, false, defaultEncoding));
            }
            if (!(thirdLevelResourcesfiles = this.archetypeFilesResolver.findOtherResources(3, files, thirdLevelSourcesfiles, languageIncludes.toString())).isEmpty()) {
                files.removeAll(thirdLevelResourcesfiles);
                filteredFiles = this.archetypeFilesResolver.getFilteredFiles(thirdLevelResourcesfiles, filteredIncludes.toString());
                thirdLevelResourcesfiles.removeAll(filteredFiles);
                unfilteredFiles = thirdLevelResourcesfiles;
                if (!filteredFiles.isEmpty()) {
                    resolvedFileSets.addAll(this.createFileSets(filteredFiles, 3, false, packageName, true, defaultEncoding));
                }
                if (!unfilteredFiles.isEmpty()) {
                    resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 3, false, packageName, false, defaultEncoding));
                }
            }
        }
        if (!(secondLevelSourcesfiles = this.archetypeFilesResolver.findOtherSources(2, files, languageIncludes.toString())).isEmpty()) {
            files.removeAll(secondLevelSourcesfiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(secondLevelSourcesfiles, filteredIncludes.toString());
            secondLevelSourcesfiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = secondLevelSourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 2, true, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 2, true, packageName, false, defaultEncoding));
            }
        }
        if (!(secondLevelResourcesfiles = this.archetypeFilesResolver.findOtherResources(2, files, languageIncludes.toString())).isEmpty()) {
            files.removeAll(secondLevelResourcesfiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(secondLevelResourcesfiles, filteredIncludes.toString());
            secondLevelResourcesfiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = secondLevelResourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 2, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 2, false, packageName, false, defaultEncoding));
            }
        }
        if (!(rootResourcesfiles = this.archetypeFilesResolver.findOtherResources(0, files, languageIncludes.toString())).isEmpty()) {
            files.removeAll(rootResourcesfiles);
            List<String> filteredFiles = this.archetypeFilesResolver.getFilteredFiles(rootResourcesfiles, filteredIncludes.toString());
            rootResourcesfiles.removeAll(filteredFiles);
            List<String> unfilteredFiles = rootResourcesfiles;
            if (!filteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(filteredFiles, 0, false, packageName, true, defaultEncoding));
            }
            if (!unfilteredFiles.isEmpty()) {
                resolvedFileSets.addAll(this.createFileSets(unfilteredFiles, 0, false, packageName, false, defaultEncoding));
            }
        }
        if (!files.isEmpty()) {
            this.getLogger().info("Ignored files: " + files);
        }
        return resolvedFileSets;
    }

    private void restoreArtifactId(Properties properties, String artifactId) {
        if (StringUtils.isEmpty((String)artifactId)) {
            properties.remove("artifactId");
        } else {
            properties.setProperty("artifactId", artifactId);
        }
    }

    private void restoreParentArtifactId(Properties properties, String parentArtifactId) {
        if (StringUtils.isEmpty((String)parentArtifactId)) {
            properties.remove("parentArtifactId");
        } else {
            properties.setProperty("parentArtifactId", parentArtifactId);
        }
    }

    private String getReversedContent(String content, Properties properties) {
        String result = StringUtils.replace((String)StringUtils.replace((String)content, (String)"$", (String)"${symbol_dollar}"), (String)"\\", (String)"${symbol_escape}");
        result = this.getReversedPlainContent(result, properties);
        return "#set( $symbol_pound = '#' )\n#set( $symbol_dollar = '$' )\n#set( $symbol_escape = '\\' )\n" + StringUtils.replace((String)result, (String)"#", (String)"${symbol_pound}");
    }

    private String getReversedPlainContent(String content, Properties properties) {
        String result = content;
        for (String string : properties.keySet()) {
            result = StringUtils.replace((String)result, (String)properties.getProperty(string), (String)("${" + string + "}"));
        }
        return result;
    }

    private String getReversedFilename(String filename, Properties properties) {
        String result = filename;
        for (String string : properties.keySet()) {
            result = StringUtils.replace((String)result, (String)properties.getProperty(string), (String)("__" + string + "__"));
        }
        return result;
    }

    private String getTemplateOutputDirectory() {
        return "src" + File.separator + "main" + File.separator + "resources";
    }

    private FileSet getUnpackagedFileSet(boolean filtered, String group, List<String> groupFiles, String defaultEncoding) {
        Set<String> extensions = this.getExtensions(groupFiles);
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String extension : extensions) {
            includes.add("**/*." + extension);
        }
        return this.createFileSet(excludes, false, filtered, group, includes, defaultEncoding);
    }

    private FileSet getUnpackagedFileSet(boolean filtered, Set<String> unpackagedExtensions, List<String> unpackagedFiles, String group, Set<String> packagedExtensions, String defaultEncoding) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String extension : unpackagedExtensions) {
            if (packagedExtensions.contains(extension)) {
                includes.addAll(this.archetypeFilesResolver.getFilesWithExtension(unpackagedFiles, extension));
                continue;
            }
            if (StringUtils.isEmpty((String)extension)) {
                includes.add("**/*");
                continue;
            }
            includes.add("**/*." + extension);
        }
        return this.createFileSet(excludes, false, filtered, group, includes, defaultEncoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getArchetypeVersion() {
        String version = "version";
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(MAVEN_PROPERTIES);){
            Properties properties = new Properties();
            if (is != null) {
                properties.load(is);
                String property = properties.getProperty("version");
                if (property != null) {
                    String string2 = property;
                    return string2;
                }
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            return version;
        }
    }
}

