/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.archetype.source.CatalogArchetypeDataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ArchetypeDataSource.class, hint="remote-catalog")
public class RemoteCatalogArchetypeDataSource
extends CatalogArchetypeDataSource
implements ArchetypeDataSource {
    @Requirement
    private Map<String, Wagon> wagons;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private SettingsDecrypter settingsDecrypter;
    public static final String ARCHETYPE_REPOSITORY_ID = "archetype";
    public static final String CENTRAL_REPOSITORY_ID = "central";
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";

    @Override
    public ArchetypeCatalog getArchetypeCatalog(ProjectBuildingRequest buildingRequest) throws ArchetypeDataSourceException {
        Mirror archetypeMirror = this.getMirror(ARCHETYPE_REPOSITORY_ID);
        String archetypeRepoId = archetypeMirror != null ? archetypeMirror.getId() : ARCHETYPE_REPOSITORY_ID;
        Mirror centralMirror = this.getMirror(CENTRAL_REPOSITORY_ID);
        String centralRepoId = centralMirror != null ? centralMirror.getId() : CENTRAL_REPOSITORY_ID;
        ArtifactRepository centralRepository = null;
        ArtifactRepository archetypeRepository = null;
        for (ArtifactRepository remoteRepository : buildingRequest.getRemoteRepositories()) {
            if (archetypeRepoId.equals(remoteRepository.getId())) {
                archetypeRepository = remoteRepository;
                break;
            }
            if (!centralRepoId.equals(remoteRepository.getId())) continue;
            centralRepository = remoteRepository;
        }
        if (archetypeRepository == null) {
            archetypeRepository = centralRepository;
        }
        try {
            return this.downloadCatalog(archetypeRepository);
        }
        catch (IOException e) {
            throw new ArchetypeDataSourceException(e);
        }
        catch (WagonException e) {
            throw new ArchetypeDataSourceException(e);
        }
    }

    @Override
    public void updateCatalog(ProjectBuildingRequest buildingRequest, Archetype archetype) throws ArchetypeDataSourceException {
        throw new ArchetypeDataSourceException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchetypeCatalog downloadCatalog(ArtifactRepository repository) throws WagonException, IOException, ArchetypeDataSourceException {
        this.getLogger().debug("Searching for remote catalog: " + repository.getUrl() + "/" + "archetype-catalog.xml");
        Repository wagonRepository = new Repository(repository.getId(), repository.getUrl());
        AuthenticationInfo authInfo = this.getAuthenticationInfo(wagonRepository.getId());
        ProxyInfo proxyInfo = this.getProxy(wagonRepository.getProtocol());
        Wagon wagon = this.getWagon(wagonRepository);
        File catalog = File.createTempFile("archetype-catalog", ".xml");
        try {
            wagon.connect(wagonRepository, authInfo, proxyInfo);
            wagon.get("archetype-catalog.xml", catalog);
            ArchetypeCatalog archetypeCatalog = this.readCatalog((Reader)ReaderFactory.newXmlReader((File)catalog));
            return archetypeCatalog;
        }
        finally {
            this.disconnectWagon(wagon);
            catalog.delete();
        }
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (Exception e) {
            this.getLogger().warn("Problem disconnecting from wagon - ignoring: " + e.getMessage());
        }
    }

    private Wagon getWagon(Repository repository) throws UnsupportedProtocolException {
        return this.getWagon(repository.getProtocol());
    }

    private Wagon getWagon(String protocol) throws UnsupportedProtocolException {
        if (protocol == null) {
            throw new UnsupportedProtocolException("Unspecified protocol");
        }
        String hint = protocol.toLowerCase(Locale.ENGLISH);
        Wagon wagon = this.wagons.get(hint);
        if (wagon == null) {
            throw new UnsupportedProtocolException("Cannot find wagon which supports the requested protocol: " + protocol);
        }
        return wagon;
    }

    private AuthenticationInfo getAuthenticationInfo(String id) {
        List servers;
        MavenExecutionRequest request;
        MavenSession session = this.legacySupport.getSession();
        if (session != null && id != null && (request = session.getRequest()) != null && (servers = request.getServers()) != null) {
            for (Server server : servers) {
                if (!id.equalsIgnoreCase(server.getId())) continue;
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
                server = result.getServer();
                AuthenticationInfo authInfo = new AuthenticationInfo();
                authInfo.setUserName(server.getUsername());
                authInfo.setPassword(server.getPassword());
                authInfo.setPrivateKey(server.getPrivateKey());
                authInfo.setPassphrase(server.getPassphrase());
                return authInfo;
            }
        }
        return new AuthenticationInfo();
    }

    private ProxyInfo getProxy(String protocol) {
        List proxies;
        MavenExecutionRequest request;
        MavenSession session = this.legacySupport.getSession();
        if (session != null && protocol != null && (request = session.getRequest()) != null && (proxies = request.getProxies()) != null) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive() || !protocol.equalsIgnoreCase(proxy.getProtocol())) continue;
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxy));
                proxy = result.getProxy();
                ProxyInfo proxyInfo = new ProxyInfo();
                proxyInfo.setHost(proxy.getHost());
                proxyInfo.setType(proxy.getProtocol());
                proxyInfo.setPort(proxy.getPort());
                proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
                proxyInfo.setUserName(proxy.getUsername());
                proxyInfo.setPassword(proxy.getPassword());
                return proxyInfo;
            }
        }
        return null;
    }

    private Mirror getMirror(String repoId) {
        MavenSession session = this.legacySupport.getSession();
        MavenExecutionRequest request = session.getRequest();
        if (request != null) {
            return this.getMirror(repoId, request.getMirrors());
        }
        return null;
    }

    private Mirror getMirror(String repoId, List<Mirror> mirrors) {
        if (repoId != null && mirrors != null) {
            for (Mirror mirror : mirrors) {
                if (!repoId.equals(mirror.getMirrorOf())) continue;
                return mirror;
            }
            for (Mirror mirror : mirrors) {
                if (!RemoteCatalogArchetypeDataSource.matchPattern(repoId, mirror.getMirrorOf())) continue;
                return mirror;
            }
        }
        return null;
    }

    static boolean matchPattern(String originalId, String pattern) {
        boolean result = false;
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!repo.substring(1).equals(originalId)) continue;
                    result = false;
                    break;
                }
                if (repo.equals(originalId)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    static boolean matchesLayout(ArtifactRepository repository, Mirror mirror) {
        return RemoteCatalogArchetypeDataSource.matchesLayout(repository.getLayout().getId(), mirror.getMirrorOfLayouts());
    }

    static boolean matchesLayout(String repoLayout, String mirrorLayout) {
        boolean result = false;
        if (StringUtils.isEmpty((String)mirrorLayout) || WILDCARD.equals(mirrorLayout)) {
            result = true;
        } else if (mirrorLayout.equals(repoLayout)) {
            result = true;
        } else {
            String[] layouts;
            for (String layout : layouts = mirrorLayout.split(",")) {
                if (layout.length() > 1 && layout.startsWith("!")) {
                    if (!layout.substring(1).equals(repoLayout)) continue;
                    result = false;
                    break;
                }
                if (layout.equals(repoLayout)) {
                    result = true;
                    break;
                }
                if (!WILDCARD.equals(layout)) continue;
                result = true;
            }
        }
        return result;
    }
}

