/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.checksum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Named;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;

@Named(value="requireFileChecksum")
public class RequireFileChecksum
extends AbstractStandardEnforcerRule {
    private File file;
    private String checksum;
    private String type;
    private String nonexistentFileMessage;

    public void execute() throws EnforcerRuleException {
        if (this.file == null) {
            throw new EnforcerRuleError("Input file unspecified");
        }
        if (this.type == null) {
            throw new EnforcerRuleError("Hash type unspecified");
        }
        if (this.checksum == null) {
            throw new EnforcerRuleError("Checksum unspecified");
        }
        if (!this.file.exists()) {
            String message = this.nonexistentFileMessage;
            if (message == null) {
                message = "File does not exist: " + this.file.getAbsolutePath();
            }
            throw new EnforcerRuleException(message);
        }
        if (this.file.isDirectory()) {
            throw new EnforcerRuleError("Cannot calculate the checksum of directory: " + this.file.getAbsolutePath());
        }
        if (!this.file.canRead()) {
            throw new EnforcerRuleError("Cannot read file: " + this.file.getAbsolutePath());
        }
        String checksum = this.calculateChecksum();
        if (!checksum.equalsIgnoreCase(this.checksum)) {
            String exceptionMessage = this.getMessage();
            if (exceptionMessage == null) {
                exceptionMessage = this.type + " hash of " + this.file + " was " + checksum + " but expected " + this.checksum;
            }
            throw new EnforcerRuleException(exceptionMessage);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setNonexistentFileMessage(String nonexistentFileMessage) {
        this.nonexistentFileMessage = nonexistentFileMessage;
    }

    public String getNonexistentFileMessage() {
        return this.nonexistentFileMessage;
    }

    protected String calculateChecksum() throws EnforcerRuleException {
        String string;
        block8: {
            InputStream inputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            try {
                string = this.calculateChecksum(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EnforcerRuleError("Unable to calculate checksum", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    protected String calculateChecksum(InputStream inputStream) throws IOException, EnforcerRuleException {
        String result;
        if ("md5".equals(this.type)) {
            result = DigestUtils.md5Hex((InputStream)inputStream);
        } else if ("sha1".equals(this.type)) {
            result = DigestUtils.sha1Hex((InputStream)inputStream);
        } else if ("sha256".equals(this.type)) {
            result = DigestUtils.sha256Hex((InputStream)inputStream);
        } else if ("sha384".equals(this.type)) {
            result = DigestUtils.sha384Hex((InputStream)inputStream);
        } else if ("sha512".equals(this.type)) {
            result = DigestUtils.sha512Hex((InputStream)inputStream);
        } else {
            throw new EnforcerRuleError("Unsupported hash type: " + this.type);
        }
        return result;
    }

    public String toString() {
        return String.format("RequireFileChecksum[message=%s, file=%s, checksum=%s, type=%s, nonexistentFileMessage=%s]", this.getMessage(), this.file, this.checksum, this.type, this.nonexistentFileMessage);
    }
}

