/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="update-local-catalog", defaultPhase=LifecyclePhase.INSTALL)
public class UpdateLocalCatalogMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ArchetypeManager manager;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Archetype archetype = new Archetype();
        archetype.setGroupId(this.project.getGroupId());
        archetype.setArtifactId(this.project.getArtifactId());
        archetype.setVersion(this.project.getVersion());
        if (StringUtils.isNotEmpty((String)this.project.getDescription())) {
            archetype.setDescription(this.project.getDescription());
        } else {
            archetype.setDescription(this.project.getName());
        }
        this.manager.updateLocalCatalog(this.session.getProjectBuildingRequest(), archetype);
    }
}

